/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final boolean debugCache = false;
    private static final String separator = System.getProperty("file.separator");
    private String currentFilename = "";
    public static String temp_dir = "";
    private String cmyk_dir = temp_dir + "cmyk" + separator;
    private String key = "jpedal" + Math.random() + '_';
    private Map image_type = new Hashtable();
    private Map tempFileNames = new HashMap();
    public String fullFileName;
    private static Map pagesOnDisk = new HashMap();
    private static Map pagesOnDiskAsBytes = new HashMap();

    public ObjectStore() {
        try {
            File file;
            if (temp_dir.length() == 0) {
                temp_dir = System.getProperty("java.io.tmpdir") + separator + "jpedal" + separator;
            }
            if (!(file = new File(temp_dir)).exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir);
        }
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public final void storeFileName(String string) {
        this.fullFileName = string;
        int n = string.indexOf(92);
        if (n == -1) {
            n = string.indexOf(47);
        }
        while (n != -1) {
            if ((n = (string = string.substring(n + 1)).indexOf(92)) != -1) continue;
            n = string.indexOf(47);
        }
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        string = Strip.stripAllSpaces(string);
        this.currentFilename = string.toLowerCase();
    }

    public boolean saveRawCMYKImage(byte[] byArray, String string) {
        boolean bl = true;
        File file = new File(this.cmyk_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.cmyk_dir + string + ".jpg");
            this.tempFileNames.put(this.cmyk_dir + string + ".jpg", "#");
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to save CMYK jpeg " + string);
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean saveStoredImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2, String string2) {
        boolean bl3 = false;
        int n = bufferedImage.getType();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (string2.indexOf("tif") != -1) {
            if (n == 1 | n == 2 && string.indexOf("HIRES_") == -1) {
                bufferedImage = ColorSpaceConvertor.convertColorspace(bufferedImage, 5);
            }
            if (!bl) {
                this.image_type.put(string, "tif");
            }
            bl3 = this.saveStoredImage("TIFF", ".tif", ".tiff", string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("jpg") != -1) {
            if (!bl) {
                this.image_type.put(string, "jpg");
            }
            bl3 = this.saveStoredJPEGImage(string, bufferedImage, bl, bl2);
        } else if (string2.indexOf("png") != -1) {
            if (!bl) {
                this.image_type.put(string, "png");
            }
            bl3 = this.saveStoredImage("PNG", ".png", ".png", string, bufferedImage, bl, bl2);
        }
        bufferedImage = null;
        return bl3;
    }

    public final String getImageType(String string) {
        return (String)this.image_type.get(string);
    }

    public final void init(String string) {
        this.key = string + System.currentTimeMillis();
        File file = new File(temp_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final synchronized BufferedImage loadStoredImage(String string) {
        String string2 = (String)this.image_type.get(string);
        BufferedImage bufferedImage = null;
        if (string2 == null) {
            return null;
        }
        if (string2.equals("tif")) {
            bufferedImage = this.loadStoredImage(string, ".tif");
        } else if (string2.equals("jpg")) {
            bufferedImage = this.loadStoredJPEGImage(string);
        } else if (string2.equals("png")) {
            bufferedImage = this.loadStoredImage(string, ".png");
        }
        return bufferedImage;
    }

    public final synchronized boolean isImageCached(String string) {
        String string2 = (String)this.image_type.get(string);
        Object var3_3 = null;
        if (string2 == null) {
            return false;
        }
        String string3 = temp_dir + this.key + string + '.' + string2;
        File file = new File(string3);
        return file.exists();
    }

    public final void flush() {
        File file;
        if (temp_dir.length() > 2) {
            file = new File(temp_dir);
            String[] stringArray = file.list();
            File[] fileArray = file.listFiles();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].indexOf(this.key) != -1) {
                        File file2 = new File(temp_dir + stringArray[i]);
                        file2.delete();
                    }
                    boolean bl = true;
                    long l = 14400000L;
                    if (!bl || System.currentTimeMillis() - fileArray[i].lastModified() < l) continue;
                    fileArray[i].delete();
                }
            }
        }
        if ((file = new File(this.cmyk_dir)).exists()) {
            file.delete();
            file = null;
        }
    }

    public void copyCMYKimages(String string) {
        File file = new File(this.cmyk_dir);
        if (file.exists()) {
            String[] stringArray = file.list();
            if (stringArray.length > 0) {
                File file2;
                if (!string.endsWith(separator)) {
                    string = string + separator;
                }
                if (!(file2 = new File(string)).exists()) {
                    file2.mkdirs();
                }
                file2 = null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(this.cmyk_dir + stringArray[i]);
                File file4 = new File(string + stringArray[i]);
                file3.renameTo(file4);
            }
        }
        file = null;
    }

    private final synchronized boolean saveStoredJPEGImage(String string, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        JPEGImageEncoder jPEGImageEncoder;
        BufferedOutputStream bufferedOutputStream;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = string;
        String string3 = "";
        if (!bl) {
            string2 = temp_dir + this.key + string;
            string3 = temp_dir + this.key + 'R' + string;
            this.image_type.put('R' + string, this.image_type.get(string));
        }
        if (!string2.toLowerCase().endsWith(".jpg") & !string2.toLowerCase().endsWith(".jpeg")) {
            string2 = string2 + ".jpg";
            string3 = string3 + ".jpg";
        }
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
            jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            this.tempFileNames.put(string2, "#");
            bufferedOutputStream.close();
            bl4 = true;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage + " as " + string2);
        }
        if (!bl4) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
                this.tempFileNames.put(string2, "#");
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                bl3 = true;
                LogWriter.writeLog("Exception " + exception + " writing image " + bufferedImage);
            }
        }
        if (bl2) {
            this.saveCopy(string2, string3);
            this.tempFileNames.put(string3, "#");
        }
        return bl3;
    }

    public String getFileForCachedImage(String string) {
        return temp_dir + this.key + string + '.' + this.image_type.get(string);
    }

    private final synchronized BufferedImage loadStoredImage(String string, String string2) {
        String string3 = temp_dir + this.key + string + string2;
        BufferedImage bufferedImage = null;
        if (JAIHelper.isJAIused()) {
            try {
                JAIHelper.confirmJAIOnClasspath();
                bufferedImage = JAI.create((String)"fileload", (Object)string3).getAsBufferedImage();
            }
            catch (Exception exception) {}
        } else {
            try {
                bufferedImage = ImageIO.read(new File(string3));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bufferedImage;
    }

    private final void saveCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
        bufferedOutputStream = null;
        bufferedInputStream = null;
    }

    public final void saveAsCopy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        String string3 = temp_dir + this.key + string;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    public static final void copy(String string, String string2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[65535];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " copying file");
        }
        try {
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing files");
        }
    }

    private final synchronized BufferedImage loadStoredJPEGImage(String string) {
        String string2 = temp_dir + this.key + string + ".jpg";
        BufferedImage bufferedImage = null;
        File file = new File(string2);
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + string);
            }
        } else {
            bufferedImage = new BufferedImage(100, 100, 1);
        }
        return bufferedImage;
    }

    private final synchronized boolean saveStoredImage(String string, String string2, String string3, String string4, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        boolean bl3 = false;
        String string5 = string4;
        String string6 = "";
        if (!bl) {
            string5 = temp_dir + this.key + string4;
            string6 = temp_dir + this.key + 'R' + string4;
            this.image_type.put('R' + string4, this.image_type.get(string4));
        }
        if (!string5.toLowerCase().endsWith(string2) & !string5.toLowerCase().endsWith(string3)) {
            string5 = string5 + string2;
            string6 = string6 + string2;
        }
        try {
            if (JAIHelper.isJAIused()) {
                JAIHelper.confirmJAIOnClasspath();
                JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)string);
            } else {
                ImageIO.setUseCache(false);
                FileOutputStream fileOutputStream = new FileOutputStream(string5);
                if (string.equals("TIFF")) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
                } else {
                    ImageIO.write((RenderedImage)bufferedImage, string, fileOutputStream);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            this.tempFileNames.put(string5, "#");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog(" Exception " + exception + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " writing image " + bufferedImage + " with type " + bufferedImage.getType());
            bl3 = true;
            bufferedImage = null;
        }
        if (bl2) {
            this.saveCopy(string5, string6);
            this.tempFileNames.put(string6, "#");
        }
        return bl3;
    }

    public static void flushPages() {
        File file;
        Object k;
        Iterator iterator = pagesOnDisk.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (k == null) continue;
            file = new File((String)pagesOnDisk.get(k));
            file.delete();
        }
        pagesOnDisk.clear();
        iterator = pagesOnDiskAsBytes.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            if (k == null) continue;
            file = new File((String)pagesOnDiskAsBytes.get(k));
            file.delete();
        }
        pagesOnDiskAsBytes.clear();
    }

    public static DynamicVectorRenderer getCachedPage(Integer n) {
        DynamicVectorRenderer dynamicVectorRenderer = null;
        Object v = pagesOnDisk.get(n);
        if (v != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                File file = new File((String)v);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
                dynamicVectorRenderer = new DynamicVectorRenderer(byArray, new HashMap());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return dynamicVectorRenderer;
    }

    public static void cachePage(Integer n, DynamicVectorRenderer dynamicVectorRenderer) {
        try {
            File file = File.createTempFile("page", ".bin");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(dynamicVectorRenderer.serializeToByteArray(null));
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            pagesOnDisk.put(n, file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static byte[] getCachedPageAsBytes(String string) {
        byte[] byArray = null;
        Object v = pagesOnDiskAsBytes.get(string);
        if (v != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                File file = new File((String)v);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public static void cachePageAsBytes(String string, byte[] byArray) {
        try {
            File file = File.createTempFile("bytes", ".bin");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            pagesOnDiskAsBytes.put(string, file.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception " + exception);
        }
    }
}

