/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.SetSecurity;
import org.jpedal.io.TextTokens;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfReader
extends PdfFilteredReader
implements PdfObjectReader,
Serializable {
    private int startStreamPointer;
    private int endStreamPointer;
    private boolean debugAES = false;
    private byte[] lastCompressedStream = null;
    private Map fields = new HashMap();
    private Vector_Int xref = new Vector_Int(100);
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private int lastFirst;
    private Map objData = null;
    private Map nameLookup = new HashMap();
    private String lastRef = "";
    PdfFileInformation currentFileInformation = new PdfFileInformation();
    private static final String pattern = "obj";
    private boolean extractionIsAllowed = true;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private static final byte[] endStream = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private boolean isEncrypted = false;
    private boolean isInitialised = false;
    private byte[] encryptionPassword = new byte[0];
    private String infoObject = null;
    private byte[] encryptionKey = null;
    private boolean isFileViewable = true;
    private int rev = 0;
    private int keyLength = 5;
    private int P = 0;
    private byte[] O = new byte[0];
    private byte[] U = new byte[0];
    private String ID = "";
    private boolean isPasswordSupplied = false;
    private Cipher cipher = null;
    private String[] padding = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private int[] ObjLengthTable;
    private boolean refTableInvalid = false;
    private static final boolean testOp = false;
    private int miniumumCacheSize;
    public boolean interruptRefReading = false;
    String EFF;
    String CFM;
    boolean isMetaDataEncypted = true;
    Map StrF;
    Map StmF;
    boolean stringsEncoded = false;
    String StrFname;
    String StmFname;
    private int passwordStatus = 0;
    private Javascript javascript;
    private static boolean alwaysReinitCipher = false;
    private static final int[] powers;

    public PdfReader() {
        this.fields.put("T", "x");
        this.fields.put("TM", "x");
        this.fields.put("TU", "x");
        this.fields.put("CA", "x");
        this.fields.put("R", "x");
        this.fields.put("V", "x");
        this.fields.put("RC", "x");
        this.fields.put("DA", "x");
        this.fields.put("DV", "x");
        this.fields.put("JS", "x");
        this.fields.put("Contents", "x");
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public final int readFirstStartRef() throws PdfException {
        int n;
        this.refTableInvalid = false;
        int n2 = -1;
        int n3 = 1019;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 1024;
        byte[] byArray = new byte[n4];
        int[] nArray = new int[]{37, 37, 69, 79, 70};
        int n5 = 4;
        boolean bl = false;
        try {
            int n6;
            long l;
            block19: {
                l = this.pdf_datafile.length();
                n = 255;
                do {
                    byte[] byArray2 = new byte[n];
                    this.movePointer(l - (long)n);
                    this.pdf_datafile.read(byArray2);
                    n6 = 0;
                    for (int i = n - 1; i > -1; --i) {
                        if (!bl) {
                            n5 = 4;
                        }
                        if (byArray2[i] == nArray[n5]) {
                            --n5;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        --n6;
                        if (n5 >= 0) continue;
                        i = -1;
                    }
                    if (n5 >= 0) continue;
                    l -= (long)n6;
                    break block19;
                } while ((l -= (long)n) >= 0L);
                l = this.pdf_datafile.length();
            }
            int n7 = (int)(l - (long)n4);
            if (n7 < 0) {
                n7 = 0;
                n6 = (int)this.pdf_datafile.length();
                byArray = new byte[n6];
                n3 = n6 + 3;
            }
            this.movePointer(n7);
            this.pdf_datafile.read(byArray);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        n = byArray.length;
        if (n3 > n) {
            n3 = n - 5;
        }
        while (n3 > -1 && (byArray[n3] != 116 || byArray[n3 + 1] != 120 || byArray[n3 + 2] != 114 || byArray[n3 + 3] != 101 || byArray[n3 + 4] != 102)) {
            --n3;
        }
        if (n3 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        n3 += 5;
        while (n3 < 1024 && byArray[n3] == 10 | byArray[n3] == 32 | byArray[n3] == 13) {
            ++n3;
        }
        while (n3 < 1024 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            n2 = Integer.parseInt(stringBuffer.toString());
        }
        if (n2 == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return n2;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string.getBytes();
    }

    public Map directValuesToMap(String string, boolean bl) {
        int n = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<Integer, HashMap<String, Object>> hashMap2 = new HashMap<Integer, HashMap<String, Object>>();
        int n2 = string.indexOf("<<");
        int n3 = string.lastIndexOf(">>");
        String string2 = string.substring(n2 + 2, n3).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            Map map;
            String string3;
            String string4;
            String string5 = stringTokenizer.nextToken().trim();
            int n4 = string5.indexOf(32);
            if (n4 == -1) {
                string4 = string5;
                string3 = '/' + stringTokenizer.nextToken().trim();
            } else {
                string4 = string5.substring(0, n4);
                string3 = string5.substring(n4 + 1);
            }
            if (bl) {
                string4 = '/' + string4;
            }
            if (string3.equals("<<")) {
                map = new HashMap();
                hashMap.put(string4, map);
                hashMap2.put(new Integer(n), hashMap);
                hashMap = map;
                ++n;
                continue;
            }
            if (string3.endsWith(">>")) {
                string3 = string3.substring(0, string3.length() - 2);
                if ((map = (Map)hashMap2.get(new Integer(--n))) != null) {
                    hashMap = map;
                }
            }
            hashMap.put(string4, string3);
        }
        return hashMap;
    }

    public Object resolveToMapOrString(String string, Object object) {
        if (this.fields != null && this.fields.get(string) != null && object instanceof byte[]) {
            byte[] byArray = this.getByteTextStringValue(object, this.fields);
            object = this.getTextString(byArray);
        } else if (object instanceof String && ((String)object).endsWith(" R")) {
            Object object2 = this.getObjectValue(object);
            if (object2 instanceof Map) {
                Map map = (Map)object2;
                this.readStream((String)object, true);
                object = map;
            } else {
                object = object2;
            }
        }
        return object;
    }

    private byte[] readObjectDataTEST(int n, boolean bl) {
        boolean bl2 = false;
        if (!bl2) {
            return this.readObjectData(n);
        }
        byte[] byArray = this.readObjectData(n);
        return null;
    }

    private byte[] readObjectData(int n) {
        int n2 = n;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n < 1) {
            bl3 = true;
            n = 128;
        }
        if (this.miniumumCacheSize != -1 && n > this.miniumumCacheSize) {
            n = this.miniumumCacheSize;
        }
        this.startStreamPointer = -1;
        this.endStreamPointer = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.miniumumCacheSize;
        boolean bl4 = this.miniumumCacheSize != -1;
        int n11 = 0;
        byte[] byArray = null;
        if (bl4) {
            byArray = new byte[n10];
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        boolean bl5 = false;
        boolean bl6 = false;
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n12;
            byte by = 0;
            int n13 = n - 1;
            int n14 = -n;
            int n15 = 0;
            int n16 = -1;
            int n17 = -1;
            while (true) {
                int n18;
                if (++n13 == n) {
                    if (!bl4) {
                        if (n15 == 1) {
                            byArray4 = byArray3;
                        } else if (n15 > 1) {
                            n12 = byArray4.length;
                            n18 = byArray3.length;
                            byte[] byArray5 = new byte[n12 + n18];
                            System.arraycopy(byArray4, 0, byArray5, 0, n12);
                            System.arraycopy(byArray3, 0, byArray5, n12, n18);
                            byArray4 = byArray5;
                        }
                        ++n15;
                    }
                    if ((l = this.getPointer()) + (long)n > this.eof) {
                        n = (int)(this.eof - l);
                    }
                    byArray3 = new byte[n += 6];
                    this.pdf_datafile.read(byArray3);
                    n14 += n13;
                    n13 = 0;
                }
                byte by2 = by;
                by = byArray3[n13];
                boolean bl7 = false;
                if (by == 37) {
                    n17 = n3;
                }
                n4 = by == endPattern[n4] && !bl5 ? ++n4 : 0;
                n5 = bl2 && by == endObj[n5] && !bl5 ? ++n5 : 0;
                if (!bl && n2 != -1) {
                    if (!bl2 && by == lengthString[n6] && !bl5) {
                        if (++n6 == 6) {
                            bl = true;
                        }
                    } else {
                        n6 = 0;
                    }
                }
                if (bl4) {
                    if (!bl5 && by == 62 && by2 == 62) {
                        bl6 = false;
                    }
                    if (!bl5) {
                        n7 = n7 < 6 && by == startStream[n7] && !bl6 ? ++n7 : 0;
                        if (n7 == 6) {
                            bl5 = true;
                            bl2 = true;
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.write(by);
                            }
                            if (this.startStreamPointer == -1) {
                                bl7 = true;
                                n7 = 0;
                                n11 = n13 + 1;
                                if (byArray3[n11] == 13 && byArray3[n11 + 1] == 10) {
                                    n11 += 2;
                                } else if (byArray3[n11] == 10 | byArray3[n11] == 13) {
                                    ++n11;
                                }
                                this.startStreamPointer = (int)((long)n11 + l);
                            }
                            n11 += n14;
                        }
                    } else {
                        if (n9 < n10) {
                            byArray[n9] = by;
                            ++n9;
                            bl7 = true;
                        }
                        if (by == endStream[n8] && !bl6) {
                            ++n8;
                        } else {
                            n8 = 0;
                            if (by == endStream[n8] && !bl6) {
                                ++n8;
                            }
                        }
                        if (n8 == 9) {
                            n8 = 0;
                            n12 = n13 - 9;
                            if (n9 < n10) {
                                for (n18 = 0; n18 < n9; ++n18) {
                                    byteArrayOutputStream.write(byArray[n18]);
                                }
                                this.startStreamPointer = -1;
                            }
                            if (this.startStreamPointer != -1) {
                                this.endStreamPointer = (int)((long)n12 + l);
                            }
                            if (this.endStreamPointer < this.startStreamPointer) {
                                this.startStreamPointer = -1;
                                this.endStreamPointer = -1;
                            }
                            bl5 = false;
                            bl7 = true;
                        }
                    }
                    if (!bl5 && by == 60 && by2 == 60) {
                        bl6 = true;
                    }
                }
                if (n4 == 6 || n5 == 4) {
                    if (!bl) break;
                    n4 = 0;
                    n5 = 0;
                    n16 = n3;
                }
                if (bl && n3 >= n2) break;
                if (bl4) {
                    byteArrayOutputStream.write(by);
                }
                ++n3;
            }
            if (bl4) {
                byteArrayOutputStream.close();
                byArray2 = byteArrayOutputStream.toByteArray();
            } else {
                if (n15 == 1) {
                    byArray2 = new byte[n13];
                    System.arraycopy(byArray3, 0, byArray2, 0, n13);
                } else {
                    n12 = byArray4.length;
                    byArray2 = new byte[n12 + n13];
                    System.arraycopy(byArray4, 0, byArray2, 0, n12);
                    System.arraycopy(byArray3, 0, byArray2, n12, n13);
                }
                if (bl && n16 != -1 && n17 != -1 && n17 > n16) {
                    byte[] byArray6 = new byte[n16];
                    System.arraycopy(byArray2, 0, byArray6, 0, n16);
                    byArray2 = byArray6;
                }
            }
            if (this.startStreamPointer != -1) {
                // empty if block
            }
            if (!bl4 && !bl) {
                byArray2 = this.checkEndObject(byArray2, l3, l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        return byArray2;
    }

    private byte[] checkEndObject(byte[] byArray, long l, long l2) {
        int n = 0;
        for (int i = 0; i < byArray.length - 8; ++i) {
            if (n < 2 && byArray[i] == 32 && byArray[i + 1] == 111 && byArray[i + 2] == 98 && byArray[i + 3] == 106) {
                ++n;
                l = i;
            }
            if (n >= 2 || byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
            l2 = i + 9;
        }
        if (l2 > 0L && l > l2) {
            byte[] byArray2 = new byte[(int)l2];
            System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
            byArray = byArray2;
        }
        return byArray;
    }

    private void verifyCachedData(boolean bl, byte[] byArray, int n) throws IOException {
        try {
            int n2 = this.endStreamPointer - this.startStreamPointer;
            if (n2 < 0) {
                System.out.println("Array size negative " + n2);
                System.out.println(this.startStreamPointer + " " + this.endStreamPointer);
                System.out.println(" ");
                for (int i = 0; i < this.startStreamPointer + 30; ++i) {
                    System.err.println(i + " " + (char)byArray[i]);
                }
                System.exit(1);
            }
            byte[] byArray2 = new byte[n2];
            this.movePointer(this.startStreamPointer);
            this.pdf_datafile.read(byArray2);
            n2 = byArray2.length;
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i + n] == byArray2[i]) continue;
                System.out.println("X1 Not same value at " + i + " ==" + byArray[i + n] + ' ' + byArray2[i]);
                bl2 = true;
                System.exit(1);
            }
            if (bl2) {
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public int readDictionary(String string, int n, Map map, int n2, byte[] byArray, boolean bl, Map map2, int n3) {
        boolean bl2 = false;
        Object var11_10 = null;
        StringBuffer stringBuffer = new StringBuffer(20);
        while (!(++n2 >= byArray.length || n3 != -1 && n2 >= n3 || byArray[n2] == 62 && byArray[n2 + 1] == 62 || byArray[n2] == 101 && byArray[n2 + 1] == 110 && byArray[n2 + 2] == 100 && byArray[n2 + 3] == 111)) {
            int n4;
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                ++n2;
                HashMap hashMap = new HashMap();
                map.put(stringBuffer.toString(), hashMap);
                n2 = this.readDictionary(string, ++n, hashMap, n2, byArray, bl, map2, n3);
                stringBuffer = new StringBuffer(20);
                --n;
                if (byArray[n2] != 62 || byArray[n2 + 1] != 62) continue;
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 && byArray[n2 + 1] == 47 && stringBuffer.length() == 0) {
                stringBuffer = new StringBuffer(32);
                ++n2;
                continue;
            }
            if (byArray[n2] == 47 & stringBuffer.length() == 0) {
                stringBuffer = new StringBuffer(20);
                ++n2;
                while (byArray[n2] != 32 && byArray[n2] != 13 && byArray[n2] != 9 && byArray[n2] != 10 && byArray[n2] != 91 && byArray[n2] != 47 && byArray[n2] != 40 && byArray[n2] != 60) {
                    if (byArray[n2] == 35) {
                        // empty if block
                    }
                    stringBuffer.append((char)byArray[n2]);
                    ++n2;
                }
                if (byArray[n2] == 32 && byArray[n2 - 1] == 47) {
                    stringBuffer.append(' ');
                }
                bl2 = map2 != null && stringBuffer.length() > 0 && map2.containsKey(stringBuffer.toString());
                if (!(byArray[n2] == 47 | byArray[n2] == 40 | byArray[n2] == 60 | byArray[n2] == 91)) continue;
                --n2;
                continue;
            }
            if (byArray[n2] == 32 | byArray[n2] == 13 | byArray[n2] == 10) continue;
            if (byArray[n2] == 60 && bl2) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = null;
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n5 = 0;
                int n6 = ++n2;
                do {
                    n6 += 2;
                    ++n5;
                    while (byArray[n6] == 13 | byArray[n6] == 10) {
                        ++n6;
                    }
                } while (byArray[n6] != 62);
                byte[] byArray2 = new byte[n5];
                n5 = 0;
                do {
                    object = new StringBuffer(2);
                    for (n4 = 0; n4 < 2; ++n4) {
                        ((StringBuffer)object).append((char)byArray[n2]);
                        ++n2;
                    }
                    byteArrayOutputStream.write(Integer.parseInt(((StringBuffer)object).toString(), 16));
                    byArray2[n5] = (byte)Integer.parseInt(((StringBuffer)object).toString(), 16);
                    ++n5;
                    while (byArray[n2] == 13 | byArray[n2] == 10) {
                        ++n2;
                    }
                } while (byArray[n2] != 62);
                try {
                    byteArrayOutputStream.close();
                    object = byteArrayOutputStream.toByteArray();
                    if (byArray2.length != ((Object)object).length) {
                        System.out.println("Different lengths " + byArray2.length + ' ' + ((Object)object).length);
                        System.exit(1);
                    }
                    for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                        if (object[n4] == byArray2[n4]) continue;
                        System.out.println(n4 + " Different values " + (int)object[n4] + ' ' + byArray2[n4]);
                        System.exit(1);
                    }
                    byArray2 = this.decrypt(byArray2, string, false, null, false, false);
                    map.put(stringBuffer.toString(), byArray2);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] Problem " + exception + " writing text string" + stringBuffer);
                    exception.printStackTrace();
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 40) {
                block138: {
                    if (bl2) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try {
                            if (byArray[n2 + 1] != 41) {
                                while (true) {
                                    boolean bl3 = false;
                                    if (byArray[++n2] == 92) {
                                        if (byArray[++n2] == 98) {
                                            byArray[n2] = 8;
                                        } else if (byArray[n2] == 110) {
                                            byArray[n2] = 10;
                                        } else if (byArray[n2] == 116) {
                                            byArray[n2] = 9;
                                        } else if (byArray[n2] == 114) {
                                            byArray[n2] = 13;
                                        } else if (byArray[n2] == 102) {
                                            byArray[n2] = 12;
                                        } else if (byArray[n2] == 92) {
                                            byArray[n2] = 92;
                                        } else if (Character.isDigit((char)byArray[n2])) {
                                            StringBuffer stringBuffer2 = new StringBuffer(3);
                                            for (int i = 0; i < 3; ++i) {
                                                stringBuffer2.append((char)byArray[n2]);
                                                ++n2;
                                            }
                                            bl3 = true;
                                            byArray[--n2] = (byte)Integer.parseInt(stringBuffer2.toString(), 8);
                                        }
                                    }
                                    if (!bl3 && byArray[n2] == 41 && byArray[n2 - 1] != 92 | (byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                    byteArrayOutputStream.write(byArray[n2]);
                                }
                            }
                            byteArrayOutputStream.close();
                            byte[] byArray3 = byteArrayOutputStream.toByteArray();
                            byArray3 = this.decrypt(byArray3, string, false, null, false, true);
                            if (stringBuffer.toString().equals("Dest")) {
                                String string2 = this.getTextString(byArray3);
                                map.put(stringBuffer.toString(), this.nameLookup.get(string2));
                                break block138;
                            }
                            map.put(stringBuffer.toString(), byArray3);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("[PDF] Problem " + exception + " handling text string" + stringBuffer);
                        }
                    } else if (bl && stringBuffer.length() == 1 && stringBuffer.charAt(0) == 'U' | stringBuffer.charAt(0) == 'O') {
                        int n7 = 32;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        do {
                            int n8;
                            if ((n8 = byArray[++n2]) == 92) {
                                if ((n8 = byArray[++n2]) == 114) {
                                    n8 = 13;
                                } else if (n8 == 110) {
                                    n8 = 10;
                                } else if (n8 == 116) {
                                    n8 = 9;
                                } else if (n8 == 102) {
                                    n8 = 12;
                                } else if (n8 == 98) {
                                    n8 = 8;
                                } else if (n8 > 47 && n8 < 58) {
                                    StringBuffer stringBuffer3 = new StringBuffer(3);
                                    for (int i = 0; i < 3; ++i) {
                                        stringBuffer3.append((char)byArray[n2 + i]);
                                    }
                                    n2 += 2;
                                    n8 = (byte)Integer.parseInt(stringBuffer3.toString(), 8);
                                }
                            }
                            byteArrayOutputStream.write(n8);
                        } while (--n7 != 0);
                        try {
                            byteArrayOutputStream.close();
                            map.put(stringBuffer.toString(), byteArrayOutputStream.toByteArray());
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("[PDF] Problem " + exception + " writing " + stringBuffer);
                        }
                    } else {
                        int n9 = n2;
                        int n10 = 0;
                        boolean bl4 = false;
                        while (true) {
                            if (!bl4) {
                                ++n10;
                            }
                            if ((byArray[n2 - 1] != 92 || byArray[n2 - 2] == 92) && byArray[n2] == 41) break;
                            if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                            bl4 = true;
                        }
                        bl4 = false;
                        int n11 = 0;
                        char[] cArray = new char[n10];
                        while (true) {
                            if (!bl4) {
                                if (byArray[n9] == 13 | byArray[n9] == 10) {
                                    cArray[n11] = 32;
                                    ++n11;
                                } else {
                                    cArray[n11] = (char)byArray[n9];
                                    ++n11;
                                }
                            }
                            if (byArray[n9] != 92 && byArray[n9 - 1] == 92 && byArray[n9 - 2] == 92) {
                                byArray[n9 - 1] = 0;
                            }
                            if (byArray[n9 - 1] != 92 & byArray[n9] == 41) break;
                            if (byArray[++n9] != 37 || byArray[n9 - 1] == 92) continue;
                            bl4 = true;
                        }
                        String string3 = String.copyValueOf(cArray, 0, n10);
                        if (!string3.equals("null")) {
                            map.put(stringBuffer.toString(), string3);
                        }
                    }
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 91 && this.isFDF) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (true) {
                    if (byArray[n2 + 1] != 60 && byArray[n2 + 2] != 60 && byArray[n2] != 93) {
                        ++n2;
                        continue;
                    }
                    int n12 = n2;
                    while (byArray[n12 + 1] != 62 && byArray[n12 + 2] != 62 && byArray[n12] != 93) {
                        ++n12;
                    }
                    if (byArray[n2] == 93) break;
                    HashMap hashMap2 = new HashMap();
                    n2 = this.readDictionary(string, 1, hashMap2, n2 + 2, byArray, bl, map2, n12);
                    --n2;
                    --n2;
                    String string4 = null;
                    String string5 = "";
                    byte[] byArray4 = this.getByteTextStringValue(hashMap2.get("T"), hashMap2);
                    if (byArray4 != null) {
                        string4 = this.getTextString(byArray4);
                    }
                    if ((byArray4 = this.getByteTextStringValue(hashMap2.get("V"), hashMap2)) != null) {
                        string5 = this.getTextString(byArray4);
                    }
                    if (string4 == null) continue;
                    hashMap.put(string4, string5);
                }
                map.put(stringBuffer.toString(), hashMap);
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 91) {
                Object object;
                int n13 = n2;
                int n14 = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                int n15 = 0;
                int n16 = 0;
                n4 = 32;
                int n17 = 32;
                boolean bl7 = false;
                while (byArray[n2] == 32) {
                    ++n14;
                    ++n2;
                }
                while (true) {
                    if (byArray[n2] == 92) {
                        ++n2;
                    }
                    if (n14 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 && byArray[n2 - 1] != 92 && bl7) {
                        bl6 = true;
                        n14 += 2;
                    } else if (bl6) {
                        if (byArray[n2] == 41 && byArray[n2 - 1] != 92) {
                            ++n14;
                            bl6 = false;
                        } else {
                            object = Integer.toHexString(byArray[n2] & 0xFF);
                            if (((String)object).length() < 2) {
                                ++n14;
                            }
                            n14 += ((String)object).length();
                        }
                    } else if (!bl5) {
                        if (byArray[n2] == 13 || byArray[n2] == 10) {
                            ++n14;
                        } else {
                            n4 = (char)byArray[n2];
                            if (n4 == 47 && n17 != 32) {
                                ++n14;
                            }
                            if (n4 != 32 && n17 == 41) {
                                ++n14;
                            }
                            ++n14;
                            n17 = n4;
                        }
                    }
                    if (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92) {
                        if (byArray[n2] == 40) {
                            ++n16;
                        } else if (byArray[n2] == 41) {
                            --n16;
                        }
                        if (n16 == 0) {
                            if (byArray[n2] == 91) {
                                ++n15;
                            } else if (byArray[n2] == 93) {
                                --n15;
                            }
                        }
                    }
                    if (n15 == 0 && byArray[n2 - 1] != 92 && byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n15 != 0) continue;
                    bl5 = true;
                }
                object = new char[n14 * 2];
                int n18 = 0;
                n2 = n13;
                while (byArray[n2] == 32) {
                    object[n18] = (char)byArray[n2];
                    ++n18;
                    ++n2;
                }
                bl5 = false;
                bl6 = false;
                n15 = 0;
                n16 = 0;
                n4 = 32;
                n17 = 32;
                while (true) {
                    if (n2 > 7 && !bl7 && byArray[n2 - 7] == 47 && byArray[n2 - 6] == 73 && byArray[n2 - 5] == 110 && byArray[n2 - 4] == 100 && byArray[n2 - 3] == 101 && byArray[n2 - 2] == 120 && byArray[n2 - 1] == 101 && byArray[n2] == 100) {
                        bl7 = true;
                    }
                    if (byArray[n2] == 40 & byArray[n2 - 1] != 92 && bl7) {
                        int n19;
                        int n20;
                        int n21 = n2 + 1;
                        int n22 = n2;
                        while (n22 < byArray.length && !(byArray[++n22] == 41 & (byArray[n22 - 1] != 92 || byArray[n22 - 1] == 92 && byArray[n22 - 2] == 92))) {
                        }
                        int n23 = n22 - n21;
                        byte[] byArray5 = new byte[n23];
                        for (n20 = 0; n20 < n23 && n21 != n22; ++n21, ++n20) {
                            byte by = byArray[n21];
                            if (by != 92) {
                                byArray5[n20] = by;
                                continue;
                            }
                            if (byArray[++n21] == 98) {
                                byArray5[n20] = 8;
                                continue;
                            }
                            if (byArray[n21] == 110) {
                                byArray5[n20] = 10;
                                continue;
                            }
                            if (byArray[n21] == 116) {
                                byArray5[n20] = 9;
                                continue;
                            }
                            if (byArray[n21] == 114) {
                                byArray5[n20] = 13;
                                continue;
                            }
                            if (byArray[n21] == 102) {
                                byArray5[n20] = 12;
                                continue;
                            }
                            if (byArray[n21] == 92) {
                                byArray5[n20] = 92;
                                continue;
                            }
                            if (Character.isDigit((char)byArray[n21])) {
                                StringBuffer stringBuffer4 = new StringBuffer(3);
                                for (n19 = 0; n19 < 3 && byArray[n21] != 92 && byArray[n21] != 41; ++n19) {
                                    stringBuffer4.append((char)byArray[n21]);
                                    ++n21;
                                }
                                --n21;
                                byArray5[n20] = (byte)Integer.parseInt(stringBuffer4.toString(), 8);
                                continue;
                            }
                            byArray5[n20] = byArray[n21];
                        }
                        try {
                            byArray5 = this.decrypt(byArray5, string, false, null, false, false);
                        }
                        catch (PdfSecurityException pdfSecurityException) {
                            pdfSecurityException.printStackTrace();
                        }
                        object[n18] = 32;
                        object[++n18] = 60;
                        ++n18;
                        for (n20 = 0; n20 < n23; ++n20) {
                            String string6 = Integer.toHexString(byArray5[n20] & 0xFF);
                            if (string6.length() < 2) {
                                object[n18] = 48;
                                ++n18;
                            }
                            int n24 = string6.length();
                            for (n19 = 0; n19 < n24; ++n19) {
                                object[n18] = string6.charAt(n19);
                                ++n18;
                            }
                        }
                        object[n18] = 62;
                        ++n18;
                    } else if (!bl5) {
                        if (byArray[n2] == 13 | byArray[n2] == 10) {
                            object[n18] = 32;
                            ++n18;
                        } else {
                            n4 = (char)byArray[n2];
                            if (n4 == 47 && n17 != 32) {
                                object[n18] = 32;
                                ++n18;
                            }
                            if (n4 != 32 && n17 == 41) {
                                object[n18] = 32;
                                ++n18;
                            }
                            object[n18] = n4;
                            ++n18;
                            n17 = n4;
                        }
                    }
                    if (byArray[n2 - 1] != 92 | (byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92 && byArray[n2 - 3] != 92)) {
                        if (byArray[n2] == 40) {
                            ++n16;
                        } else if (byArray[n2] == 41) {
                            --n16;
                        }
                        if (n16 == 0) {
                            if (byArray[n2] == 91) {
                                ++n15;
                            } else if (byArray[n2] == 93) {
                                --n15;
                            }
                        }
                    }
                    if (n15 == 0 && byArray[n2 - 1] != 92 & byArray[n2] == 93) break;
                    if (byArray[++n2] != 37 || byArray[n2 - 1] == 92 || n15 != 0) continue;
                    bl5 = true;
                }
                String string7 = String.copyValueOf((char[])object, 0, n18);
                if (!string7.equals("null")) {
                    map.put(stringBuffer.toString(), string7);
                }
                stringBuffer = new StringBuffer(20);
                continue;
            }
            if (byArray[n2] == 62 || byArray[n2] == 60 || stringBuffer.length() <= 0) continue;
            boolean bl8 = false;
            int n25 = n2;
            int n26 = 0;
            while (true) {
                if (byArray[n2] != 13 && byArray[n2] != 9 && byArray[n2] != 10 && !bl8) {
                    ++n26;
                }
                if (byArray[n2 + 1] == 47 || byArray[n2] != 62 && byArray[n2 + 1] == 62) break;
                if (byArray[++n2] != 37 || byArray[n2 - 1] == 92) continue;
                bl8 = true;
            }
            while (n26 > 0 && (byArray[n25 + n26 - 1] == 32 || byArray[n25 + n26 - 1] == 10 || byArray[n25 + n26 - 1] == 13 || byArray[n25 + n26 - 1] == 9)) {
                --n26;
            }
            char[] cArray = new char[n26];
            --n26;
            int n27 = 0;
            do {
                if (byArray[n25] != 13 && byArray[n25] != 9 && byArray[n25] != 10) {
                    cArray[n27] = (char)byArray[n25];
                    ++n27;
                }
                ++n25;
            } while (n27 <= n26);
            String string8 = String.copyValueOf(cArray, 0, n27);
            if (!string8.equals("null")) {
                map.put(stringBuffer.toString(), string8);
            }
            stringBuffer = new StringBuffer(20);
        }
        return n2;
    }

    public final byte[] readStream(Map map, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        byte[] byArray;
        Object v = map.get("DecodedStream");
        BufferedOutputStream bufferedOutputStream = null;
        String string2 = null;
        boolean bl6 = false;
        if (v == null) {
            Object object;
            int n;
            byArray = (byte[])map.get("Stream");
            boolean bl7 = bl6 = map.get("startStreamOnDisk") != null && this.endStreamPointer - this.startStreamPointer >= 0;
            if (bl6) {
                try {
                    File file = File.createTempFile("jpedal", ".bin");
                    string2 = file.getAbsolutePath();
                    this.cachedObjects.put(string2, "x");
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    n = 8192;
                    int n2 = this.startStreamPointer;
                    do {
                        int n3;
                        if ((n3 = 1 + this.endStreamPointer - n2) < n) {
                            n = n3;
                        }
                        byte[] byArray2 = new byte[n];
                        this.movePointer(n2);
                        this.pdf_datafile.read(byArray2);
                        bufferedOutputStream.write(byArray2);
                    } while ((n2 += n) < this.endStreamPointer);
                    bufferedOutputStream.close();
                    object = new File(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        this.decrypt(null, string, false, string2, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
                map.put("CachedStream", string2);
            }
            if (byArray != null) {
                try {
                    if (!(bl5 || !this.isMetaDataEncypted && bl4)) {
                        byArray = this.decrypt(byArray, string, false, null, false, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (bl3) {
                map.remove("Stream");
            }
            int n4 = 1;
            if (byArray != null || bl6) {
                n = 1;
                int n5 = 1;
                String string3 = (String)map.get("Height");
                if (string3 != null) {
                    Map map2;
                    if (string3.indexOf(82) != -1 && (object = (map2 = this.readObject(string3, false, null)).get("rawValue")) != null) {
                        string3 = (String)object;
                    }
                    n = Integer.parseInt(string3);
                }
                if ((string3 = (String)map.get("Width")) != null) {
                    n5 = Integer.parseInt(string3);
                }
                if ((string3 = this.getValue((String)map.get("Length"))) != null) {
                    n4 = Integer.parseInt(string3);
                }
                if (n * n5 == 1) {
                    n5 = n4;
                }
                String string4 = this.getValue((String)map.get("Filter"));
                boolean bl8 = false;
                Object v2 = map.get("ImageMask");
                if (v2 != null && v2.equals("true")) {
                    bl8 = true;
                }
                if (string4 != null && !string4.startsWith("/JPXDecode") && !string4.startsWith("/DCT")) {
                    try {
                        String string5;
                        Object v3 = map.get("DecodeParms");
                        if (v3 != null && v3 instanceof String && (string5 = (String)v3).endsWith(" R")) {
                            Map map3 = this.readObject(string5, false, null);
                            map.put("DecodeParms", map3);
                        }
                        byArray = this.decodeFilters(byArray, string4, map, n5, n, true, string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream " + string4);
                        byArray = null;
                        bl6 = false;
                    }
                    n4 = 1;
                } else if (byArray != null && n4 != 1 && n4 < byArray.length && byArray.length != n4) {
                    byte[] byArray3 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray3, 0, n4);
                    byArray = byArray3;
                }
            }
            if (byArray != null && bl) {
                map.put("DecodedStream", byArray);
            }
            if (bl2 && bl6) {
                n = (int)new File(string2).length();
                byte[] byArray4 = new byte[n];
                try {
                    new BufferedInputStream(new FileInputStream(string2)).read(byArray4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (n4 != 1 && n4 < n) {
                    byte[] byArray5 = new byte[n4];
                    System.arraycopy(byArray4, 0, byArray5, 0, n4);
                    byArray4 = byArray5;
                }
                return byArray4;
            }
        } else {
            byArray = (byte[])v;
        }
        return byArray;
    }

    public final String getStreamOnDisk(String string) {
        int n = this.miniumumCacheSize;
        this.miniumumCacheSize = 0;
        Map map = this.readObject(string, false, null);
        this.readStream(string, true);
        this.miniumumCacheSize = n;
        if (map == null) {
            return null;
        }
        return (String)map.get("CachedStream");
    }

    public int getObjectSize(String string) {
        int n = -1;
        if (!this.refTableInvalid) {
            boolean bl = this.isCompressed(string);
            if (string.endsWith(" R")) {
                byte[] byArray = null;
                byte[] byArray2 = null;
                if (bl) {
                    int n2 = Integer.parseInt(string.substring(0, string.indexOf(32)));
                    int n3 = this.getCompressedStreamObject(string);
                    String string2 = n3 + " 0 R";
                    String string3 = null;
                    HashMap hashMap = this.lastOffsetStart;
                    HashMap hashMap2 = this.lastOffsetEnd;
                    int n4 = this.lastFirst;
                    boolean bl2 = true;
                    byte[] byArray3 = this.lastCompressedStream;
                    if (this.lastOffsetStart != null) {
                        string3 = (String)this.lastOffsetStart.get(String.valueOf(n2));
                    }
                    while (string3 == null) {
                        bl2 = false;
                        try {
                            this.movePointer(string2);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception moving pointer to " + string);
                        }
                        byArray2 = this.readObjectData(this.ObjLengthTable[n3]);
                        n = this.ObjLengthTable[n3];
                        HashMap hashMap3 = new HashMap();
                        this.convertObjectBytesToMap(hashMap3, string, false, new HashMap(), false, false, byArray, byArray2, false);
                        hashMap = new HashMap();
                        hashMap2 = new HashMap();
                        n4 = Integer.parseInt((String)hashMap3.get("First"));
                        byArray3 = this.readStream(hashMap3, string, true, true, false, false, true);
                        this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3);
                        string3 = (String)hashMap.get(String.valueOf(n2));
                        string2 = (String)hashMap3.get("Extends");
                    }
                    if (!bl2) {
                        this.lastCompressedStream = byArray3;
                        this.lastOffsetStart = hashMap;
                        this.lastOffsetEnd = hashMap2;
                        this.lastFirst = n4;
                    }
                } else {
                    int n5 = string.indexOf(32);
                    int n6 = Integer.parseInt(string.substring(0, n5));
                    n = this.ObjLengthTable[n6];
                }
            }
            if (n == 0) {
                n = -1;
            }
        }
        return n;
    }

    public final byte[] readStream(String string, boolean bl) {
        Map map = this.readObject(string, false, null);
        return this.readStream(map, string, true, bl, false, false, false);
    }

    public final Map readObject(int n) {
        boolean bl = false;
        boolean bl2 = false;
        this.objData = new HashMap();
        byte[] byArray = null;
        try {
            this.movePointer(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception moving pointer to " + n);
        }
        byte[] byArray2 = this.readObjectData(-1);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 32;
        int n3 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            char c = (char)byArray2[i];
            if (c == '\n' || c == '\r') {
                c = ' ';
            }
            if (c == ' ' && n2 == 32) {
                n3 = 0;
            } else if (c == pattern.charAt(n3)) {
                ++n3;
            } else {
                n3 = 0;
                stringBuffer.append(c);
            }
            if (n3 == 3) break;
            n2 = c;
        }
        stringBuffer.append('R');
        this.objData.put("Reference", stringBuffer.toString());
        this.convertObjectBytesToMap(this.objData, stringBuffer.toString(), false, null, bl, bl2, byArray, byArray2, false);
        this.lastRef = "-1";
        return this.objData;
    }

    public final void flushObjectCache() {
        this.lastRef = null;
    }

    public final synchronized Map readObject(String string, boolean bl, Map map) {
        if (this.lastRef != null && string.equals(this.lastRef)) {
            return this.objData;
        }
        this.lastRef = string;
        boolean bl2 = false;
        boolean bl3 = false;
        this.objData = new HashMap();
        bl3 = map != null;
        if (bl2) {
            System.err.println("reading objectRef=" + string + '<');
        }
        if (string.endsWith("]")) {
            string = Strip.removeArrayDeleminators(string);
        }
        if (bl2) {
            System.err.println("reading objectRef=" + string + "< isCompressed=" + this.isCompressed(string));
        }
        boolean bl4 = this.isCompressed(string);
        if (string.endsWith(" R")) {
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (bl4) {
                int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
                int n2 = this.getCompressedStreamObject(string);
                String string2 = n2 + " 0 R";
                String string3 = null;
                HashMap hashMap = this.lastOffsetStart;
                HashMap hashMap2 = this.lastOffsetEnd;
                int n3 = this.lastFirst;
                boolean bl5 = true;
                byte[] byArray3 = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
                }
                while (string3 == null) {
                    bl5 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray2 = this.readObjectData(this.ObjLengthTable[n2]);
                    HashMap hashMap3 = new HashMap();
                    this.convertObjectBytesToMap(hashMap3, string2, bl, map, bl2, bl3, byArray, byArray2, false);
                    hashMap = new HashMap();
                    hashMap2 = new HashMap();
                    n3 = Integer.parseInt((String)hashMap3.get("First"));
                    byArray3 = this.readStream(hashMap3, string2, true, true, false, false, false);
                    this.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray3);
                    string3 = (String)hashMap.get(String.valueOf(n));
                    string2 = (String)hashMap3.get("Extends");
                }
                if (!bl5) {
                    this.lastCompressedStream = byArray3;
                    this.lastOffsetStart = hashMap;
                    this.lastOffsetEnd = hashMap2;
                    this.lastFirst = n3;
                }
                int n4 = n3 + Integer.parseInt(string3);
                int n5 = byArray3.length;
                String string4 = (String)hashMap2.get(String.valueOf(n));
                if (string4 != null) {
                    n5 = n3 + Integer.parseInt(string4);
                }
                int n6 = n5 - n4;
                byArray2 = new byte[n6];
                System.arraycopy(byArray3, n4, byArray2, 0, n6);
            } else {
                try {
                    this.movePointer(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + string);
                }
                int n = string.indexOf(32);
                int n7 = Integer.parseInt(string.substring(0, n));
                if (bl | this.refTableInvalid) {
                    byArray2 = this.readObjectData(-1);
                } else if (n7 > this.ObjLengthTable.length || this.ObjLengthTable[n7] == 0) {
                    LogWriter.writeLog(string + " cannot have offset 0");
                    byArray2 = new byte[]{};
                } else {
                    byArray2 = this.readObjectData(this.ObjLengthTable[n7]);
                }
            }
            if (bl2) {
                System.out.println("convertObjectsToMap");
            }
            if (this.startStreamPointer != -1 || byArray2.length > 1) {
                this.convertObjectBytesToMap(this.objData, string, bl, map, bl2, bl3, byArray, byArray2, bl4);
            }
            if (bl2) {
                System.out.println("converted");
            }
        } else {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < string.length(); ++i) {
                    byteArrayOutputStream.write((byte)string.charAt(i));
                }
                if (bl2) {
                    System.out.println("reading dictionary");
                }
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > 0) {
                    this.readDictionary(string, 1, this.objData, 0, byArray, bl, map, -1);
                }
                LogWriter.writeLog("Direct object read " + string + "<<");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bl2) {
            System.out.println("object read");
        }
        return this.objData;
    }

    public final synchronized byte[] readObjectAsByteArray(String string, boolean bl) {
        byte[] byArray = null;
        if (string.endsWith("]")) {
            string = Strip.removeArrayDeleminators(string);
        }
        boolean bl2 = this.isCompressed(string);
        if (string.endsWith(" R")) {
            byte[] byArray2 = null;
            if (bl2) {
                int n = Integer.parseInt(string.substring(0, string.indexOf(32)));
                int n2 = this.getCompressedStreamObject(string);
                String string2 = n2 + " 0 R";
                String string3 = null;
                int n3 = this.getOffsetInCompressedStream(string);
                HashMap hashMap = this.lastOffsetStart;
                HashMap hashMap2 = this.lastOffsetEnd;
                int n4 = this.lastFirst;
                boolean bl3 = true;
                byte[] byArray3 = this.lastCompressedStream;
                if (this.lastOffsetStart != null) {
                    string3 = (String)this.lastOffsetStart.get(String.valueOf(n));
                }
                while (string3 == null) {
                    bl3 = false;
                    try {
                        this.movePointer(string2);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception moving pointer to " + string);
                    }
                    byArray = this.readObjectData(this.ObjLengthTable[n2]);
                    HashMap hashMap3 = new HashMap();
                    this.convertObjectBytesToMap(hashMap3, string, bl, null, false, false, byArray2, byArray, false);
                    hashMap = new HashMap();
                    hashMap2 = new HashMap();
                    n4 = Integer.parseInt((String)hashMap3.get("First"));
                    byArray3 = this.readStream(hashMap3, string, true, true, false, false, true);
                    this.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray3);
                    string3 = (String)hashMap.get(String.valueOf(n));
                    string2 = (String)hashMap3.get("Extends");
                }
                if (!bl3) {
                    this.lastCompressedStream = byArray3;
                    this.lastOffsetStart = hashMap;
                    this.lastOffsetEnd = hashMap2;
                    this.lastFirst = n4;
                }
                int n5 = n4 + Integer.parseInt(string3);
                int n6 = byArray3.length;
                String string4 = (String)hashMap2.get(String.valueOf(n));
                if (string4 != null) {
                    n6 = n4 + Integer.parseInt(string4);
                }
                int n7 = n6 - n5;
                byArray = new byte[n7];
                System.arraycopy(byArray3, n5, byArray, 0, n7);
            } else {
                try {
                    this.movePointer(string);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception moving pointer to " + string);
                }
                int n = string.indexOf(32);
                int n8 = Integer.parseInt(string.substring(0, n));
                byArray = bl | this.refTableInvalid ? this.readObjectData(-1) : this.readObjectData(this.ObjLengthTable[n8]);
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < string.length(); ++i) {
                byteArrayOutputStream.write((byte)string.charAt(i));
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6;
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            n2 = i;
            while (byArray[i] != 32) {
                stringBuffer.append((char)byArray[i]);
                ++i;
            }
            n3 = i - 1;
            int n7 = n3 - n2 + 1;
            char[] cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n2 + n6];
            }
            string2 = new String(cArray);
            if (!string2.equals(stringBuffer.toString())) {
                System.out.println("Different=" + string2 + "<>" + stringBuffer + '<');
                System.exit(1);
            }
            while (byArray[i] == 32) {
                ++i;
            }
            n4 = i;
            while (byArray[i] != 32 && i < n) {
                stringBuffer2.append((char)byArray[i]);
                ++i;
            }
            n5 = i - 1;
            n7 = n5 - n4 + 1;
            cArray = new char[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                cArray[n6] = (char)byArray[n4 + n6];
            }
            string3 = new String(cArray);
            if (!string3.equals(stringBuffer2.toString())) {
                System.out.println("Different=" + string3 + "<>" + stringBuffer2 + '<');
                System.exit(1);
            }
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    private void convertObjectBytesToMap(Map map, String string, boolean bl, Map map2, boolean bl2, boolean bl3, byte[] byArray, byte[] byArray2, boolean bl4) {
        int n;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        char c = ' ';
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl4) {
            while (byArray2[n2] != 111 || byArray2[n2 + 1] != 98 || byArray2[n2 + 2] != 106) {
                ++n2;
            }
            n2 += 2;
            while (byArray2[n2] != 47 && !(byArray2[++n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 60 | byArray2[n2] == 91 | byArray2[n2] == 32)) {
            }
        }
        if (bl2) {
            for (n = n2; n < byArray2.length - 7; ++n) {
                System.err.print((char)byArray2[n]);
            }
            System.err.print("<===\n\n");
        }
        if (byArray2[n2] == 47 | byArray2[n2] == 91) {
            --n2;
        }
        while (n2 < byArray2.length - 7) {
            ++n2;
            if (bl2) {
                System.err.println((char)byArray2[n2]);
            }
            if (byArray2[n2] == 111 && byArray2[n2 + 1] == 98 && byArray2[n2 + 2] == 106) break;
            if (byArray2[n2] == 60 && byArray2[n2 + 1] == 60 | byArray2[n2 - 1] == 60) {
                if (byArray2[n2 - 1] != 60) {
                    ++n2;
                }
                if (bl2) {
                    System.err.println("Read dictionary");
                }
                n2 = this.readDictionary(string, 1, map, n2, byArray2, bl, map2, -1);
                continue;
            }
            if (byArray2[n2] == 115 && byArray2[n2 + 1] == 116 && byArray2[n2 + 2] == 114 && byArray2[n2 + 3] == 101 && byArray2[n2 + 4] == 97 && byArray2[n2 + 5] == 109) {
                if (bl2) {
                    System.err.println("Read stream");
                }
                if (byArray2[n2 += 6] == 13 && byArray2[n2 + 1] == 10) {
                    n2 += 2;
                } else if (byArray2[n2] == 10 | byArray2[n2] == 13) {
                    // empty if block
                }
                n = ++n2;
                --n2;
                int n3 = 0;
                String string2 = (String)map.get("Length");
                if (string2 != null) {
                    if (string2.indexOf(" R") != -1) {
                        try {
                            int n4;
                            long l = this.movePointer(string2);
                            int n5 = 128;
                            if (l + (long)n5 > this.eof) {
                                n5 = (int)(this.eof - l - 1L);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            byte[] byArray3 = new byte[n5];
                            this.pdf_datafile.read(byArray3);
                            for (n4 = 3; n4 >= n5 || byArray3[n4 - 3] != 111 || byArray3[n4 - 2] != 98 || byArray3[n4 - 1] != 106; ++n4) {
                            }
                            while (n4 >= n5 || !Character.isDigit((char)byArray3[n4])) {
                                ++n4;
                            }
                            while (n4 < n5 && Character.isDigit((char)byArray3[n4])) {
                                stringBuffer2.append((char)byArray3[n4]);
                                ++n4;
                            }
                            this.movePointer(l);
                            string2 = stringBuffer2.toString();
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception moving pointer to " + string);
                            string2 = null;
                        }
                    }
                    if (string2 != null) {
                        n3 = Integer.parseInt(string2);
                        n2 = n + n3;
                        if (n2 < byArray2.length && byArray2[n2] == 13 && n2 + 1 < byArray2.length && byArray2[n2 + 1] == 10) {
                            n2 += 2;
                        }
                        if (byArray2.length <= n2 + 9 || byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) {
                            boolean bl5 = false;
                            int n6 = n2;
                            if (n2 < byArray2.length) {
                                while (!bl5 && ++n2 != byArray2.length) {
                                    if (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) continue;
                                    n3 = n2 - n;
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                n2 = n6;
                                if (n2 > byArray2.length) {
                                    n2 = byArray2.length;
                                }
                                while (!bl5 && --n2 >= 0) {
                                    if (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109) continue;
                                    n3 = n2 - n;
                                    bl5 = true;
                                }
                            }
                            if (!bl5) {
                                n2 = n6;
                            }
                        }
                    }
                } else {
                    while (++n2 != byArray2.length && (byArray2[n2] != 101 || byArray2[n2 + 1] != 110 || byArray2[n2 + 2] != 100 || byArray2[n2 + 3] != 115 || byArray2[n2 + 4] != 116 || byArray2[n2 + 5] != 114 || byArray2[n2 + 6] != 101 || byArray2[n2 + 7] != 97 || byArray2[n2 + 8] != 109)) {
                    }
                    int n7 = n2 - 1;
                    if (n7 > n) {
                        n3 = n7 - n + 1;
                    }
                }
                if (this.startStreamPointer == -1) {
                    if (n + n3 > byArray2.length) {
                        n3 = byArray2.length - n;
                    }
                    byArray = new byte[n3];
                    System.arraycopy(byArray2, n, byArray, 0, n3);
                }
                if (this.startStreamPointer != -1) {
                    map.put("startStreamOnDisk", new Integer(this.startStreamPointer));
                    map.put("endStreamOnDisk", new Integer(this.endStreamPointer));
                }
                n2 += 9;
                continue;
            }
            if (byArray2[n2] == 91) {
                if (bl2) {
                    System.err.println("read array");
                }
                n2 = this.readArray(string, n2, map, byArray2, bl, map2);
                continue;
            }
            if (!(byArray2[n2] != 60 & byArray2[n2] != 62)) continue;
            if (bl3) {
                if (byArray2[n2 - 1] == 92 && byArray2[n2 - 2] == 92) {
                    byteArrayOutputStream.write(byArray2[n2]);
                } else if (!((byArray2[n2] == 40 | byArray2[n2] == 41) & byArray2[n2 - 1] != 92)) {
                    byteArrayOutputStream.write(byArray2[n2]);
                }
            }
            if (byArray2[n2] == 10 | byArray2[n2] == 13 | byArray2[n2] == 32) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                c = ' ';
                continue;
            }
            if (byArray2[n2] == 47 && c != ' ') {
                stringBuffer.append(' ');
            }
            c = (char)byArray2[n2];
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0 && (n = stringBuffer.toString().indexOf(37)) > -1) {
            stringBuffer.setLength(n);
        }
        if (stringBuffer.length() > 0) {
            String string3 = stringBuffer.toString().trim();
            if (bl3 && string3.startsWith("(")) {
                try {
                    byteArrayOutputStream.close();
                    byte[] byArray4 = byteArrayOutputStream.toByteArray();
                    byArray4 = this.decrypt(byArray4, string, false, null, false, false);
                    map.put("rawValue", byArray4);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " writing out text string");
                }
            } else {
                if (bl2) {
                    System.err.println("Remainder value=" + stringBuffer + "<<");
                }
                map.put("rawValue", string3);
            }
        }
        if (byArray != null) {
            map.put("Stream", byArray);
        }
        if (bl2) {
            System.err.println(map);
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int readArray(String string, int n, Map map, byte[] byArray, boolean bl, Map map2) {
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl4 = false;
        boolean bl5 = false;
        while (true) {
            Serializable serializable;
            if (bl2) {
                int n4 = n;
                while (byArray[n4] == 13 | byArray[n4] == 10 | byArray[n4] == 32) {
                    ++n4;
                }
                if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                    n = n4;
                    if (bl3) {
                        stringBuffer.append(stringBuffer2);
                        stringBuffer.append(' ');
                        n = this.readDictionary(string, 1, map, n, byArray, bl, map2, -1);
                    } else {
                        serializable = new HashMap();
                        map.put(stringBuffer2.substring(1), serializable);
                        n = this.readDictionary(string, 1, (Map)((Object)serializable), n, byArray, bl, map2, -1);
                    }
                    if (byArray[n] == 62) {
                        ++n;
                    }
                    stringBuffer2 = new StringBuffer();
                } else {
                    if (stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append(' ');
                    stringBuffer2 = new StringBuffer();
                    bl2 = false;
                    --n;
                }
            } else if (!bl5 && byArray[n] == 47) {
                bl2 = true;
                do {
                    stringBuffer2.append((char)byArray[n]);
                } while (byArray[++n] != 47 && byArray[n] != 13 && byArray[n] != 10 && byArray[n] != 32 && byArray[n] != 60 && byArray[n] != 91 && byArray[n] != 93);
                if (byArray[n] == 47 || byArray[n] == 91 || byArray[n] == 93 || byArray[n] == 60) {
                    --n;
                }
                if (stringBuffer2.toString().equals("/Separation")) {
                    bl3 = true;
                } else if (stringBuffer2.toString().equals("/Indexed")) {
                    bl4 = true;
                }
            } else if (byArray[n] == 40 && byArray[n - 1] != 92 && bl4) {
                bl5 = true;
                stringBuffer.append(" <");
            } else if (bl5) {
                if (byArray[n] == 41 && byArray[n - 1] != 92) {
                    stringBuffer.append('>');
                    bl5 = false;
                } else {
                    String string2 = null;
                    if (byArray[n] == 92 && byArray[n + 1] != 13 && byArray[n + 1] != 10 && byArray[n + 1] != 114) {
                        char c;
                        serializable = new StringBuffer(3);
                        int n5 = 0;
                        for (int i = 1; i < 4 && (c = (char)byArray[n + 1]) >= '0' && c <= '9'; ++i) {
                            ((StringBuffer)serializable).append(c);
                            ++n5;
                            ++n;
                        }
                        if (n5 > 0) {
                            string2 = Integer.toHexString(Integer.parseInt(((StringBuffer)serializable).toString(), 8));
                        }
                    }
                    if (string2 == null) {
                        string2 = Integer.toHexString(byArray[n] & 0xFF);
                    }
                    if (string2.length() < 2) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            } else {
                if (n > 0 && byArray[n - 1] == 47) {
                    stringBuffer.append('/');
                }
                if (byArray[n] == 13 || byArray[n] == 10) {
                    stringBuffer.append(' ');
                } else {
                    if (byArray[n] == 60 && byArray[n - 1] != 32 && byArray[n - 1] != 60) {
                        stringBuffer.append(' ');
                    }
                    if (n > 0 && byArray[n - 1] == 93) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append((char)byArray[n]);
                }
                if (n == 0 || n > 0 && byArray[n - 1] != 92) {
                    if (byArray[n] == 91) {
                        ++n2;
                    } else if (byArray[n] == 93) {
                        ++n3;
                    }
                }
            }
            if (byArray[n] == 93 & n2 == n3) break;
            ++n;
        }
        map.put("rawValue", stringBuffer.toString().trim());
        return n;
    }

    public final Map readFDF() throws PdfException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        Map map = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("F", "x");
        hashMap.put("T", "x");
        hashMap.put("V", "x");
        try {
            n = (int)this.pdf_datafile.length();
            this.pdf_datafile.readLine();
            n2 = (int)this.pdf_datafile.getFilePointer();
            byte[] byArray = new byte[n -= n2];
            this.pdf_datafile.read(byArray);
            this.convertObjectBytesToMap(map, "1 0 R", false, hashMap, false, true, byArray, byArray, false);
            map = (Map)map.get("FDF");
        }
        catch (Exception exception) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        return map;
    }

    public int getPDFflag(Integer n) {
        if (n.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (n == PDFflags.VALID_PASSWORD_SUPPLIED) {
            return this.passwordStatus;
        }
        return -1;
    }

    public boolean containsJBIG() {
        return this.containsJBIG;
    }

    public final String readReferenceTable() throws PdfException {
        int n = this.readFirstStartRef();
        int n2 = -1;
        this.xref.addElement(n);
        try {
            n2 = (int)this.pdf_datafile.length();
        }
        catch (Exception exception) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + exception + " closing file");
            }
            throw new PdfException("Exception " + exception + " reading trailer");
        }
        if (n >= n2) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            this.refTableInvalid = true;
            return this.findOffsets();
        }
        if (this.isCompressedStream(n, n2)) {
            return this.readCompressedStream(n, n2);
        }
        return this.readLegacyReferenceTable(n, n2);
    }

    private final int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    private String readCompressedStream(int n, int n2) throws PdfException {
        String string = "";
        String string2 = null;
        while (n != -1) {
            Object object;
            int n3;
            int n4;
            if (this.interruptRefReading) {
                return null;
            }
            HashMap hashMap = this.readObject(n);
            String string3 = (String)hashMap.get("Reference");
            String string4 = (String)hashMap.get("Index");
            if (string4 == null) {
                n4 = 0;
                n3 = Integer.parseInt((String)hashMap.get("Size"));
            } else {
                String string5 = Strip.removeArrayDeleminators(string4);
                object = new StringTokenizer(string5);
                n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            string4 = (String)hashMap.get("W");
            object = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators(string4));
            for (int i = 0; i < 3; ++i) {
                object[i] = Integer.parseInt(stringTokenizer.nextToken());
            }
            byte[] byArray = this.readStream(hashMap, string3, true, true, false, false, true);
            int n5 = 0;
            int[] nArray = new int[]{1, 0, 0};
            block7: for (int i = 0; i < n3; ++i) {
                int n6;
                int[] nArray2 = new int[3];
                for (n6 = 0; n6 < 3; ++n6) {
                    if (object[n6] == false) {
                        nArray2[n6] = nArray[n6];
                        continue;
                    }
                    nArray2[n6] = this.getWord(byArray, n5, (int)object[n6]);
                    n5 += object[n6];
                }
                n6 = 0;
                switch (nArray2[0]) {
                    case 0: {
                        ++n4;
                        continue block7;
                    }
                    case 1: {
                        n6 = nArray2[1];
                        int n7 = nArray2[2];
                        this.storeObjectOffset(n4, n6, n7, false);
                        ++n4;
                        continue block7;
                    }
                    case 2: {
                        n6 = nArray2[1];
                        int n7 = nArray2[2];
                        this.storeObjectOffset(n4, n6, n7, true);
                        ++n4;
                        continue block7;
                    }
                    default: {
                        throw new PdfException("Exception Unsupported Compression mode with value " + nArray2[0]);
                    }
                }
            }
            if (string.length() == 0) {
                string4 = (String)hashMap.get("Root");
                if (string4 != null) {
                    string = string4;
                }
                if ((string2 = (String)hashMap.get("Encrypt")) != null) {
                    this.ID = (String)hashMap.get("ID");
                    if (this.ID == null) {
                        this.ID = "";
                    } else {
                        this.ID = Strip.removeArrayDeleminators(this.ID);
                        if (this.ID.startsWith("<")) {
                            this.ID = this.ID.substring(1, this.ID.indexOf(62));
                        }
                    }
                }
                this.infoObject = (string4 = (String)hashMap.get("Info")) != null && !this.isEncrypted | this.isPasswordSupplied ? string4 : null;
            }
            if ((string4 = (String)hashMap.get("Prev")) != null) {
                hashMap = new HashMap();
                n = Integer.parseInt(string4);
                continue;
            }
            n = -1;
        }
        if (!this.interruptRefReading) {
            if (string2 != null) {
                this.readEncryptionObject(string2);
            }
            this.calculateObjectLength();
        }
        return string;
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        boolean bl = false;
        int n3 = 50;
        int n4 = 0;
        int n5 = -1;
        byte[] byArray = pattern.getBytes();
        byte[] byArray2 = "ref".getBytes();
        block6: do {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            byte[] byArray3 = new byte[n3];
            this.movePointer(n);
            try {
                this.pdf_datafile.read(byArray3);
            }
            catch (Exception exception) {
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " scanning trailer for ref or obj");
            }
            for (int i = 0; i < n3; ++i) {
                byte by = byArray3[i];
                if (by == byArray2[n4] && n5 != 1) {
                    ++n4;
                    n5 = 2;
                } else if (by == byArray[n4] && n5 != 2) {
                    ++n4;
                    n5 = 1;
                } else {
                    n4 = 0;
                    n5 = -1;
                }
                n += n3;
                if (n4 == 2) continue block6;
            }
        } while (n4 != 2);
        if (n5 == -1) {
            try {
                this.pdf_datafile.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception 1 closing file");
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n5 == 1;
    }

    private final String readLegacyReferenceTable(int n, int n2) throws PdfException {
        String string = "";
        String string2 = "";
        String string3 = null;
        int n3 = 0;
        byte[] byArray = null;
        int n4 = 1024;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[]{37, 37, 69, 79, 70};
        HashMap hashMap = new HashMap();
        do {
            int n7;
            if (this.interruptRefReading) {
                return null;
            }
            try {
                byArray = this.readTrailer(n4, n5, byArray2, n, n2);
            }
            catch (Exception exception) {
                byArray = null;
                try {
                    this.pdf_datafile.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + exception + " closing file");
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            int n8 = byArray.length;
            for (n7 = 0; n7 < n8 && !(byArray[n7] == 116 & byArray[n7 + 1] == 114 & byArray[n7 + 2] == 97 & byArray[n7 + 3] == 105 & byArray[n7 + 4] == 108 & byArray[n7 + 5] == 101 & byArray[n7 + 6] == 114); ++n7) {
            }
            n6 = n7;
            while (byArray[n7] != 60 && byArray[n7 + 1] != 60) {
                ++n7;
            }
            n7 = this.readRef2(byArray, hashMap, n7, stringBuffer2, stringBuffer3);
            string2 = (String)hashMap.get("XRefStm");
            if (string2 != null) {
                n = Integer.parseInt(string2);
            } else {
                boolean bl = true;
                while (byArray[n7] != 116 && byArray[n7 + 1] != 120 && byArray[n7 + 2] != 114 && byArray[n7 + 3] != 101 && byArray[n7 + 4] != 102) {
                    if (byArray[n7] == 111 && byArray[n7 + 1] == 98 && byArray[n7 + 2] == 106) {
                        bl = false;
                        break;
                    }
                    ++n7;
                }
                if (bl) {
                    n7 += 8;
                    while (n7 < n8 && byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                        ++n7;
                    }
                    while (n7 < n8 && byArray[n7] != 10 && byArray[n7] != 32 && byArray[n7] != 13) {
                        stringBuffer.append((char)byArray[n7]);
                        ++n7;
                    }
                    if (stringBuffer.length() > 0) {
                        n = Integer.parseInt(stringBuffer.toString());
                    }
                }
            }
            if (n == -1) {
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (byArray[0] == 120 & byArray[1] == 114 & byArray[2] == 101 & byArray[3] == 102) {
                n7 = 5;
                while (byArray[n7] == 10 | byArray[n7] == 32 | byArray[n7] == 13) {
                    ++n7;
                }
                n3 = this.readXRefs(n3, byArray, n6, n7);
                n7 = n6;
                if (string.length() == 0) {
                    string2 = (String)hashMap.get("Root");
                    if (string2 != null) {
                        string = string2;
                    }
                    if ((string3 = (String)hashMap.get("Encrypt")) != null) {
                        this.ID = (String)hashMap.get("ID");
                        if (this.ID == null) {
                            this.ID = "";
                        } else {
                            this.ID = Strip.removeArrayDeleminators(this.ID);
                            if (this.ID.startsWith("<")) {
                                this.ID = this.ID.substring(1, this.ID.indexOf(62));
                            }
                        }
                    }
                    this.infoObject = (string2 = (String)hashMap.get("Info")) != null && !this.isEncrypted | this.isPasswordSupplied ? string2 : null;
                }
                if ((string2 = (String)hashMap.get("Prev")) != null) {
                    n4 = 1024;
                    n5 = 0;
                    hashMap = new HashMap();
                    n = Integer.parseInt(string2);
                    this.xref.addElement(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            string = this.findOffsets();
            this.refTableInvalid = true;
        } while (n != -1);
        if (!this.interruptRefReading) {
            if (string3 != null) {
                this.readEncryptionObject(string3);
            }
            if (!this.refTableInvalid) {
                this.calculateObjectLength();
            }
        }
        return string;
    }

    private void calculateObjectLength() {
        int n;
        int n2;
        try {
            this.xref.addElement((int)this.pdf_datafile.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[] nArray = this.xref.get();
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = n2;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        n2 = this.offset.getCapacity();
        this.ObjLengthTable = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = this.offset.get();
        boolean[] blArray = this.isCompressed.get();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            nArray4[n] = nArray5[n];
            nArray3[n] = n;
        }
        nArray3 = Sorts.quicksort(nArray4, nArray3);
        n = 0;
        while (true) {
            try {
                while (nArray4[nArray3[n]] == 0) {
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
        int n4 = nArray4[nArray3[n]];
        int n5 = 0;
        while (nArray[nArray2[n5]] < n4 + 1) {
            ++n5;
        }
        while (n < n2 - 1) {
            int n6 = nArray4[nArray3[n + 1]];
            int n7 = n6 - n4 - 1;
            if (nArray[nArray2[n5]] < n6) {
                n7 = nArray[nArray2[n5]] - n4 - 1;
                while (nArray[nArray2[n5]] < n6 + 1) {
                    ++n5;
                }
            }
            this.ObjLengthTable[nArray3[n]] = n7;
            n4 = n6;
            while (nArray[nArray2[n5]] < n4 + 1) {
                ++n5;
            }
            ++n;
        }
        this.ObjLengthTable[nArray3[n]] = nArray[nArray2[n5]] - n4 - 1;
    }

    private int readXRefs(int n, byte[] byArray, int n2, int n3) {
        int n4 = 99;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        while (n3 < n2) {
            int n9;
            int n10 = n3;
            int n11 = -1;
            while (byArray[n3] != 10 & byArray[n3] != 13) {
                if (n11 == -1 && byArray[n3] == 37) {
                    n11 = n3 - 1;
                }
                ++n3;
            }
            if (n11 == -1) {
                n11 = n3 - 1;
            }
            while (byArray[n10] == 32) {
                ++n10;
            }
            while (byArray[n11] == 32) {
                --n11;
            }
            ++n3;
            n6 = 0;
            n8 = n11 - n10 + 1;
            if (n8 <= 0) continue;
            int n12 = 1;
            for (n9 = 1; n9 < n8; ++n9) {
                int n13 = byArray[n10 + n9];
                if (n13 == 32 && n12 != 32) {
                    nArray[n6] = n9;
                    ++n6;
                } else if (n13 != 32 && n12 == 32) {
                    nArray2[n6] = n9;
                }
                n12 = n13;
            }
            nArray[n6] = n8;
            if (++n6 == 1) {
                if (bl) {
                    bl = false;
                    continue;
                }
                n = this.parseInt(n10, n10 + nArray[0], byArray);
                bl = true;
                continue;
            }
            if (n6 == 2) {
                n = this.parseInt(n10, n10 + nArray[0], byArray);
                continue;
            }
            n5 = this.parseInt(n10, n10 + nArray[0], byArray);
            n7 = this.parseInt(n10 + nArray2[1], n10 + nArray[1], byArray);
            n4 = (char)byArray[n10 + nArray2[2]];
            if (n4 == 110) {
                n9 = 0;
                int n14 = 20;
                if ((long)(n5 + n14) > this.eof) {
                    n14 = (int)(this.eof - (long)n5);
                }
                if (n14 > 0) {
                    byte[] byArray2 = new byte[n14];
                    this.movePointer(n5);
                    try {
                        this.pdf_datafile.read(byArray2);
                        for (int i = 4; i < n14; ++i) {
                            if (byArray2[i - 3] != 32 || byArray2[i - 2] != 111 || byArray2[i - 1] != 98 || byArray2[i] != 106) continue;
                            n9 = 1;
                            i = n14;
                        }
                        if (n9 != 0) {
                            this.storeObjectOffset(n, n5, n7, false);
                            this.xref.addElement(n5);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            ++n;
        }
        return n;
    }

    private int parseInt(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        --n;
        for (int i = n2 - 1; i > n; --i) {
            n3 += (byArray[i] - 48) * powers[n4];
            ++n4;
        }
        return n3;
    }

    private int readRef2(byte[] byArray, Map map, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        while (byArray[++n] != 62 || byArray[n + 1] != 62) {
            if (byArray[n] == 47) {
                String string;
                ++n;
                while (!(byArray[n] == 32 | byArray[n] == 91 | byArray[n] == 10 | byArray[n] == 13 | byArray[n] == 60)) {
                    stringBuffer.append((char)byArray[n]);
                    ++n;
                }
                boolean bl = stringBuffer.length() != 2 || stringBuffer.charAt(0) != 'I' || stringBuffer.charAt(1) != 'D';
                if (byArray[n] != 91) {
                    while (byArray[n] == 32) {
                        ++n;
                    }
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    char c = (char)byArray[n];
                    if (byArray[n - 1] == 60 && byArray[n] == 60) {
                        ++n4;
                    }
                    if (c == '(' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    } else if (c == ')' && n > 0 && byArray[n - 1] != 92 | (n > 1 && byArray[n - 1] == 92 && byArray[n - 2] != 92)) {
                        ++n3;
                    }
                    if (c == '/' & bl && n4 == 0) {
                        --n;
                    }
                    if (!bl && c == ']' && byArray[n + 1] == 47 || !bl && c == ']' && n3 == 0 || n4 == 0 && c == '\n' | c == '\r' | (c == '/' && bl) && n2 > 0) break;
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        if (n4 == 0) break;
                        --n4;
                    }
                    if (c == '\\') {
                        c = (char)byArray[++n];
                    }
                    if (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 || n2 != 0) {
                        stringBuffer2.append((char)byArray[n]);
                        ++n2;
                    }
                    ++n;
                }
                if (!(string = (stringBuffer2 = this.removeTrailingSpaces(stringBuffer2)).toString()).equals("null")) {
                    int n5 = string.indexOf(37);
                    if (n5 != -1 & string.indexOf("\\%") != n5 - 1) {
                        string = string.substring(0, n5).trim();
                    }
                    map.put(stringBuffer.toString(), string);
                }
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            if (byArray[n] != 62 || byArray[n + 1] != 62) continue;
            break;
        }
        return n;
    }

    private byte[] readTrailer(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if (n3 + n > n4) {
                n = n4 - n3;
            }
            byte[] byArray2 = new byte[n];
            this.movePointer(n3);
            this.pdf_datafile.read(byArray2);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                byte by = byArray2[i];
                n2 = by == byArray[n2] ? ++n2 : 0;
                if (n2 != 5) continue;
                for (int j = 0; j < i + 1; ++j) {
                    byteArrayOutputStream.write(byArray2[j]);
                }
                i = n;
                bl = true;
            }
            if (!bl) {
                byteArrayOutputStream.write(byArray2);
            }
            n3 += n;
        } while (n2 != 5);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public final PdfFileInformation readPdfFileMetadata(String string) {
        if (this.infoObject != null && !this.isEncrypted | this.isPasswordSupplied) {
            this.readInformationObject(this.infoObject);
        }
        if (string != null) {
            byte[] byArray = this.readStream(this.readObject(string, false, null), string, true, true, false, true, false);
            this.currentFileInformation.setFileXMLMetaData(this.convertStreamToXML(string).toString(), byArray);
        }
        return this.currentFileInformation;
    }

    public StringBuffer convertStreamToXML(String string) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            stringBuffer = new StringBuffer();
            String string2 = "";
            BufferedReader bufferedReader = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                Map map = this.readObject(string, false, null);
                byte[] byArray = this.readStream(map, string, true, true, false, true, false);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                if (bufferedReader != null) {
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (Strip.isEmptyLine(string2)) continue;
                        stringBuffer.append(string2);
                        stringBuffer.append('\n');
                    }
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading XML object " + string);
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return stringBuffer;
    }

    public final String getValue(String string) {
        if (string != null && string.endsWith(" R")) {
            Map map = this.readObject(string, false, null);
            string = (String)map.get("rawValue");
        }
        if (string != null && string.equals("null")) {
            string = null;
        }
        return string;
    }

    private Object getObjectValue(Object object) {
        Object v;
        Map map = this.readObject((String)object, false, this.fields);
        int n = map.size();
        object = n == 1 ? ((v = map.get("rawValue")) != null ? (v instanceof String ? v : this.getTextString((byte[])v)) : map) : map;
        return object;
    }

    public final byte[] getByteTextStringValue(Object object, Map map) {
        if (object instanceof String) {
            String string = (String)object;
            if (string != null && string.endsWith(" R")) {
                Map map2 = this.readObject(string, false, map);
                object = map2.get("rawValue");
            } else {
                return string.getBytes();
            }
        }
        return (byte[])object;
    }

    public final Map getSubDictionary(Object object) {
        if (object instanceof String) {
            return this.readObject((String)object, false, null);
        }
        return (Map)object;
    }

    private StringBuffer removeTrailingSpaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = n - 1; i > -1; --i) {
            if (stringBuffer.charAt(i) == ' ') {
                stringBuffer.deleteCharAt(i);
                continue;
            }
            i = -2;
        }
        return stringBuffer;
    }

    public static String convertToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public final boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final boolean isPasswordSupplied() {
        return this.isPasswordSupplied;
    }

    public final boolean isExtractionAllowed() {
        return this.extractionIsAllowed;
    }

    public boolean isFileViewable() {
        return this.isFileViewable;
    }

    private final byte[] decrypt(byte[] byArray, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws PdfSecurityException {
        boolean bl4 = false;
        if (this.isEncrypted || bl) {
            int n;
            int n2;
            Object object;
            Object object2;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            int n3 = 0;
            boolean bl5 = false;
            if (string2 != null) {
                try {
                    n3 = (int)new File(string2).length();
                    File file = File.createTempFile("jpedal", ".raw");
                    this.cachedObjects.put(file.getAbsolutePath(), "x");
                    ObjectStore.copy(string2, file.getAbsolutePath());
                    object2 = new File(string2);
                    ((File)object2).delete();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException + " in decrypt");
                }
            }
            int n4 = this.keyLength;
            object2 = "RC4";
            String string3 = "RC4";
            IvParameterSpec ivParameterSpec = null;
            Map map = null;
            String string4 = null;
            if (!bl3) {
                map = this.StmF;
                string4 = this.StrFname;
            } else {
                map = this.StrF;
                string4 = this.StmFname;
            }
            if (!bl2 && map == null && string4 != null && string4.equals("Identity")) {
                return byArray;
            }
            if (map != null) {
                String string5;
                object = (String)map.get("Length");
                if (object != null) {
                    n4 = Integer.parseInt((String)object);
                }
                if ((string5 = (String)map.get("CFM")) != null && string5.equals("/AESV2") && !bl2) {
                    this.cipher = null;
                    object2 = "AES/CBC/PKCS5Padding";
                    string3 = "AES";
                    bl5 = true;
                    byte[] byArray2 = new byte[16];
                    System.arraycopy(byArray, 0, byArray2, 0, 16);
                    ivParameterSpec = new IvParameterSpec(byArray2);
                    n2 = byArray.length;
                    n = n2 - 16;
                    byte[] byArray3 = new byte[n];
                    System.arraycopy(byArray, 16, byArray3, 0, n);
                    byArray = byArray3;
                    int n5 = byArray.length & 0xF;
                    int n6 = byArray.length;
                    if (n5 > 0) {
                        n6 = n6 + 16 - n5;
                        byArray3 = new byte[n6];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        byArray = byArray3;
                    }
                }
            }
            object = new byte[n4];
            if (string.length() > 0) {
                object = new byte[n4 + 5];
            }
            System.arraycopy(this.encryptionKey, 0, object, 0, n4);
            try {
                if (string.length() > 0) {
                    int n7 = string.indexOf(32);
                    int n8 = string.indexOf(32, n7 + 1);
                    n2 = Integer.parseInt(string.substring(0, n7));
                    n = Integer.parseInt(string.substring(n7 + 1, n8));
                    object[n4] = (byte)(n2 & 0xFF);
                    object[n4 + 1] = (byte)(n2 >> 8 & 0xFF);
                    object[n4 + 2] = (byte)(n2 >> 16 & 0xFF);
                    object[n4 + 3] = (byte)(n & 0xFF);
                    object[n4 + 4] = (byte)(n >> 8 & 0xFF);
                }
                byte[] byArray4 = new byte[Math.min(((byte[])object).length, 16)];
                if (string.length() > 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update((byte[])object);
                    if (bl5 && n4 >= 16) {
                        byte[] byArray5 = new byte[]{115, 65, 108, 84};
                        messageDigest.update(byArray5);
                    }
                    System.arraycopy(messageDigest.digest(), 0, byArray4, 0, byArray4.length);
                } else {
                    System.arraycopy(object, 0, byArray4, 0, byArray4.length);
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((String)object2);
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, string3);
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else if (ivParameterSpec == null) {
                    this.cipher.init(2, secretKeySpec);
                } else {
                    this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                }
                if (byArray == null) {
                    CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, this.cipher);
                    while ((n = cipherInputStream.read()) != -1) {
                        bufferedOutputStream.write(n);
                    }
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                if (byArray != null) {
                    byArray = this.cipher.doFinal(byArray);
                }
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return byArray;
    }

    private byte[] getPaddedKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        int n = byArray.length;
        if (n > 32) {
            n = 32;
        }
        System.arraycopy(this.encryptionPassword, 0, byArray2, 0, n);
        for (int i = n; i < 32; ++i) {
            byArray2[i] = (byte)Integer.parseInt(this.padding[i - n], 16);
        }
        return byArray2;
    }

    private boolean testPassword() throws PdfSecurityException {
        int n;
        int n2 = 32;
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(this.padding[i], 16);
        }
        byte[] byArray3 = (byte[])byArray.clone();
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray3 = this.decrypt(byArray3, "", true, null, false, false);
        } else if (this.rev >= 3) {
            Object object;
            n = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (object = (String)this.StmF.get("Length")) != null) {
                n = Integer.parseInt((String)object);
            }
            n2 = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            object = (byte[])this.encryptionKey.clone();
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with digest");
            }
            messageDigest.update(byArray3);
            byte[] byArray4 = new byte[this.ID.length() / 2];
            for (int i = 0; i < this.ID.length(); i += 2) {
                String string = this.ID.substring(i, i + 2);
                byArray4[i / 2] = (byte)Integer.parseInt(string, 16);
            }
            byArray2 = messageDigest.digest(byArray4);
            byArray2 = this.decrypt(byArray2, "", true, null, true, false);
            byte[] byArray5 = new byte[n];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(object[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", true, null, true, false);
            }
            this.encryptionKey = (byte[])object;
            byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, 0, 16);
            System.arraycopy(byArray, 0, byArray3, 16, 16);
        }
        n = 1;
        for (int i = 0; i < n2; ++i) {
            if (this.U[i] == byArray3[i]) continue;
            n = 0;
            i = this.U.length;
        }
        return n != 0;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        int n;
        MessageDigest messageDigest = null;
        String string = "";
        if (this.debugAES) {
            System.out.println("Compute encryption key");
        }
        byte[] byArray = this.getPaddedKey(this.encryptionPassword);
        if (this.debugAES) {
            string = "raw before 50 times   ---- ";
            for (n = 0; n < byArray.length; ++n) {
                string = string + byArray[n] + ' ';
            }
            System.out.println(string);
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.debugAES) {
                string = "encryptionKey before 50 times   ---- ";
                for (n = 0; n < byArray.length; ++n) {
                    string = string + byArray[n] + ' ';
                }
                System.out.println(string);
            }
            if (this.rev >= 3) {
                for (n = 0; n < 50; ++n) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        if (this.debugAES) {
            string = "returned encryptionKey   ---- ";
            for (n = 0; n < this.encryptionKey.length; ++n) {
                string = string + this.encryptionKey[n] + ' ';
            }
            System.out.println(string);
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        int n;
        String string = "";
        if (this.debugAES) {
            System.out.println("testOwnerPassword " + this.encryptionPassword.length);
        }
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = (byte[])this.O.clone();
        if (this.debugAES) {
            string = "originalPassword   ---- ";
            for (int i = 0; i < byArray.length; ++i) {
                string = string + byArray[i] + ' ';
            }
            System.out.println(string);
        }
        this.computeEncryptionKey();
        byte[] byArray4 = (byte[])this.encryptionKey.clone();
        if (this.rev == 2) {
            byArray2 = this.decrypt((byte[])this.O.clone(), "", false, null, false, false);
        } else if (this.rev >= 3) {
            Object object;
            n = this.keyLength;
            if (this.rev == 4 && this.StmF != null && (object = (Object)((String)this.StmF.get("Length"))) != null) {
                n = Integer.parseInt((String)object);
            }
            if (this.debugAES) {
                System.out.println("Decrypt 20 times");
            }
            byArray2 = byArray3;
            object = new byte[n];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    object[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = object;
                byArray2 = this.decrypt(byArray2, "", false, null, true, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.computeEncryptionKey();
        n = this.testPassword() ? 1 : 0;
        if (this.debugAES && n == 0) {
            System.out.println("Match failed on owner key");
            System.exit(1);
        }
        if (n == 0) {
            this.encryptionPassword = byArray;
            this.computeEncryptionKey();
        }
        return n != 0;
    }

    private final String findOffsets() throws PdfSecurityException {
        String string;
        block7: {
            LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            string = "";
            try {
                this.movePointer(0L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                int n;
                String string2 = null;
                int n2 = (int)this.getPointer();
                try {
                    string2 = this.pdf_datafile.readLine();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception " + exception + " reading line");
                }
                if (string2 == null) break block7;
                if (string2.indexOf(" obj") != -1) {
                    int n3 = string2.indexOf(32);
                    if (n3 <= -1) continue;
                    n = Integer.parseInt(string2.substring(0, n3));
                    this.storeObjectOffset(n, n2, 1, false);
                    continue;
                }
                if (string2.indexOf("Root") != -1) {
                    int n4 = string2.indexOf("Root") + 4;
                    n = string2.indexOf(82, n4);
                    if (n <= -1) continue;
                    string = string2.substring(n4, n + 1).trim();
                    continue;
                }
                if (string2.indexOf("/Encrypt") != -1) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return string;
    }

    public final void readEncryptionObject(String string) throws PdfSecurityException {
        int n;
        int n2;
        String string2;
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        Map map = this.readObject(string, true, null);
        if (this.debugAES) {
            System.out.println(map);
        }
        String string3 = (String)map.get("Filter");
        int n3 = 1;
        String string4 = (String)map.get("V");
        if (string4 != null) {
            n3 = Integer.parseInt(string4);
        }
        if ((string4 = (String)map.get("Length")) != null) {
            this.keyLength = Integer.parseInt(string4) / 8;
        }
        if (n3 == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method " + map);
        }
        if (n3 > 4 && string3.indexOf("Standard") == -1) {
            throw new PdfSecurityException("Unsupported Encryption method " + map);
        }
        this.rev = Integer.parseInt((String)map.get("R"));
        this.P = Integer.parseInt((String)map.get("P"));
        Object v = map.get("O");
        if (v instanceof String) {
            string2 = (String)v;
            int n4 = string2.length() / 2;
            this.O = new byte[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                n = n2 * 2;
                this.O[n2] = (byte)Integer.parseInt(string2.substring(n, n + 2), 16);
            }
        } else {
            this.O = (byte[])v;
        }
        if ((string2 = map.get("U")) instanceof String) {
            String string5 = string2;
            n2 = string5.length() / 2;
            this.U = new byte[n2];
            for (n = 0; n < n2; ++n) {
                int n5 = n * 2;
                this.U[n] = (byte)Integer.parseInt(string5.substring(n5, n5 + 2), 16);
            }
        } else {
            this.U = (byte[])string2;
        }
        if (n3 == 4) {
            String string6;
            Map map2 = (Map)map.get("CF");
            this.EFF = (String)map.get("EFF");
            this.CFM = (String)map.get("CFM");
            Object v2 = map.get("EncryptMetadata");
            if (v2 != null && ((String)v2).toLowerCase().equals("false")) {
                this.isMetaDataEncypted = false;
            }
            if ((string6 = (String)map.get("StrF")) != null) {
                this.StrFname = string6 = string6.substring(1);
                this.StrF = (Map)map2.get(string6);
                this.stringsEncoded = true;
            } else {
                this.StrF = null;
            }
            string6 = (String)map.get("StmF");
            if (string6 != null) {
                this.StmFname = string6 = string6.substring(1);
                this.StmF = (Map)map2.get(string6);
            } else {
                this.StmF = null;
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        try {
            this.verifyAccess();
        }
        catch (PdfSecurityException pdfSecurityException) {
            LogWriter.writeLog("File requires password");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean bl = this.testOwnerPassword();
        if (!bl) {
            boolean bl2 = this.testPassword();
            if (!bl2) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) == 16) {
                this.extractionIsAllowed = true;
            }
            this.passwordStatus = 1;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
    }

    private byte[] calculateKey(byte[] byArray, int n, String string) throws PdfSecurityException {
        byte[] byArray2;
        if (this.debugAES) {
            System.out.println("calculate key");
        }
        String string2 = "";
        MessageDigest messageDigest = null;
        byte[] byArray3 = null;
        byte[] byArray4 = this.getPaddedKey(this.encryptionPassword);
        try {
            Object object;
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray4);
            messageDigest.update(byArray);
            byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
            messageDigest.update(byArray2);
            string2 = "documentID   ---- ";
            byte[] byArray5 = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                object = string.substring(i, i + 2);
                byArray5[i / 2] = (byte)Integer.parseInt((String)object, 16);
                string2 = string2 + byArray5[i / 2] + ' ';
            }
            messageDigest.update(byArray5);
            if (this.debugAES) {
                System.out.println(string2 + " \n" + string);
            }
            byte[] byArray6 = new byte[]{-1, -1, -1, -1};
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                messageDigest.update(byArray6);
            }
            object = new byte[this.keyLength];
            System.arraycopy(messageDigest.digest(), 0, object, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(messageDigest.digest((byte[])object), 0, object, 0, this.keyLength);
                }
            }
            byArray3 = new byte[this.keyLength];
            System.arraycopy(object, 0, byArray3, 0, this.keyLength);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        byArray2 = new byte[this.keyLength];
        System.arraycopy(byArray3, 0, byArray2, 0, this.keyLength);
        return byArray2;
    }

    private final void readInformationObject(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = this.currentFileInformation.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], "z");
            }
            Map map = this.readObject(string, false, hashMap);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                Object v = map.get(stringArray[i]);
                if (v == null) continue;
                if (v instanceof byte[]) {
                    string2 = this.getTextString((byte[])v);
                    this.currentFileInformation.setFieldValue(i, string2);
                    continue;
                }
                if (!(v instanceof String)) continue;
                string2 = (String)v;
                if (string2.indexOf("False") != -1) {
                    this.currentFileInformation.setFieldValue(i, "False");
                    continue;
                }
                if (string2.indexOf("False") == -1) continue;
                this.currentFileInformation.setFieldValue(i, "True");
            }
        }
        catch (Exception exception) {
            System.out.println(" problem with info");
            LogWriter.writeLog("Exception " + exception + " reading information object " + string);
        }
    }

    public byte[] getPdfBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public String getTextString(byte[] byArray) {
        String string = "";
        StandardFonts.checkLoaded(6);
        String string2 = "";
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length];
        }
        int n = 0;
        Object var7_6 = null;
        TextTokens textTokens = new TextTokens(byArray);
        if (textTokens.isUnicode()) {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextUnicodeToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f') continue;
                cArray[n] = c;
                ++n;
            }
        } else {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f') continue;
                String string3 = StandardFonts.getEncodedChar(6, c);
                int n2 = string3.length();
                if (n + n2 >= cArray.length) {
                    char[] cArray2 = new char[n2 + n + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                for (int i = 0; i < n2; ++i) {
                    cArray[n] = string3.charAt(i);
                    ++n;
                }
            }
        }
        if (cArray != null) {
            string = String.copyValueOf(cArray, 0, n);
        }
        return string;
    }

    public void readJavascriptNames(Object object, Javascript javascript) {
        Map map = null;
        map = object instanceof String ? this.readObject((String)object, false, null) : (Map)object;
        String string = this.getValue((String)map.get("Names"));
        if (string != null) {
            String string2 = Strip.removeArrayDeleminators(string);
            if (string2.startsWith("<feff")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    string3 = string3.substring(1, string3.length() - 1);
                    String string4 = stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken();
                }
            } else if (string2.indexOf(40) != -1) {
                byte[] byArray = this.readObjectAsByteArray((String)object, false);
                int n = byArray.length;
                int n2 = 0;
                while (byArray[n2] != 47 || byArray[n2 + 1] != 78 || byArray[n2 + 2] != 97 || byArray[n2 + 3] != 109 || byArray[n2 + 4] != 101 || byArray[n2 + 5] != 115) {
                    ++n2;
                }
                n2 += 5;
                while (n2 < n) {
                    while (byArray[n2] != 40) {
                        ++n2;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        int n3;
                        StringBuffer stringBuffer;
                        if (byArray[n2 + 1] != 41) {
                            while (true) {
                                boolean bl = false;
                                if (byArray[++n2] == 92 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) {
                                    if (byArray[++n2] == 98) {
                                        byArray[n2] = 8;
                                    } else if (byArray[n2] == 110) {
                                        byArray[n2] = 10;
                                    } else if (byArray[n2] == 116) {
                                        byArray[n2] = 9;
                                    } else if (byArray[n2] == 114) {
                                        byArray[n2] = 13;
                                    } else if (byArray[n2] == 102) {
                                        byArray[n2] = 12;
                                    } else if (byArray[n2] == 92) {
                                        byArray[n2] = 92;
                                    } else if (Character.isDigit((char)byArray[n2])) {
                                        stringBuffer = new StringBuffer(3);
                                        for (n3 = 0; n3 < 3; ++n3) {
                                            stringBuffer.append((char)byArray[n2]);
                                            ++n2;
                                        }
                                        bl = true;
                                        byArray[--n2] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                    }
                                }
                                if (!bl && byArray[n2] == 41 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                byteArrayOutputStream.write(byArray[n2]);
                            }
                        }
                        byteArrayOutputStream.close();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        byArray2 = this.decrypt(byArray2, (String)object, false, null, false, false);
                        stringBuffer = new StringBuffer();
                        ++n2;
                        while (byArray[n2] == 32 | byArray[n2] == 10 | byArray[n2] == 13) {
                            ++n2;
                        }
                        n3 = n2;
                        while (byArray[n3] == 32) {
                            ++n3;
                        }
                        boolean bl = false;
                        while (byArray[n3] != 40 & n3 + 1 < n) {
                            if (byArray[n3] == 91) {
                                bl = true;
                            }
                            if (byArray[n3] == 93) break;
                            ++n3;
                        }
                        if (bl) {
                            n3 += 2;
                        }
                        int n4 = n3;
                        if (!bl && byArray[n3] == 93) {
                            n4 = n;
                        }
                        while (byArray[n3] == 32) {
                            --n3;
                        }
                        int n5 = n3 - n2;
                        stringBuffer = new StringBuffer(n5);
                        for (int i = 0; i < n5; ++i) {
                            stringBuffer.append((char)byArray[i + n2]);
                            if ((!bl && byArray[i + n2] == 82) | byArray[i + n2] == 93) break;
                        }
                        Map map2 = this.readObject(stringBuffer.toString(), false, null);
                        String string5 = (String)map2.get("S");
                        n2 = n4;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            } else {
                LogWriter.writeLog("Javascript format not supported");
            }
        }
    }

    public void readNames(Object object, Javascript javascript) {
        block39: {
            String string;
            String string2;
            String string3;
            Map map;
            block40: {
                String string4;
                Object v;
                block38: {
                    map = null;
                    map = object instanceof String ? this.readObject((String)object, false, null) : (Map)object;
                    v = map.get("Dests");
                    String string5 = this.getValue((String)map.get("Names"));
                    string3 = (String)map.get("JavaScript");
                    if (string5 == null) break block38;
                    String string6 = Strip.removeArrayDeleminators(string5);
                    if (string6.startsWith("<feff")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string6);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string7 = stringTokenizer.nextToken();
                            string7 = string7.substring(1, string7.length() - 1);
                            String string8 = stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken();
                            this.nameLookup.put(string7, string8);
                        }
                    } else if (string6.indexOf(40) != -1) {
                        byte[] byArray = this.readObjectAsByteArray((String)object, false);
                        int n = byArray.length;
                        int n2 = 0;
                        while (byArray[n2] != 47 || byArray[n2 + 1] != 78 || byArray[n2 + 2] != 97 || byArray[n2 + 3] != 109 || byArray[n2 + 4] != 101 || byArray[n2 + 5] != 115) {
                            ++n2;
                        }
                        n2 += 5;
                        while (n2 < n) {
                            while (byArray[n2] != 40) {
                                ++n2;
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            try {
                                int n3;
                                StringBuffer stringBuffer;
                                if (byArray[n2 + 1] != 41) {
                                    while (true) {
                                        boolean bl = false;
                                        if (byArray[++n2] == 92 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) {
                                            if (byArray[++n2] == 98) {
                                                byArray[n2] = 8;
                                            } else if (byArray[n2] == 110) {
                                                byArray[n2] = 10;
                                            } else if (byArray[n2] == 116) {
                                                byArray[n2] = 9;
                                            } else if (byArray[n2] == 114) {
                                                byArray[n2] = 13;
                                            } else if (byArray[n2] == 102) {
                                                byArray[n2] = 12;
                                            } else if (byArray[n2] == 92) {
                                                byArray[n2] = 92;
                                            } else if (Character.isDigit((char)byArray[n2])) {
                                                stringBuffer = new StringBuffer(3);
                                                for (n3 = 0; n3 < 3; ++n3) {
                                                    stringBuffer.append((char)byArray[n2]);
                                                    ++n2;
                                                }
                                                bl = true;
                                                byArray[--n2] = (byte)Integer.parseInt(stringBuffer.toString(), 8);
                                            }
                                        }
                                        if (!bl && byArray[n2] == 41 && (byArray[n2 - 1] != 92 || byArray[n2 - 1] == 92 && byArray[n2 - 2] == 92)) break;
                                        byteArrayOutputStream.write(byArray[n2]);
                                    }
                                }
                                byteArrayOutputStream.close();
                                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                                byArray2 = this.decrypt(byArray2, (String)object, false, null, false, false);
                                stringBuffer = new StringBuffer();
                                ++n2;
                                while (byArray[n2] == 32 | byArray[n2] == 10 | byArray[n2] == 13) {
                                    ++n2;
                                }
                                n3 = n2;
                                while (byArray[n3] == 32) {
                                    ++n3;
                                }
                                boolean bl = false;
                                while (byArray[n3] != 40 & n3 + 1 < n) {
                                    if (byArray[n3] == 91) {
                                        bl = true;
                                    }
                                    if (byArray[n3] == 93) break;
                                    ++n3;
                                }
                                if (bl) {
                                    n3 += 2;
                                }
                                int n4 = n3;
                                if (!bl && byArray[n3] == 93) {
                                    n4 = n;
                                }
                                while (byArray[n3] == 32) {
                                    --n3;
                                }
                                int n5 = n3 - n2;
                                stringBuffer = new StringBuffer(n5);
                                for (int i = 0; i < n5; ++i) {
                                    stringBuffer.append((char)byArray[i + n2]);
                                    if ((!bl && byArray[i + n2] == 82) | byArray[i + n2] == 93) break;
                                }
                                this.nameLookup.put(this.getTextString(byArray2), stringBuffer.toString());
                                n2 = n4;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        LogWriter.writeLog("Name list format not supported");
                    }
                    break block39;
                }
                if (v == null) break block40;
                Map map2 = null;
                map2 = v instanceof String ? this.readObject((String)v, false, null) : (Map)v;
                String string9 = (String)map2.get("Kids");
                if (string9 == null || (string4 = Strip.removeArrayDeleminators(this.getValue((String)map2.get("Kids")))).length() <= 0) break block39;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    this.readNames(stringTokenizer.nextToken().trim() + " R", javascript);
                }
                break block39;
            }
            if (string3 == null && (string2 = (String)map.get("Kids")) != null && (string = Strip.removeArrayDeleminators(this.getValue((String)map.get("Kids")))).length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    this.readNames(stringTokenizer.nextToken().trim() + " R", javascript);
                }
            }
        }
    }

    public String convertNameToRef(String string) {
        return (String)this.nameLookup.get(string);
    }

    public void flattenValuesInObject(boolean bl, boolean bl2, Map map, Map map2, Map map3, PageLookup pageLookup, String object) {
        if (bl) {
            map2.put("PageNumber", "1");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            Object object2;
            String string = (String)iterator.next();
            Object object3 = null;
            if (string.equals("P")) {
                try {
                    object2 = map.get("P");
                    if (object2 != null && pageLookup != null && object2 instanceof String) {
                        int n = pageLookup.convertObjectToPageNumber((String)object2);
                        map2.put("PageNumber", String.valueOf(n));
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("Stream")) {
                object2 = this.readStream(map, (String)object, false, true, false, false, false);
                map2.put("DecodedStream", object2);
            } else if (!string.equals("Kids") && !string.equals("Parent")) {
                object3 = map.get(string);
            } else if (bl2 && string.equals("Kids") && (object2 = (String)map.get("Kids")) != null) {
                HashMap hashMap2 = new HashMap();
                if (((String)object2).startsWith("[")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1).trim();
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, "R");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim() + " R";
                    hashMap = new HashMap();
                    this.flattenValuesInObject(true, bl2, this.readObject(string2, false, map3), hashMap, map3, pageLookup, (String)object);
                    hashMap2.put(string2, hashMap);
                }
                map2.put("Kids", hashMap2);
            }
            if (object3 == null) continue;
            if (string.equals("rawValue")) {
                if (object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                    object3 = this.getTextString((byte[])object2);
                }
            } else if (map3 != null && map3.get(string) != null && object3 instanceof byte[] && (object2 = (Object)this.getByteTextStringValue(object3, map3)) != null) {
                object3 = this.getTextString((byte[])object2);
            }
            if (object3 instanceof String) {
                object2 = object3.toString();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                if (stringTokenizer.countTokens() == 3) {
                    int n = ((String)object2).indexOf(" R");
                    int n2 = ((String)object2).indexOf(" R", n + 1);
                    if (n2 == -1 && ((String)object2).endsWith("]") && ((String)object2).indexOf(" R") != -1) {
                        object = object2 = Strip.removeArrayDeleminators((String)object2);
                        hashMap = new HashMap();
                        this.flattenValuesInObject(bl, bl2, this.readObject((String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    if (n2 == -1 && ((String)object2).endsWith(" R")) {
                        hashMap = new HashMap();
                        object = object2;
                        this.flattenValuesInObject(bl, bl2, this.readObject((String)object2, false, map3), hashMap, map3, pageLookup, (String)object);
                        map2.put(string, hashMap);
                        continue;
                    }
                    map2.put(string, object3);
                    continue;
                }
                map2.put(string, object3);
                continue;
            }
            if (object3 instanceof Map) {
                object2 = (Map)object3;
                HashMap hashMap3 = new HashMap();
                this.flattenValuesInObject(bl, bl2, (Map)object2, hashMap3, map3, pageLookup, (String)object);
                map2.put(string, hashMap3);
                continue;
            }
            map2.put(string, object3);
        }
    }

    public void setCacheSize(int n) {
        this.miniumumCacheSize = n;
    }

    public byte[] readStreamFromPDF(int n, int n2) {
        byte[] byArray = new byte[n2 - n + 1];
        try {
            this.movePointer(n);
            this.pdf_datafile.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public void setInterruptRefReading(boolean bl) {
        this.interruptRefReading = bl;
    }

    public void readStreamIntoMemory(Map map) {
        String string = (String)map.get("CachedStream");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            int n = (int)new File(string).length();
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            map.put("DecodedStream", byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        String string = System.getProperty("org.jpedal.cipher.reinit");
        if (string != null && string.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
        powers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

