/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.PassiveConnectTask;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class GridFTPPassiveConnectTask
extends PassiveConnectTask {
    protected static Log logger = LogFactory.getLog(GridFTPPassiveConnectTask.class.getName());
    GridFTPSession gSession;

    public GridFTPPassiveConnectTask(ServerSocket myServer, DataSink sink, BasicServerControlChannel control, GridFTPSession session, DataChannelFactory factory, EBlockParallelTransferContext context) {
        super(myServer, sink, control, (Session)session, factory, (TransferContext)context);
        this.gSession = session;
    }

    public GridFTPPassiveConnectTask(ServerSocket myServer, DataSource source, BasicServerControlChannel control, GridFTPSession session, DataChannelFactory factory, EBlockParallelTransferContext context) {
        super(myServer, source, control, (Session)session, factory, (TransferContext)context);
        this.gSession = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SocketBox openSocket() throws Exception {
        logger.debug("server.accept()");
        Socket newSocket = this.myServer.accept();
        if (this.gSession.TCPBufferSize != -1) {
            logger.debug("setting socket's TCP buffer size to " + this.gSession.TCPBufferSize);
            newSocket.setReceiveBufferSize(this.gSession.TCPBufferSize);
            newSocket.setSendBufferSize(this.gSession.TCPBufferSize);
        }
        logger.debug("server.accept() returned");
        if (!this.gSession.dataChannelAuthentication.equals(DataChannelAuthentication.NONE)) {
            logger.debug("authenticating");
            newSocket = GridFTPServerFacade.authenticate(newSocket, false, this.gSession.credential, this.gSession.dataChannelProtection, this.gSession.dataChannelAuthentication);
        } else {
            logger.debug("not authenticating");
        }
        ManagedSocketBox sBox = new ManagedSocketBox();
        sBox.setSocket(newSocket);
        sBox.setStatus(2);
        if (this.session.transferMode != 3) {
            ManagedSocketBox managedSocketBox = sBox;
            synchronized (managedSocketBox) {
                sBox.setReusable(false);
            }
        }
        SocketPool socketPool = ((EBlockParallelTransferContext)this.context).getSocketPool();
        logger.debug("adding new socket to the pool");
        socketPool.add(sBox);
        logger.debug("available cached sockets: " + socketPool.countFree() + "; busy: " + socketPool.countBusy());
        return sBox;
    }
}

