/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net;

import java.io.IOException;
import java.io.InputStream;
import org.globus.common.ChainedIOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public abstract class GssInputStream
extends InputStream {
    protected InputStream in;
    protected GSSContext context;
    protected byte[] buff;
    protected int index;

    public GssInputStream(InputStream in, GSSContext context) {
        this.in = in;
        this.context = context;
        this.buff = new byte[0];
        this.index = 0;
    }

    protected byte[] unwrap(byte[] msg) throws IOException {
        try {
            return this.context.unwrap(msg, 0, msg.length, null);
        }
        catch (GSSException e) {
            throw new ChainedIOException("unwrap failed", e);
        }
    }

    protected abstract void readMsg() throws IOException;

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        if (!this.hasData()) {
            return -1;
        }
        int max = this.index + len > this.buff.length ? this.buff.length - this.index : len;
        System.arraycopy(this.buff, this.index, data, off, max);
        this.index += max;
        return max;
    }

    @Override
    public int read() throws IOException {
        if (!this.hasData()) {
            return -1;
        }
        return this.buff[this.index++] & 0xFF;
    }

    protected boolean hasData() throws IOException {
        if (this.buff == null) {
            return false;
        }
        if (this.buff.length == this.index) {
            this.readMsg();
        }
        if (this.buff == null) {
            return false;
        }
        return this.buff.length != this.index;
    }

    @Override
    public void close() throws IOException {
        this.buff = null;
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        if (this.buff == null) {
            return -1;
        }
        int avail = this.buff.length - this.index;
        return avail == 0 ? this.in.available() : avail;
    }
}

