/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.io.File;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import org.globus.gsi.CertUtil;
import org.globus.gsi.TrustedCertificates;
import org.globus.tools.ui.config.CertInfo;

class CertificateListModel
extends AbstractListModel {
    private Vector certificates;

    CertificateListModel() {
    }

    public void setCertList(String certList) {
        this.certificates = new Vector();
        if (certList == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(certList, ",");
        while (tokens.hasMoreTokens()) {
            File certFile = new File(tokens.nextToken().trim());
            if (certFile.isDirectory()) {
                File[] caCertFiles = certFile.listFiles(TrustedCertificates.getCertFilter());
                for (int i = 0; i < caCertFiles.length; ++i) {
                    this.loadCert(caCertFiles[i].getAbsolutePath());
                }
                continue;
            }
            this.loadCert(certFile.getAbsolutePath());
        }
    }

    public void loadCert(String certFile) {
        try {
            X509Certificate cert = CertUtil.loadCertificate(certFile);
            this.certificates.addElement(new CertInfo(cert, certFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCertFileList() {
        int size = this.getSize();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            CertInfo info = this.getCertInfoAt(i);
            buf.append(info.file);
            if (i + 1 >= size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void addCertInfo(CertInfo newCert) throws Exception {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            CertInfo info = this.getCertInfoAt(i);
            if (!info.cert.equals(newCert.cert)) continue;
            throw new Exception("CA already in the list.");
        }
        this.certificates.addElement(newCert);
        this.fireIntervalAdded(this, size, size);
    }

    public void verifyUserCertificate(X509Certificate usercert) throws Exception {
        int size = this.getSize();
        if (size == 0) {
            throw new Exception("At least one CA certificate is required.");
        }
        Principal issuerDN = usercert.getIssuerDN();
        CertInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = this.getCertInfoAt(i);
            if (!((Object)info.cert.getSubjectDN()).equals(issuerDN)) continue;
            try {
                usercert.verify(info.cert.getPublicKey());
            }
            catch (GeneralSecurityException e) {
                throw new Exception("User certificate probably not signed by this CA : " + e.getMessage());
            }
            return;
        }
        throw new Exception("No CA certificate for the user certificate found.");
    }

    @Override
    public int getSize() {
        return this.certificates.size();
    }

    public CertInfo getCertInfoAt(int i) {
        return (CertInfo)this.certificates.elementAt(i);
    }

    @Override
    public Object getElementAt(int i) {
        return this.getCertInfoAt((int)i).cert.getSubjectDN();
    }

    public void removeCertAt(int i) {
        this.certificates.removeElementAt(i);
        this.fireIntervalRemoved(this, i, i);
    }
}

