/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ColorspaceDecoder {
    public static boolean unsupportPatterns = false;

    private ColorspaceDecoder() {
    }

    public static final GenericColorSpace getColorSpaceInstance(boolean bl, float[][] fArray, String string, Map map, PdfObjectReader pdfObjectReader) {
        int n = -1;
        if (string != null) {
            n = string.indexOf("<<");
            if (map == null && n != -1) {
                map = pdfObjectReader.directValuesToMap(string, false);
                string = string.substring(0, n) + ']';
            }
        }
        if (n == -1 && map != null && !map.isEmpty()) {
            String string2 = Strip.removeArrayDeleminators((String)map.get("rawValue"));
            if (string2.indexOf(47) != -1) {
                string = string2;
            } else {
                Iterator iterator = map.keySet().iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3.equals("rawValue")) continue;
                    stringBuffer.append(string3);
                }
                string = stringBuffer.toString();
            }
        } else if (string.startsWith("[")) {
            string = Strip.removeArrayDeleminators(string);
        }
        int n2 = ColorSpaces.convertNameToID(string);
        if (n2 == 10) {
            return new SeparationColorSpace(pdfObjectReader, string, map);
        }
        if (n2 == 11 && ColorSpaces.useDeviceN) {
            return new DeviceNColorSpace(pdfObjectReader, string, map);
        }
        return ColorspaceDecoder.getColorSpaceInstance(bl, fArray, string, n2, map, pdfObjectReader);
    }

    public static final GenericColorSpace getColorSpaceInstance(boolean bl, float[][] fArray, String string, int n, Map map, PdfObjectReader pdfObjectReader) {
        Object object;
        String string2;
        int n2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl2 = false;
        String string8 = "";
        String string9 = "";
        String string10 = null;
        if (map == null && string.indexOf("<<") != -1) {
            map = pdfObjectReader.directValuesToMap(string, true);
        }
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        if (n == 8) {
            CharSequence charSequence;
            Object object2;
            n2 = string.indexOf("/Indexed");
            string2 = string.substring(n2 + 8, string.length()).trim();
            object = new StringTokenizer(string2, "] ");
            if ((string = ((StringTokenizer)object).nextToken()).equals("[")) {
                if (map == null) {
                    int n3 = string2.indexOf(93);
                    if ((n3 = string2.indexOf(93, n3 + 1)) != -1) {
                        string = string2.substring(1, n3).trim();
                        object = new StringTokenizer(string2.substring(n3 + 1, string2.length()).trim(), "] ");
                    }
                } else {
                    Iterator iterator = map.keySet().iterator();
                    object2 = new StringBuffer();
                    while (iterator.hasNext()) {
                        charSequence = (String)iterator.next();
                        if (((String)charSequence).equals("rawValue")) continue;
                        ((StringBuffer)object2).append((String)charSequence);
                    }
                    string = ((StringBuffer)object2).toString();
                }
            }
            string9 = ((StringTokenizer)object).nextToken();
            string8 = ((StringTokenizer)object).nextToken();
            if (string8.equals("R")) {
                Map map2 = pdfObjectReader.readObject(string + ' ' + string9 + " R", true, null);
                if ((string = Strip.removeArrayDeleminators((String)map2.get("rawValue")).trim()).length() == 0) {
                    map = map2;
                    object2 = map2.keySet().iterator();
                    charSequence = new StringBuffer();
                    while (object2.hasNext()) {
                        String string11 = (String)object2.next();
                        if (string11.equals("rawValue")) continue;
                        ((StringBuffer)charSequence).append(string11);
                    }
                    string = ((StringBuffer)charSequence).toString();
                }
                string9 = ((StringTokenizer)object).nextToken();
                string8 = ((StringTokenizer)object).nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer(string8);
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append(' ');
                stringBuffer.append(((StringTokenizer)object).nextToken());
            }
            string8 = stringBuffer.toString();
            bl2 = true;
            n = ColorSpaces.convertNameToID(string);
        }
        if (n == 10) {
            genericColorSpace = new SeparationColorSpace(pdfObjectReader, string, map);
        } else if (n == 11 && ColorSpaces.useDeviceN) {
            genericColorSpace = new DeviceNColorSpace(pdfObjectReader, string, map);
        } else if (n == 7) {
            n2 = string.indexOf("/ICCBased");
            string2 = string.substring(n2 + 9);
            if ((n2 = string2.indexOf(93)) != -1) {
                string2 = string2.substring(0, n2 - 1);
            }
            if (string2.indexOf(" R") != -1) {
                object = pdfObjectReader.readObject(string2.trim(), false, null);
                string10 = (String)object.get("Alternate");
            } else {
                string10 = string2.trim();
            }
        }
        if (n == 1) {
            genericColorSpace = new DeviceGrayColorSpace();
        } else if (n == 2) {
            genericColorSpace = new DeviceRGBColorSpace();
        } else if (n == 3) {
            genericColorSpace = new DeviceCMYKColorSpace();
        } else if (n == 4) {
            Map map3 = (Map)map.get("CalGray");
            if (map3 == null) {
                map3 = map;
            }
            string3 = pdfObjectReader.getValue((String)map3.get("WhitePoint"));
            string4 = pdfObjectReader.getValue((String)map3.get("BlackPoint"));
            string6 = pdfObjectReader.getValue((String)map3.get("Gamma"));
            genericColorSpace = new CalGrayColorSpace(string3, string4, string6);
        } else if (n == 5) {
            Map map4 = null;
            if (map != null) {
                map4 = (Map)map.get("CalRGB");
            }
            if (map4 == null) {
                map4 = map;
            }
            if (map4 != null) {
                string3 = pdfObjectReader.getValue((String)map4.get("WhitePoint"));
                string4 = pdfObjectReader.getValue((String)map4.get("BlackPoint"));
                string7 = pdfObjectReader.getValue((String)map4.get("Matrix"));
                string6 = pdfObjectReader.getValue((String)map4.get("Gamma"));
            }
            genericColorSpace = new CalRGBColorSpace(string3, string4, string7, string6);
        } else if (n == 6) {
            Map map5 = (Map)map.get("Lab");
            string3 = pdfObjectReader.getValue((String)map5.get("WhitePoint"));
            string4 = pdfObjectReader.getValue((String)map5.get("BlackPoint"));
            string5 = pdfObjectReader.getValue((String)map5.get("Range"));
            genericColorSpace = new LabColorSpace(string3, string4, string5);
        } else if (n == 7) {
            genericColorSpace = new ICCColorSpace(pdfObjectReader, string);
            if (genericColorSpace.isInvalid()) {
                n2 = string.indexOf("/ICCBased");
                string2 = string.substring(n2 + 9);
                if ((n2 = string2.indexOf(93)) != -1) {
                    string2 = string2.substring(0, n2 - 1);
                }
                if (string2.indexOf(" R") != -1) {
                    object = pdfObjectReader.readObject(string2.trim(), false, null);
                    string10 = (String)object.get("Alternate");
                } else {
                    string10 = string2.trim();
                }
                if (string10 != null && string10.length() > 1) {
                    string = string10;
                    n = ColorSpaces.convertNameToID(string);
                }
            }
        } else if (n == 9) {
            LogWriter.writeLog("Pattern Colorspace unsupported in GPL version");
            unsupportPatterns = true;
        }
        if (bl2) {
            int n4 = Integer.parseInt(string9);
            if (string8.endsWith(" R")) {
                genericColorSpace.setIndex(pdfObjectReader.readStream(string8, true), n4);
            } else {
                genericColorSpace.setIndex(string8, string, n4);
            }
        }
        genericColorSpace.setAlternative(string10);
        return genericColorSpace;
    }
}

