/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.io.File;
import java.util.Iterator;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ExtractFormDataAsObject {
    private String outputDir = System.getProperty("user.dir");
    private int fileCount = 0;
    static boolean outputMessages = false;
    String separator = System.getProperty("file.separator");
    PdfDecoder decodePdf = null;
    private static String test_file = "/PDFdata/files-jpedal/Testdokument PDF.pdf";

    public int getFileCount() {
        return this.fileCount;
    }

    public ExtractFormDataAsObject() {
    }

    public ExtractFormDataAsObject(String string) {
        File file;
        if (!this.outputDir.endsWith(this.separator)) {
            this.outputDir = this.outputDir + this.separator + "forms" + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodePage("", string);
        } else {
            String[] stringArray = null;
            File file2 = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file2.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    if (outputMessages) {
                        System.out.println(">>_" + string + stringArray[n]);
                    }
                    this.decodePage(string, stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodePage(String string, String string2) {
        String string3 = string + string2;
        try {
            this.decodePdf = new PdfDecoder(false);
            if (outputMessages) {
                System.out.println("Opening file :" + string3);
            }
            this.decodePdf.openPdfFile(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Exception " + exception + " in pdf code with " + string3);
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isExtractionAllowed()) {
            if (outputMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
            }
        } else {
            ++this.fileCount;
            Iterator iterator = null;
            try {
                iterator = this.decodePdf.getNamesForAllFields().iterator();
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
            while (iterator != null && iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (outputMessages) {
                    System.out.println(string4);
                }
                Object object = this.decodePdf.getFormDataForField(string4);
                System.out.println(string4 + ' ' + object);
            }
        }
        this.decodePdf.closePdfFile();
    }

    public static void main(String[] stringArray) {
        File file;
        if (outputMessages) {
            System.out.println("Simple demo to extract form data");
        }
        String string = test_file;
        if (stringArray.length != 1) {
            if (outputMessages) {
                System.out.println("Default test file used");
            }
        } else {
            string = stringArray[0];
            if (outputMessages) {
                System.out.println("File :" + string);
            }
        }
        if (!(file = new File(string)).exists() && outputMessages) {
            System.out.println("File " + string + " not found");
        }
        ExtractFormDataAsObject extractFormDataAsObject = new ExtractFormDataAsObject(string);
    }

    public String getOutputDir() {
        return this.outputDir;
    }
}

