/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultTransferHandler
extends TransferHandler {
    private Commands currentCommands;
    private SwingGUI currentGUI;
    private GUIThumbnailPanel thumbnails;
    private Values commonValues;

    public DefaultTransferHandler(Values values, GUIThumbnailPanel gUIThumbnailPanel, SwingGUI swingGUI, Commands commands) {
        this.commonValues = values;
        this.thumbnails = gUIThumbnailPanel;
        this.currentGUI = swingGUI;
        this.currentCommands = commands;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return true;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        DataFlavor dataFlavor = null;
        int n = dataFlavorArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
            dataFlavor = dataFlavorArray[i];
        }
        try {
            DataFlavor dataFlavor2 = DataFlavor.selectBestTextFlavor(dataFlavorArray);
            if (dataFlavor2 != null) {
                Reader reader = dataFlavor2.getReaderForText(transferable);
                String string = this.readTextDate(reader);
                String string2 = this.getURL(string = this.removeChar(string, '\u0000'));
                if (string2.indexOf("file:/") != string2.lastIndexOf("file:/")) {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                } else {
                    this.openFile(string2);
                }
            } else if (dataFlavor != null) {
                List list = (List)transferable.getTransferData(dataFlavor);
                if (list.size() == 1) {
                    File file = (File)list.get(0);
                    this.openFile(file.getAbsolutePath());
                } else {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void openFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (string != null) {
            File file = new File(string);
            boolean bl = false;
            if (string.startsWith("http:") || string.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                bl = true;
            }
            if (!bl && !file.exists()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!bl && file.isDirectory()) {
                this.currentGUI.showMessageDialog(string + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                boolean bl2;
                boolean bl3 = bl2 = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
                if (bl2) {
                    this.commonValues.setSelectedFile(string);
                    this.commonValues.setFileSize(file.length() >> 10);
                    this.currentGUI.setViewerTitle(null);
                    this.currentCommands.openFile(string);
                } else {
                    this.currentGUI.showMessageDialog("You may only import a valid PDF or image");
                }
            }
        }
    }

    private String removeChar(String string, char c) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    private String getURL(String string) throws ParserConfigurationException, SAXException, IOException {
        if (!string.startsWith("http://") && !string.startsWith("file://")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            Element element = (Element)document.getElementsByTagName("a").item(0);
            string = this.getHrefAttribute(element);
        }
        return string;
    }

    private String readTextDate(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            string = string + string2;
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return string;
    }

    private String getHrefAttribute(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("href");
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }
}

