/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    public TrueType() {
    }

    public void readFontData(byte[] byArray, FontData fontData) {
        LogWriter.writeMethod("{readFontData}", 0);
        this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, byArray, fontData);
    }

    protected void substituteFontUsed(String string, String string2) throws PdfFontException {
        InputStream inputStream = null;
        try {
            inputStream = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
        if (inputStream == null) {
            throw new PdfFontException("Unable to load font " + string);
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            FontData fontData = null;
            this.readFontData(byteArrayOutputStream.toByteArray(), fontData);
            this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), true, this.isCIDFont);
            this.isFontEmbedded = true;
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
            LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
        }
    }

    public TrueType(String string) {
        this.glyphs = new TTGlyphs();
        this.init(null);
        this.substituteFont = string;
    }

    public TrueType(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new TTGlyphs();
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    public Map createFont(Map map, String string, boolean bl, Map map2, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readTrueTypeFont}" + map, 0);
        this.fontTypes = 2;
        Map map3 = super.createFont(map, string, bl, map2, objectStore);
        if (bl) {
            Object object;
            Object object2;
            if (map3 != null) {
                object2 = map3.get("FontFile2");
                try {
                    if (object2 != null) {
                        byte[] byArray = null;
                        object = null;
                        byArray = object2 instanceof String ? this.currentPdfFile.readStream((String)object2, true) : (byte[])((Map)object2).get("DecodedStream");
                        this.readEmbeddedFont(byArray, (FontData)object, this.hasEncoding, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                if (this.glyphs.remapFont) {
                    this.glyphs.remapFont = false;
                }
                object2 = new File(this.substituteFont);
                int n = (int)((File)object2).length();
                if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
                    object = new FontData(this.substituteFont);
                    this.readEmbeddedFont(null, (FontData)object, false, true);
                } else {
                    int n2;
                    InputStream inputStream = this.loader.getResourceAsStream(this.substituteFont);
                    object = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[65535];
                    while ((n2 = ((FilterInputStream)object).read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    byteArrayOutputStream.close();
                    ((BufferedInputStream)object).close();
                    this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(map);
        if (bl) {
            this.setFont(this.glyphs.fontName, 1);
        }
        return map3;
    }

    public void createFont(String string) throws Exception {
        this.fontTypes = 2;
        this.setBaseFontName(string);
        File file = new File(this.substituteFont);
        int n = (int)file.length();
        if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
            FontData fontData = new FontData(this.substituteFont);
            this.readEmbeddedFont(null, fontData, false, true);
        } else {
            int n2;
            InputStream inputStream = this.loader.getResourceAsStream(this.substituteFont);
            BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[65535];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.close();
            bufferedInputStream.close();
            this.readEmbeddedFont(byteArrayOutputStream.toByteArray(), null, false, true);
        }
        this.isFontSubstituted = true;
    }

    protected final void readEmbeddedFont(byte[] byArray, FontData fontData, boolean bl, boolean bl2) {
        LogWriter.writeMethod("{readEmbeddedFont}", 0);
        try {
            LogWriter.writeLog("Embedded TrueType font used");
            this.readFontData(byArray, fontData);
            this.isFontEmbedded = true;
            this.glyphs.setEncodingToUse(bl, this.getFontEncoding(false), bl2, this.TTstreamisCID);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " processing TrueType font");
            exception.printStackTrace();
        }
    }
}

