/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.render.DynamicVectorRenderer;

public class T3Glyph
implements PdfGlyph {
    private boolean lockColours = false;
    DynamicVectorRenderer glyphDisplay;
    private int maxWidth;
    private int maxHeight;
    String stringName = "";

    public T3Glyph() {
    }

    public String getGlyphName() {
        return this.stringName;
    }

    public void setStringName(String string) {
        this.stringName = string;
    }

    public T3Glyph(DynamicVectorRenderer dynamicVectorRenderer, int n, int n2, boolean bl, String string) {
        this.glyphDisplay = dynamicVectorRenderer;
        this.maxWidth = n;
        this.maxHeight = n2;
        this.lockColours = bl;
        this.stringName = string;
    }

    public Area getShape() {
        return null;
    }

    public void render(int n, Graphics2D graphics2D, boolean bl, float f) {
        this.glyphDisplay.setScalingValues(0.0, 0.0, f);
        this.glyphDisplay.paint(graphics2D, null, null, null, false, false);
    }

    public float getmaxWidth() {
        return this.maxWidth;
    }

    public int getmaxHeight() {
        return this.maxHeight;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.glyphDisplay.lockColors(pdfPaint, pdfPaint2);
    }

    public boolean ignoreColors() {
        return this.lockColours;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.glyphDisplay.serializeToByteArray(null);
        int n = byArray.length;
        objectOutput.writeObject(byArray);
        objectOutput.writeInt(this.maxWidth);
        objectOutput.writeInt(this.maxHeight);
        objectOutput.writeBoolean(this.lockColours);
    }

    public T3Glyph(ObjectInput objectInput) {
        try {
            byte[] byArray = (byte[])objectInput.readObject();
            this.glyphDisplay = new DynamicVectorRenderer(byArray, null);
            this.maxWidth = objectInput.readInt();
            this.maxHeight = objectInput.readInt();
            this.lockColours = objectInput.readBoolean();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void flushArea() {
    }

    public void setDisplacement(short s, float f) {
    }

    public void setWidth(float f) {
    }
}

