/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    public static final TypeDescriptor NULL = new TypeDescriptor();
    private static final Map<Class<?>, TypeDescriptor> typeDescriptorCache = new HashMap();
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private Class<?> type;
    private MethodParameter methodParameter;
    private Field field;
    private int fieldNestingLevel = 1;
    private TypeDescriptor elementType;
    private TypeDescriptor mapKeyType;
    private TypeDescriptor mapValueType;
    private Annotation[] annotations;

    static {
        typeDescriptorCache.put(Boolean.TYPE, new TypeDescriptor(Boolean.TYPE));
        typeDescriptorCache.put(Boolean.class, new TypeDescriptor(Boolean.class));
        typeDescriptorCache.put(Byte.TYPE, new TypeDescriptor(Byte.TYPE));
        typeDescriptorCache.put(Byte.class, new TypeDescriptor(Byte.class));
        typeDescriptorCache.put(Character.TYPE, new TypeDescriptor(Character.TYPE));
        typeDescriptorCache.put(Character.class, new TypeDescriptor(Character.class));
        typeDescriptorCache.put(Short.TYPE, new TypeDescriptor(Short.TYPE));
        typeDescriptorCache.put(Short.class, new TypeDescriptor(Short.class));
        typeDescriptorCache.put(Integer.TYPE, new TypeDescriptor(Integer.TYPE));
        typeDescriptorCache.put(Integer.class, new TypeDescriptor(Integer.class));
        typeDescriptorCache.put(Long.TYPE, new TypeDescriptor(Long.TYPE));
        typeDescriptorCache.put(Long.class, new TypeDescriptor(Long.class));
        typeDescriptorCache.put(Float.TYPE, new TypeDescriptor(Float.TYPE));
        typeDescriptorCache.put(Float.class, new TypeDescriptor(Float.class));
        typeDescriptorCache.put(Double.TYPE, new TypeDescriptor(Double.TYPE));
        typeDescriptorCache.put(Double.class, new TypeDescriptor(Double.class));
        typeDescriptorCache.put(String.class, new TypeDescriptor(String.class));
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.type = methodParameter.getParameterType();
        this.methodParameter = methodParameter;
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.type = field.getType();
        this.field = field;
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        if (type == null) {
            return NULL;
        }
        TypeDescriptor desc = typeDescriptorCache.get(type);
        return desc != null ? desc : new TypeDescriptor(type);
    }

    public static TypeDescriptor forObject(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof Collection) {
            return new TypeDescriptor(object.getClass(), CollectionUtils.findCommonElementType((Collection)object));
        }
        if (object instanceof Map) {
            return new TypeDescriptor(object.getClass(), CollectionUtils.findCommonElementType(((Map)object).keySet()), CollectionUtils.findCommonElementType(((Map)object).values()));
        }
        return TypeDescriptor.valueOf(object.getClass());
    }

    public static TypeDescriptor forNestedType(MethodParameter methodParameter) {
        return new TypeDescriptor(TypeDescriptor.resolveNestedType(methodParameter), methodParameter);
    }

    public static TypeDescriptor forNestedType(Class<?> nestedType, MethodParameter methodParameter) {
        return new TypeDescriptor(nestedType, methodParameter);
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public synchronized Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.resolveAnnotations();
        }
        return this.annotations;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAssignableTo(TypeDescriptor targetType) {
        if (this == NULL || targetType == NULL) {
            return true;
        }
        if (this.isCollection() && targetType.isCollection() || this.isArray() && targetType.isArray()) {
            return targetType.getType().isAssignableFrom(this.getType()) && this.getElementTypeDescriptor().isAssignableTo(targetType.getElementTypeDescriptor());
        }
        if (this.isMap() && targetType.isMap()) {
            return targetType.getType().isAssignableFrom(this.getType()) && this.getMapKeyTypeDescriptor().isAssignableTo(targetType.getMapKeyTypeDescriptor()) && this.getMapValueTypeDescriptor().isAssignableTo(targetType.getMapValueTypeDescriptor());
        }
        return targetType.getObjectType().isAssignableFrom(this.getObjectType());
    }

    public String asString() {
        return this.toString();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public Class<?> getElementType() {
        return this.getElementTypeDescriptor().getType();
    }

    public synchronized TypeDescriptor getElementTypeDescriptor() {
        if (this.elementType == null) {
            this.elementType = this.resolveElementTypeDescriptor();
        }
        return this.elementType;
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public Class<?> getMapKeyType() {
        return this.getMapKeyTypeDescriptor().getType();
    }

    public synchronized TypeDescriptor getMapKeyTypeDescriptor() {
        if (this.mapKeyType == null) {
            this.mapKeyType = this.resolveMapKeyTypeDescriptor();
        }
        return this.mapKeyType;
    }

    public Class<?> getMapValueType() {
        return this.getMapValueTypeDescriptor().getType();
    }

    public synchronized TypeDescriptor getMapValueTypeDescriptor() {
        if (this.mapValueType == null) {
            this.mapValueType = this.resolveMapValueTypeDescriptor();
        }
        return this.mapValueType;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public TypeDescriptor applyIndexedObject(Object object) {
        if (object == null) {
            return this;
        }
        if (object instanceof Collection) {
            return new TypeDescriptor(object.getClass(), CollectionUtils.findCommonElementType((Collection)object));
        }
        if (object instanceof Map) {
            return new TypeDescriptor(object.getClass(), CollectionUtils.findCommonElementType(((Map)object).keySet()), CollectionUtils.findCommonElementType(((Map)object).values()));
        }
        return TypeDescriptor.valueOf(object.getClass());
    }

    public boolean equals(Object obj) {
        boolean annotatedTypeEquals;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeDescriptor) || obj == NULL) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        boolean bl = annotatedTypeEquals = this.getType().equals(other.getType()) && ObjectUtils.nullSafeEquals(this.getAnnotations(), other.getAnnotations());
        if (this.isCollection()) {
            return annotatedTypeEquals && ObjectUtils.nullSafeEquals(this.getElementType(), other.getElementType());
        }
        if (this.isMap()) {
            return annotatedTypeEquals && ObjectUtils.nullSafeEquals(this.getMapKeyType(), other.getMapKeyType()) && ObjectUtils.nullSafeEquals(this.getMapValueType(), other.getMapValueType());
        }
        return annotatedTypeEquals;
    }

    public int hashCode() {
        return this == NULL ? 0 : this.getType().hashCode();
    }

    public String toString() {
        Annotation[] anns;
        if (this == NULL) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        Annotation[] annotationArray = anns = this.getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            builder.append("@").append(ann.annotationType().getName()).append(' ');
            ++n2;
        }
        builder.append(ClassUtils.getQualifiedName(this.getType()));
        if (this.isMap()) {
            builder.append("<").append(this.getMapKeyTypeDescriptor());
            builder.append(", ").append(this.getMapValueTypeDescriptor()).append(">");
        } else if (this.isCollection()) {
            builder.append("<").append(this.getElementTypeDescriptor()).append(">");
        }
        return builder.toString();
    }

    protected TypeDescriptor(Class<?> nestedType, MethodParameter methodParameter) {
        this.type = this.handleUnknownNestedType(nestedType);
        this.methodParameter = this.createNestedMethodParameter(methodParameter);
    }

    protected Annotation[] resolveAnnotations() {
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        if (this.methodParameter != null) {
            if (this.methodParameter.getParameterIndex() < 0) {
                return this.methodParameter.getMethodAnnotations();
            }
            return this.methodParameter.getParameterAnnotations();
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    protected TypeDescriptor newNestedTypeDescriptor(Class<?> nestedType, MethodParameter nested) {
        return new TypeDescriptor(nestedType, nested);
    }

    protected static Class<?> resolveNestedType(MethodParameter methodParameter) {
        if (Collection.class.isAssignableFrom(methodParameter.getParameterType())) {
            return GenericCollectionTypeResolver.getCollectionParameterType(methodParameter);
        }
        if (Map.class.isAssignableFrom(methodParameter.getParameterType())) {
            return GenericCollectionTypeResolver.getMapValueParameterType(methodParameter);
        }
        if (methodParameter.getParameterType().isArray()) {
            return methodParameter.getParameterType().getComponentType();
        }
        throw new IllegalStateException("Not a collection, map, or array method parameter type " + methodParameter.getParameterType());
    }

    private TypeDescriptor resolveElementTypeDescriptor() {
        if (this.isCollection()) {
            return this.createNestedTypeDescriptor(this.resolveCollectionElementType());
        }
        return this.createNestedTypeDescriptor(this.getType().getComponentType());
    }

    private TypeDescriptor resolveMapKeyTypeDescriptor() {
        return this.createNestedTypeDescriptor(this.resolveMapKeyType());
    }

    private TypeDescriptor resolveMapValueTypeDescriptor() {
        return this.createNestedTypeDescriptor(this.resolveMapValueType());
    }

    private TypeDescriptor createNestedTypeDescriptor(Class<?> nestedType) {
        nestedType = this.handleUnknownNestedType(nestedType);
        if (this.methodParameter != null) {
            return this.newNestedTypeDescriptor(nestedType, this.createNestedMethodParameter(this.methodParameter));
        }
        if (this.field != null) {
            return new TypeDescriptor(nestedType, this.field, this.fieldNestingLevel + 1);
        }
        return TypeDescriptor.valueOf(nestedType);
    }

    private Class<?> resolveCollectionElementType() {
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
        }
        if (this.field != null) {
            return GenericCollectionTypeResolver.getCollectionFieldType(this.field, this.fieldNestingLevel);
        }
        return GenericCollectionTypeResolver.getCollectionType(this.type);
    }

    private Class<?> resolveMapKeyType() {
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
        }
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapKeyFieldType(this.field, this.fieldNestingLevel);
        }
        return GenericCollectionTypeResolver.getMapKeyType(this.type);
    }

    private Class<?> resolveMapValueType() {
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
        }
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapValueFieldType(this.field, this.fieldNestingLevel);
        }
        return GenericCollectionTypeResolver.getMapValueType(this.type);
    }

    private Class<?> handleUnknownNestedType(Class<?> nestedType) {
        return nestedType != null ? nestedType : Object.class;
    }

    private MethodParameter createNestedMethodParameter(MethodParameter parentMethodParameter) {
        MethodParameter methodParameter = new MethodParameter(parentMethodParameter);
        methodParameter.increaseNestingLevel();
        return methodParameter;
    }

    private TypeDescriptor() {
    }

    private TypeDescriptor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        this.type = type;
    }

    private TypeDescriptor(Class<?> collectionType, Class<?> elementType) {
        this.type = collectionType;
        if (elementType == null) {
            elementType = Object.class;
        }
        this.elementType = TypeDescriptor.valueOf(elementType);
    }

    private TypeDescriptor(Class<?> mapType, Class<?> keyType, Class<?> valueType) {
        this.type = mapType;
        if (keyType == null) {
            keyType = Object.class;
        }
        if (valueType == null) {
            valueType = Object.class;
        }
        this.mapKeyType = TypeDescriptor.valueOf(keyType);
        this.mapValueType = TypeDescriptor.valueOf(valueType);
    }

    private TypeDescriptor(Class<?> nestedType, Field field, int nestingLevel) {
        this.type = nestedType;
        this.field = field;
        this.fieldNestingLevel = nestingLevel;
    }
}

