/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListTableBrowser;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DicomDirectoryBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDirectoryBrowser.java,v 1.19 2007/12/19 22:44:14 dclunie Exp $";
    private JTree tree;
    private DicomDirectory treeModel;
    private String parentFilePath;
    private HashSet defaultExcludeList;
    private HashSet patientExcludeList;
    private HashSet studyExcludeList;
    private HashSet seriesExcludeList;
    private HashSet imageExcludeList;
    private HashSet srExcludeList;

    public DicomDirectoryBrowser(AttributeList attributeList, String string) throws DicomException {
        this.parentFilePath = string;
        this.treeModel = new DicomDirectory(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles(string));
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    public DicomDirectoryBrowser(AttributeList attributeList, String string, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
        this.parentFilePath = string;
        this.treeModel = new DicomDirectory(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles(string));
        this.createExcludeLists();
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    public DicomDirectoryBrowser(AttributeList attributeList, String string, JFrame jFrame) throws DicomException {
        Object object;
        Attribute attribute = attributeList.get(TagFromName.FileSetID);
        if (attribute != null && (object = attribute.getStringValues()) != null && ((String[])object).length > 0) {
            jFrame.setTitle(object[0]);
        }
        this.parentFilePath = string;
        this.treeModel = new DicomDirectory(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        object = jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(0, 76));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jScrollPane2, "South");
        ((Container)object).add(jPanel);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles(string));
        this.createExcludeLists();
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    protected void setFont(Font font) {
        this.tree.setFont(font);
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedFiles(final String string) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Vector vector;
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DicomDirectoryRecord && (vector = DicomDirectory.findAllContainedReferencedFileNames((DicomDirectoryRecord)object, string)) != null) {
                    DicomDirectoryBrowser.this.doSomethingWithSelectedFiles(vector);
                }
            }
        };
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(final JScrollPane jScrollPane) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DicomDirectoryRecord) {
                    DicomDirectoryRecord dicomDirectoryRecord = (DicomDirectoryRecord)object;
                    HashSet hashSet = null;
                    HashSet hashSet2 = DicomDirectoryBrowser.this.chooseExcludeList(dicomDirectoryRecord);
                    AttributeListTableBrowser attributeListTableBrowser = new AttributeListTableBrowser(dicomDirectoryRecord.getAttributeList(), hashSet, hashSet2);
                    attributeListTableBrowser.setAutoResizeMode(0);
                    attributeListTableBrowser.setColumnWidths();
                    jScrollPane.setViewportView(attributeListTableBrowser);
                }
            }
        };
    }

    protected MouseListener buildMouseListenerToDetectDoubleClickEvents() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent != null && mouseEvent.getClickCount() == 2) {
                    DicomDirectoryBrowser.this.doSomethingMoreWithWhateverWasSelected();
                }
            }
        };
    }

    protected HashSet chooseExcludeList(DicomDirectoryRecord dicomDirectoryRecord) {
        HashSet hashSet = null;
        AttributeList attributeList = dicomDirectoryRecord.getAttributeList();
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.DirectoryRecordType);
        if (string == null) {
            hashSet = this.defaultExcludeList;
        } else if (string.equals("PATIENT")) {
            hashSet = this.patientExcludeList;
        } else if (string.equals("STUDY")) {
            hashSet = this.studyExcludeList;
        } else if (string.equals("SERIES")) {
            hashSet = this.seriesExcludeList;
        } else if (string.equals("IMAGE")) {
            hashSet = this.imageExcludeList;
        } else if (string.equals("SR DOCUMENT")) {
            hashSet = this.srExcludeList;
        }
        return hashSet;
    }

    protected void createExcludeLists() {
        this.defaultExcludeList = new HashSet();
        this.defaultExcludeList.add(TagFromName.NextDirectoryRecordOffset);
        this.defaultExcludeList.add(TagFromName.RecordInUseFlag);
        this.defaultExcludeList.add(TagFromName.LowerLevelDirectoryOffset);
        this.defaultExcludeList.add(TagFromName.DirectoryRecordType);
        this.patientExcludeList = new HashSet(this.defaultExcludeList);
        this.studyExcludeList = new HashSet(this.defaultExcludeList);
        this.seriesExcludeList = new HashSet(this.defaultExcludeList);
        this.imageExcludeList = new HashSet(this.defaultExcludeList);
        this.srExcludeList = new HashSet(this.defaultExcludeList);
    }

    public DicomDirectory getDicomDirectory() {
        this.treeModel.getMapOfSOPInstanceUIDToReferencedFileName(this.parentFilePath);
        return this.treeModel;
    }

    public String getParentFilePath() {
        return this.parentFilePath;
    }

    protected void doSomethingWithSelectedFiles(Vector vector) {
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                System.err.println((String)iterator.next());
            }
        }
    }

    protected void doSomethingMoreWithWhateverWasSelected() {
        System.err.println("DicomDirectoryBrowser.doSomethingMoreWithWhateverWasSelected(): Double click on current selection");
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        try {
            String string = stringArray[0];
            String string2 = new File(string).getParent();
            System.err.println("test reading DICOMDIR");
            attributeList.read(string);
            final JFrame jFrame = new JFrame();
            jFrame.setSize(400, 800);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            System.err.println("building tree");
            DicomDirectoryBrowser dicomDirectoryBrowser = new DicomDirectoryBrowser(attributeList, string2, jFrame);
            System.err.println("display tree");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

