/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherByteAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttribute.java,v 1.14 2008/02/21 04:45:04 dclunie Exp $";
    private byte[] values;

    public OtherByteAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherByteAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public OtherByteAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.values = null;
        this.valueLength = l;
        if (l > 0L) {
            byte[] byArray = new byte[(int)l];
            try {
                dicomInputStream.readInsistently(byArray, 0, (int)l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
            this.setValues(byArray);
        }
    }

    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            dicomOutputStream.write(this.values);
            if (this.getVL() != (long)this.values.length) {
                throw new DicomException("Internal error - byte array length (" + this.values.length + ") not equal to expected VL(" + this.getVL() + ")");
            }
            long l = this.getPaddedVL() - (long)this.values.length;
            while (l-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public void setValues(byte[] byArray) throws DicomException {
        this.values = byArray;
        this.valueMultiplicity = 1;
        this.valueLength = byArray.length;
    }

    public byte[] getByteValues() throws DicomException {
        return this.values;
    }

    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

