/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;

public abstract class StringAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/StringAttribute.java,v 1.20 2007/04/01 15:53:53 dclunie Exp $";
    protected SpecificCharacterSet specificCharacterSet;
    byte[] originalByteValues;
    String[] originalValues;
    String[] cachedUnpaddedStringCopy;
    int[] cachedIntegerCopy;
    long[] cachedLongCopy;
    float[] cachedFloatCopy;
    double[] cachedDoubleCopy;
    byte[] cachedPaddedByteValues;

    public SpecificCharacterSet getSpecificCharacterSet() {
        return this.specificCharacterSet;
    }

    private void flushCachedCopies() {
        this.cachedUnpaddedStringCopy = null;
        this.cachedIntegerCopy = null;
        this.cachedLongCopy = null;
        this.cachedFloatCopy = null;
        this.cachedDoubleCopy = null;
        this.cachedPaddedByteValues = null;
    }

    protected String translateByteArrayToString(byte[] byArray, int n, int n2) {
        return this.specificCharacterSet == null ? new String(byArray, 0, n2) : this.specificCharacterSet.translateByteArrayToString(byArray, 0, n2);
    }

    protected byte[] translateStringToByteArray(String string) throws UnsupportedEncodingException {
        byte[] byArray = this.specificCharacterSet == null ? string.getBytes() : this.specificCharacterSet.translateStringToByteArray(string);
        return byArray;
    }

    protected StringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.doCommonConstructorStuff(null);
    }

    protected StringAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) {
        super(attributeTag);
        this.doCommonConstructorStuff(specificCharacterSet);
    }

    protected StringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, null);
    }

    protected StringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, null);
    }

    protected StringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    protected StringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, specificCharacterSet);
    }

    private void doCommonConstructorStuff(SpecificCharacterSet specificCharacterSet) {
        this.flushCachedCopies();
        this.specificCharacterSet = specificCharacterSet;
        this.originalValues = null;
        this.originalByteValues = null;
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        this.doCommonConstructorStuff(specificCharacterSet);
        this.originalValues = null;
        this.originalByteValues = null;
        if (l > 0L) {
            this.originalByteValues = new byte[(int)l];
            try {
                dicomInputStream.readInsistently(this.originalByteValues, 0, (int)l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
            String string = this.translateByteArrayToString(this.originalByteValues, 0, (int)l);
            if (string != null) {
                l = string.length();
                int n = 0;
                int n2 = 0;
                while (true) {
                    if ((long)n2 >= l || string.charAt(n2) == '\\') {
                        this.addValue(string.substring(n, n2));
                        n = ++n2;
                        if ((long)n2 < l) continue;
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    public long getPaddedVL() {
        byte[] byArray = null;
        try {
            byArray = this.getPaddedByteValues();
        }
        catch (DicomException dicomException) {
            byArray = null;
        }
        return byArray == null ? 0L : (long)byArray.length;
    }

    protected byte getPadByte() {
        return 32;
    }

    private byte[] getPaddedByteValues() throws DicomException {
        if (this.cachedPaddedByteValues == null) {
            this.cachedPaddedByteValues = this.extractPaddedByteValues();
        }
        return this.cachedPaddedByteValues;
    }

    private byte[] extractPaddedByteValues() throws DicomException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getOriginalStringValues();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("\\");
                }
                stringBuffer.append(stringArray[i]);
            }
        }
        byte[] byArray = null;
        try {
            byArray = this.translateStringToByteArray(stringBuffer.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DicomException("Unsupported encoding:" + unsupportedEncodingException);
        }
        if (byArray != null && (n = byArray.length) % 2 != 0) {
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray2[n] = this.getPadByte();
            byArray = byArray2;
        }
        return byArray;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        byte[] byArray = this.getPaddedByteValues();
        if (byArray != null && byArray.length > 0) {
            dicomOutputStream.write(byArray);
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" <");
        try {
            String[] stringArray = this.getOriginalStringValues();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append(stringArray[i]);
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public byte[] getByteValues() throws DicomException {
        return this.originalByteValues == null ? this.getPaddedByteValues() : this.originalByteValues;
    }

    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        if (this.cachedUnpaddedStringCopy == null) {
            this.cachedUnpaddedStringCopy = ArrayCopyUtilities.copyStringArrayRemovingLeadingAndTrailingPadding(this.originalValues);
        }
        return this.cachedUnpaddedStringCopy;
    }

    public String[] getOriginalStringValues() throws DicomException {
        return this.originalValues;
    }

    public int[] getIntegerValues() throws DicomException {
        if (this.cachedIntegerCopy == null) {
            this.cachedIntegerCopy = ArrayCopyUtilities.copyStringToIntArray(this.getStringValues());
        }
        return this.cachedIntegerCopy;
    }

    public long[] getLongValues() throws DicomException {
        if (this.cachedLongCopy == null) {
            this.cachedLongCopy = ArrayCopyUtilities.copyStringToLongArray(this.getStringValues());
        }
        return this.cachedLongCopy;
    }

    public float[] getFloatValues() throws DicomException {
        if (this.cachedFloatCopy == null) {
            this.cachedFloatCopy = ArrayCopyUtilities.copyStringToFloatArray(this.getStringValues());
        }
        return this.cachedFloatCopy;
    }

    public double[] getDoubleValues() throws DicomException {
        if (this.cachedDoubleCopy == null) {
            this.cachedDoubleCopy = ArrayCopyUtilities.copyStringToDoubleArray(this.getStringValues());
        }
        return this.cachedDoubleCopy;
    }

    public void addValue(String string) throws DicomException {
        this.flushCachedCopies();
        this.originalValues = ArrayCopyUtilities.expandArray(this.originalValues);
        this.valueLength += (long)string.length();
        if (this.valueMultiplicity > 0) {
            ++this.valueLength;
        }
        this.originalValues[this.valueMultiplicity++] = string;
    }

    public void addValue(byte by) throws DicomException {
        this.addValue(Short.toString((short)(by & 0xFF)));
    }

    public void addValue(short s) throws DicomException {
        this.addValue(Short.toString(s));
    }

    public void addValue(int n) throws DicomException {
        this.addValue(Integer.toString(n));
    }

    public void addValue(long l) throws DicomException {
        this.addValue(Long.toString(l));
    }

    public void addValue(float f) throws DicomException {
        this.addValue(Float.toString(f));
    }

    public void addValue(double d) throws DicomException {
        this.addValue(Double.toString(d));
    }

    public void removeValues() throws DicomException {
        this.valueLength = 0L;
        this.valueMultiplicity = 0;
        this.originalValues = null;
        this.flushCachedCopies();
    }
}

