/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.LossyImageCompression;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.geometry.GeometryOfVolume;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class DemographicAndTechniqueAnnotations {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DemographicAndTechniqueAnnotations.java,v 1.15 2008/01/13 00:41:37 dclunie Exp $";
    protected static final int NOSPECIAL = 0;
    protected static final int JUSTTIME = 1;
    protected static final int SLICESPACING = 2;
    protected static final int FRAMENUMBER = 3;
    protected static final int IMAGETYPE = 5;
    protected static final int PIXELREPN = 6;
    protected static final int CODEMEANING = 7;
    protected static final int ORIENTLABEL = 8;
    protected static final int ABBREVPHOTO = 9;
    protected static final int LOSSYCOMPRESSED = 10;
    protected static final int TEXTIFYESNO = 11;
    protected static final int CALLFUNCTION = 12;
    protected static final int DIRECTIONVECTOR = 13;
    protected Vector layout;
    private int layoutTopLeftRows;
    private int layoutBottomLeftRows;
    private int layoutTopRightRows;
    private int layoutBottomRightRows;
    private boolean swapLeftRight;
    private Vector[] annotations;
    protected static final String multipleCodeMeaningDelimiter = " ";

    protected void initializeDefaultLayout() {
        this.layout = new Vector();
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.InstitutionName, null, null, null, true, true, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Manufacturer, null, null, null, true, true, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ManufacturerModelName, null, null, null, true, true, 1, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "[", true, true, 2, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientID, null, null, null, true, true, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "] ", true, true, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientName, null, null, null, true, true, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientSex, null, null, null, true, true, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientBirthDate, null, null, null, true, true, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " [", true, true, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PatientAge, null, null, null, true, true, 3, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "]", true, true, 3, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.FrameLaterality, TagFromName.FrameAnatomySequence, null, null, true, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("NOTENH", TagFromName.Laterality, null, null, null, true, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("NOTENH", TagFromName.ImageLaterality, null, null, null, true, true, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.BodyPartExamined, null, null, null, true, true, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AnatomicRegionSequence, TagFromName.FrameAnatomySequence, null, null, true, true, 4, 5, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewPosition, null, null, null, true, true, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewCodeSequence, null, null, null, true, true, 4, 9, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, true, true, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ViewModifierCodeSequence, null, TagFromName.ViewCodeSequence, null, true, true, 4, 11, null, 7));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyDescription, null, null, null, false, true, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.SeriesDescription, null, null, null, false, true, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyID, null, null, null, false, true, 2, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " [", false, true, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AccessionNumber, null, null, null, false, true, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "]", false, true, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.StudyDate, null, null, null, false, true, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "Series #", false, true, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.SeriesNumber, null, null, null, false, true, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.FrameComments, TagFromName.FrameContentSequence, null, null, false, false, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 0, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.FrameType, TagFromName.MRImageFrameTypeSequence, null, null, false, false, 0, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.FrameType, TagFromName.CTImageFrameTypeSequence, null, null, false, false, 0, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ImageComments, null, null, null, false, false, 1, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ImageType, null, null, null, false, false, 1, 2, null, 5));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.FrameAcquisitionDateTime, TagFromName.FrameContentSequence, null, null, false, false, 2, 0, null, 1));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AcquisitionDateTime, null, null, null, false, false, 2, 2, null, 1));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.AcquisitionTime, null, null, null, false, false, 2, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 2, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.ContentTime, null, null, null, false, false, 2, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, " [", false, false, 2, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.TemporalPositionIndex, TagFromName.FrameContentSequence, null, null, false, false, 2, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "]", false, false, 2, 9, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "F #", false, false, 3, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, null, false, false, 3, 1, null, 3));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, " I #", false, false, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.InstanceNumber, null, null, null, false, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Columns, null, null, null, false, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "x", false, false, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.Rows, null, null, null, false, false, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, "x", false, false, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.NumberOfFrames, null, null, null, false, false, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PixelRepresentation, null, null, null, false, false, 4, 6, null, 6));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.BitsStored, null, null, null, false, false, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.PhotometricInterpretation, null, null, multipleCodeMeaningDelimiter, false, false, 4, 9, null, 9));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, multipleCodeMeaningDelimiter, false, false, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, null, null, null, null, false, false, 4, 11, null, 10));
        this.layout.add(new AnnotationLayoutConfigurationEntry(null, TagFromName.DerivationDescription, null, null, null, false, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "[", true, false, 0, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.StackID, TagFromName.FrameContentSequence, null, null, true, false, 0, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, ":", true, false, 0, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.InStackPositionNumber, TagFromName.FrameContentSequence, null, null, true, false, 0, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", null, null, null, "] ", true, false, 0, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImagePositionPatient, TagFromName.PlanePositionSequence, null, null, true, false, 0, 5, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", null, null, null, " [", true, false, 0, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.TablePosition, TagFromName.CTPositionSequence, null, null, true, false, 0, 7, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", null, null, null, "]", true, false, 0, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", null, null, null, " [", true, false, 0, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", TagFromName.SliceLocation, null, null, null, true, false, 0, 7, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCOLD", null, null, null, "]", true, false, 0, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, " mm", true, false, 0, 9, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImageOrientationPatient, TagFromName.PlaneOrientationSequence, null, null, true, false, 1, 0, "#.##", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 1, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.ImageOrientationPatient, TagFromName.PlaneOrientationSequence, null, null, true, false, 1, 2, null, 8));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.PixelSpacing, TagFromName.PixelMeasuresSequence, null, null, true, false, 2, 0, "#.###", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, "\\", true, false, 2, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, null, true, false, 2, 3, "#.###", 2));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 2, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", TagFromName.SliceThickness, TagFromName.PixelMeasuresSequence, null, null, true, false, 2, 5, "##.##", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 2, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.ReconstructionDiameter, TagFromName.CTReconstructionSequence, null, null, true, false, 2, 7, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.ReconstructionFieldOfView, TagFromName.CTReconstructionSequence, null, null, true, false, 2, 7, "###.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCIMAGE", null, null, null, " mm", true, false, 2, 8, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.FlipAngle, TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 0, "#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, "\u00b0 ETL ", true, false, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.GradientEchoTrainLength, TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", null, null, null, "+", true, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.RFEchoTrainLength, TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", null, null, null, "=", true, false, 3, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.EchoTrainLength, TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 3, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " Avg ", true, false, 3, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.NumberOfAverages, TagFromName.MRAveragesSequence, null, null, true, false, 3, 8, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.KVP, TagFromName.CTXRayDetailsSequence, null, null, true, false, 3, 0, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " kVP ", true, false, 3, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2.1", TagFromName.ExposureInmAs, TagFromName.CTExposureSequence, null, null, true, false, 3, 2, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.2", TagFromName.Exposure, null, null, null, true, false, 3, 2, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " mAs", true, false, 3, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, "TE ", true, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.EffectiveEchoTime, TagFromName.MREchoSequence, null, null, true, false, 4, 1, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4", TagFromName.EchoTime, null, null, null, true, false, 4, 1, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " TR ", true, false, 4, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.RepetitionTime, TagFromName.MRTimingAndRelatedParametersSequence, null, null, true, false, 4, 3, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " TI ", true, false, 4, 4, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.InversionTimes, TagFromName.MRModifierSequence, null, null, true, false, 4, 5, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4", TagFromName.InversionTime, null, null, null, true, false, 4, 5, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " mS", true, false, 4, 6, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, " B ", true, false, 4, 7, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.DiffusionBValue, TagFromName.MRDiffusionSequence, null, null, true, false, 4, 8, "#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 4, 10, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("MRIMAGE", TagFromName.DiffusionGradientOrientation, TagFromName.MRDiffusionSequence, TagFromName.DiffusionGradientDirectionSequence, null, true, false, 4, 11, null, 13));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.AcquisitionType, TagFromName.CTAcquisitionTypeSequence, null, null, true, false, 4, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 4, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.SpiralPitchFactor, TagFromName.CTTableDynamicsSequence, null, null, true, false, 4, 2, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, ":1 ", true, false, 4, 3, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.TableSpeed, TagFromName.CTTableDynamicsSequence, null, null, true, false, 4, 4, "#.#", 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, " mm/s", true, false, 4, 5, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("1.2.840.10008.5.1.4.1.1.4.1", TagFromName.AcquisitionContrast, TagFromName.MRImageFrameTypeSequence, null, null, true, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.ConvolutionKernel, TagFromName.CTReconstructionSequence, null, null, true, false, 5, 0, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", null, null, null, multipleCodeMeaningDelimiter, true, false, 5, 1, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("CTIMAGE", TagFromName.ConvolutionKernelGroup, TagFromName.CTReconstructionSequence, null, null, true, false, 5, 2, null, 0));
        this.layout.add(new AnnotationLayoutConfigurationEntry("XCENH", TagFromName.ContrastBolusAgentPhase, TagFromName.ContrastBolusUsageSequence, null, null, true, false, 6, 0, null, 0));
    }

    private static final int getArrayIndexFromLeftTop(boolean bl, boolean bl2) {
        return bl ? (bl2 ? 0 : 1) : (bl2 ? 2 : 3);
    }

    private static final boolean isLeftFromArrayIndex(int n) {
        return n == 0 || n == 1;
    }

    private static final boolean isTopFromArrayIndex(int n) {
        return n == 0 || n == 2;
    }

    private static final String getFormattedValue(Attribute attribute, int n, NumberFormat numberFormat) {
        String string = null;
        if (attribute != null) {
            if (n == 7 && attribute instanceof SequenceAttribute) {
                Iterator iterator = ((SequenceAttribute)attribute).iterator();
                while (iterator.hasNext()) {
                    String string2;
                    SequenceItem sequenceItem = (SequenceItem)iterator.next();
                    AttributeList attributeList = sequenceItem.getAttributeList();
                    if (attributeList == null || (string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.CodeMeaning)) == null || string2.length() <= 0) continue;
                    string = string == null || string.length() == 0 ? string2 : string + multipleCodeMeaningDelimiter + string2;
                }
            } else if (n == 8 && attribute.getVM() == 6) {
                try {
                    double[] dArray = attribute.getDoubleValues();
                    string = DescriptionFactory.makeImageOrientationLabelFromImageOrientationPatient(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (n == 13) {
                try {
                    double[] dArray = attribute.getDoubleValues();
                    string = GeometryOfSlice.getOrientation(dArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (n == 1 && attribute instanceof DateTimeAttribute) {
                try {
                    String[] stringArray = attribute.getOriginalStringValues();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringArray != null) {
                        int n2 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string3 = null;
                            if (stringArray[i] != null && stringArray[i].length() > 8) {
                                string3 = stringArray[i].substring(8);
                            }
                            if (n2 != 0) {
                                stringBuffer.append((char)n2);
                            }
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            n2 = 92;
                        }
                        string = stringBuffer.toString();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (n == 5) {
                try {
                    String[] stringArray = attribute.getStringValues();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringArray != null) {
                        int n3 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string4 = stringArray[i];
                            if (string4 == null || i == 0 && string4.equals("ORIGINAL") || i == 1 && string4.equals("PRIMARY") || i == 3 && string4.equals("NONE")) continue;
                            if (n3 != 0) {
                                stringBuffer.append((char)n3);
                            }
                            stringBuffer.append(string4);
                            n3 = 92;
                        }
                        string = stringBuffer.toString();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            } else if (n == 9 && attribute.getTag().equals(TagFromName.PhotometricInterpretation)) {
                string = attribute.getSingleStringValueOrNull();
                if (string != null) {
                    if (string.equals("MONOCHROME2")) {
                        string = "M2";
                    } else if (string.equals("MONOCHROME1")) {
                        string = "M1";
                    } else if (string.equals("PALETTE COLOR")) {
                        string = "PAL";
                    }
                }
            } else {
                string = n == 6 && attribute.getTag().equals(TagFromName.PixelRepresentation) ? (attribute.getSingleIntegerValueOrDefault(0) == 0 ? "+" : "-") : attribute.getDelimitedStringValuesOrNull(numberFormat);
            }
        }
        return string;
    }

    public DemographicAndTechniqueAnnotations(AttributeList attributeList, GeometryOfVolume geometryOfVolume) {
        this(attributeList, geometryOfVolume, false);
    }

    public DemographicAndTechniqueAnnotations(AttributeList attributeList, GeometryOfVolume geometryOfVolume, boolean bl) {
        this.swapLeftRight = bl;
        if (attributeList != null) {
            String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
            if (string != null && n > 0) {
                this.initializeDefaultLayout();
                this.annotations = new Vector[n];
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
                SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object22;
                    TreeSet[] treeSetArray = new TreeSet[4];
                    for (int j = 0; j < 4; ++j) {
                        treeSetArray[j] = new TreeSet();
                    }
                    for (Object object22 : this.layout) {
                        Object object3;
                        Object object4;
                        if (((AnnotationLayoutConfigurationEntry)object22).sopClassUID != null && !((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals(string) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("MRIMAGE") || !string.equals("1.2.840.10008.5.1.4.1.1.4.1") && !string.equals("1.2.840.10008.5.1.4.1.1.4")) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("CTIMAGE") || !string.equals("1.2.840.10008.5.1.4.1.1.2.1") && !string.equals("1.2.840.10008.5.1.4.1.1.2")) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("XCIMAGE") || !string.equals("1.2.840.10008.5.1.4.1.1.4.1") && !string.equals("1.2.840.10008.5.1.4.1.1.4") && !string.equals("1.2.840.10008.5.1.4.1.1.2.1") && !string.equals("1.2.840.10008.5.1.4.1.1.2")) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("XCENH") || !string.equals("1.2.840.10008.5.1.4.1.1.4.1") && !string.equals("1.2.840.10008.5.1.4.1.1.2.1")) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("NOTENH") || string.equals("1.2.840.10008.5.1.4.1.1.4.1") || string.equals("1.2.840.10008.5.1.4.1.1.2.1")) && (!((AnnotationLayoutConfigurationEntry)object22).sopClassUID.equals("XCOLD") || !string.equals("1.2.840.10008.5.1.4.1.1.4") && !string.equals("1.2.840.10008.5.1.4.1.1.2"))) continue;
                        DecimalFormat decimalFormat = null;
                        if (((AnnotationLayoutConfigurationEntry)object22).decimalFormatPattern != null) {
                            try {
                                decimalFormat = new DecimalFormat(((AnnotationLayoutConfigurationEntry)object22).decimalFormatPattern);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(System.err);
                                decimalFormat = null;
                            }
                        }
                        String string2 = null;
                        if (((AnnotationLayoutConfigurationEntry)object22).specialFunction == 2) {
                            if (geometryOfVolume != null && geometryOfVolume.isVolumeSampledRegularlyAlongFrameDimension() && (object4 = geometryOfVolume.getGeometryOfSlices()) != null && ((GeometryOfSlice[])object4).length > 0 && (object3 = object4[0].getVoxelSpacingArray()) != null && ((double[])object3).length == 3) {
                                if (decimalFormat == null) {
                                    decimalFormat = new DecimalFormat("###.#");
                                }
                                string2 = decimalFormat.format(object3[2]);
                            }
                        } else if (((AnnotationLayoutConfigurationEntry)object22).specialFunction == 3) {
                            string2 = Integer.toString(i + 1);
                        } else if (((AnnotationLayoutConfigurationEntry)object22).specialFunction == 10) {
                            string2 = LossyImageCompression.describeLossyCompression(attributeList);
                        } else if (((AnnotationLayoutConfigurationEntry)object22).specialFunction == 12) {
                            string2 = this.getValueByCallingFunction(attributeList);
                        } else if (((AnnotationLayoutConfigurationEntry)object22).tag == null) {
                            string2 = ((AnnotationLayoutConfigurationEntry)object22).text;
                        } else {
                            Object object5;
                            Object object6;
                            object4 = null;
                            object3 = ((AnnotationLayoutConfigurationEntry)object22).nestedAttribute == null ? ((AnnotationLayoutConfigurationEntry)object22).tag : ((AnnotationLayoutConfigurationEntry)object22).nestedAttribute;
                            if (((AnnotationLayoutConfigurationEntry)object22).functionalGroup != null && sequenceAttribute != null && sequenceAttribute2 != null) {
                                object = null;
                                object6 = sequenceAttribute.getItem(0);
                                if (object6 != null && (object5 = ((SequenceItem)object6).getAttributeList()) != null) {
                                    object = (SequenceAttribute)((AttributeList)object5).get(((AnnotationLayoutConfigurationEntry)object22).functionalGroup);
                                }
                                if (object == null && (object6 = sequenceAttribute2.getItem(i)) != null && (object5 = ((SequenceItem)object6).getAttributeList()) != null) {
                                    object = (SequenceAttribute)((AttributeList)object5).get(((AnnotationLayoutConfigurationEntry)object22).functionalGroup);
                                }
                                if (object != null) {
                                    object4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem((SequenceAttribute)object, (AttributeTag)object3);
                                }
                            }
                            if (object4 == null) {
                                object4 = attributeList.get((AttributeTag)object3);
                            }
                            if (object4 != null) {
                                if (((AnnotationLayoutConfigurationEntry)object22).nestedAttribute != null) {
                                    if (((AnnotationLayoutConfigurationEntry)object22).nestedAttribute.equals(((Attribute)object4).getTag()) && object4 instanceof SequenceAttribute) {
                                        object = (SequenceAttribute)object4;
                                        object6 = ((SequenceAttribute)object).iterator();
                                        while (object6.hasNext()) {
                                            String string3;
                                            object5 = (SequenceItem)object6.next();
                                            AttributeList attributeList2 = ((SequenceItem)object5).getAttributeList();
                                            if (attributeList2 == null || (object4 = attributeList2.get(((AnnotationLayoutConfigurationEntry)object22).tag)) == null || (string3 = DemographicAndTechniqueAnnotations.getFormattedValue((Attribute)object4, ((AnnotationLayoutConfigurationEntry)object22).specialFunction, decimalFormat)) == null || string3.length() <= 0) continue;
                                            string2 = string2 == null || string2.length() == 0 ? string3 : string2 + multipleCodeMeaningDelimiter + string3;
                                        }
                                        object4 = null;
                                    } else {
                                        object4 = null;
                                    }
                                }
                                if (object4 != null) {
                                    string2 = DemographicAndTechniqueAnnotations.getFormattedValue((Attribute)object4, ((AnnotationLayoutConfigurationEntry)object22).specialFunction, decimalFormat);
                                }
                            }
                        }
                        if (string2 == null || string2.length() <= 0) continue;
                        if (((AnnotationLayoutConfigurationEntry)object22).specialFunction == 11) {
                            string2 = string2.toUpperCase().indexOf("Y") == -1 ? "" : ((AnnotationLayoutConfigurationEntry)object22).text;
                        }
                        object4 = new AnnotationComponentEntry(string2, ((AnnotationLayoutConfigurationEntry)object22).textRow, ((AnnotationLayoutConfigurationEntry)object22).orderInRow);
                        treeSetArray[DemographicAndTechniqueAnnotations.getArrayIndexFromLeftTop(((AnnotationLayoutConfigurationEntry)object22).fromLeft, ((AnnotationLayoutConfigurationEntry)object22).fromTop)].add(object4);
                    }
                    this.annotations[i] = object22 = new Vector();
                    for (int j = 0; j < 4; ++j) {
                        boolean bl2 = DemographicAndTechniqueAnnotations.isLeftFromArrayIndex(j);
                        bl2 = bl2 && !bl || !bl2 && bl;
                        boolean bl3 = DemographicAndTechniqueAnnotations.isTopFromArrayIndex(j);
                        int n2 = -1;
                        object = null;
                        for (Object object5 : treeSetArray[j]) {
                            if (((AnnotationComponentEntry)object5).textRow != n2) {
                                if (object != null) {
                                    ((Vector)object22).add(new TextAnnotationPositioned(((StringBuffer)object).toString(), bl2, bl3, n2));
                                }
                                object = new StringBuffer();
                            }
                            ((StringBuffer)object).append(((AnnotationComponentEntry)object5).string);
                            n2 = ((AnnotationComponentEntry)object5).textRow;
                        }
                        if (object == null) continue;
                        ((Vector)object22).add(new TextAnnotationPositioned(((StringBuffer)object).toString(), bl2, bl3, n2));
                    }
                }
            }
        }
    }

    protected String getValueByCallingFunction(AttributeList attributeList) {
        return "";
    }

    public Iterator iterator(int n) {
        return this.annotations[n].iterator();
    }

    private class AnnotationComponentEntry
    implements Comparable {
        String string;
        int textRow;
        int orderInRow;

        AnnotationComponentEntry(String string, int n, int n2) {
            this.string = string;
            this.textRow = n;
            this.orderInRow = n2;
        }

        public int compareTo(Object object) {
            AnnotationComponentEntry annotationComponentEntry = (AnnotationComponentEntry)object;
            if (this.textRow == annotationComponentEntry.textRow) {
                return this.orderInRow - annotationComponentEntry.orderInRow;
            }
            return this.textRow - annotationComponentEntry.textRow;
        }
    }

    protected class AnnotationLayoutConfigurationEntry {
        String sopClassUID;
        AttributeTag tag;
        AttributeTag functionalGroup;
        AttributeTag nestedAttribute;
        String text;
        boolean fromLeft;
        boolean fromTop;
        int textRow;
        int orderInRow;
        String decimalFormatPattern;
        int specialFunction;

        AnnotationLayoutConfigurationEntry(String string, AttributeTag attributeTag, AttributeTag attributeTag2, AttributeTag attributeTag3, String string2, boolean bl, boolean bl2, int n, int n2, String string3, int n3) {
            this.sopClassUID = string;
            this.tag = attributeTag;
            this.functionalGroup = attributeTag2;
            this.nestedAttribute = attributeTag3;
            this.text = string2;
            this.fromLeft = bl;
            this.fromTop = bl2;
            this.textRow = n;
            this.orderInRow = n2;
            this.decimalFormatPattern = string3;
            this.specialFunction = n3;
        }
    }
}

