/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.utils.ByteArray;

class AssociateRejectPDU {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociateRejectPDU.java,v 1.9 2003/10/09 21:38:36 dclunie Exp $";
    private byte[] b;
    private int pduType;
    private int pduLength;
    private int result;
    private int source;
    private int reason;

    public AssociateRejectPDU(int n, int n2, int n3) throws DicomNetworkException {
        this.pduType = 3;
        this.pduLength = 4;
        this.result = n;
        this.source = n2;
        this.reason = n3;
        this.b = new byte[10];
        this.b[0] = (byte)this.pduType;
        this.b[1] = 0;
        this.b[2] = 0;
        this.b[3] = 0;
        this.b[4] = 0;
        this.b[5] = 4;
        this.b[6] = 0;
        this.b[7] = (byte)n;
        this.b[8] = (byte)n2;
        this.b[9] = (byte)n3;
    }

    public AssociateRejectPDU(byte[] byArray) throws DicomNetworkException {
        this.b = byArray;
        this.pduType = this.b[0] & 0xFF;
        this.pduLength = ByteArray.bigEndianToUnsignedInt(this.b, 2, 4);
        this.result = this.b[7] & 0xFF;
        this.source = this.b[8] & 0xFF;
        this.reason = this.b[9] & 0xFF;
    }

    public byte[] getBytes() {
        return this.b;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.result == 1) {
            stringBuffer.append("rejected-permanent");
        } else if (this.result == 2) {
            stringBuffer.append("rejected-transient");
        }
        if (this.source == 1) {
            stringBuffer.append(" by DICOM UL Service User");
        } else if (this.source == 2) {
            stringBuffer.append(" by DICOM UL Service Provider (ACSE related function)");
        } else if (this.source == 3) {
            stringBuffer.append(" by DICOM UL Service Provider (Presentation related function)");
        }
        if (this.source == 1) {
            if (this.reason == 1) {
                stringBuffer.append(", no reason given");
            } else if (this.reason == 2) {
                stringBuffer.append(", application context name not supported");
            } else if (this.reason == 3) {
                stringBuffer.append(", calling AE Title not recognized");
            } else if (this.reason == 7) {
                stringBuffer.append(", called AE Title not recognized");
            }
        } else if (this.source == 2) {
            if (this.reason == 1) {
                stringBuffer.append(", no reason given");
            } else if (this.reason == 2) {
                stringBuffer.append(", protocol version not supported");
            }
        } else if (this.source == 3) {
            if (this.reason == 1) {
                stringBuffer.append(", temporary congestion");
            } else if (this.reason == 2) {
                stringBuffer.append(", local limit exceeded");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PDU Type: 0x");
        stringBuffer.append(this.pduType);
        stringBuffer.append(this.pduType == 3 ? " (A-ASSOCIATE-RJ)" : " unrecognized");
        stringBuffer.append("\n");
        stringBuffer.append("Length: 0x");
        stringBuffer.append(Integer.toHexString(this.pduLength));
        stringBuffer.append("\n");
        stringBuffer.append("Result: 0x");
        stringBuffer.append(Integer.toHexString(this.result));
        if (this.result == 1) {
            stringBuffer.append(" (rejected-permanent)");
        } else if (this.result == 2) {
            stringBuffer.append(" (rejected-transient)");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Source: 0x");
        stringBuffer.append(Integer.toHexString(this.source));
        if (this.source == 1) {
            stringBuffer.append(" (DICOM UL Service User)");
        } else if (this.source == 2) {
            stringBuffer.append(" (DICOM UL Service Provider (ACSE related function))");
        } else if (this.source == 3) {
            stringBuffer.append(" (DICOM UL Service Provider (Presentation related function))");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Reason: 0x");
        stringBuffer.append(Integer.toHexString(this.reason));
        if (this.source == 1) {
            if (this.reason == 1) {
                stringBuffer.append(" (no reason given)");
            } else if (this.reason == 2) {
                stringBuffer.append(" (application context name not supported)");
            } else if (this.reason == 3) {
                stringBuffer.append(" (calling AE Title not recognized)");
            } else if (this.reason == 7) {
                stringBuffer.append(" (called AE Title not recognized)");
            }
        } else if (this.source == 2) {
            if (this.reason == 1) {
                stringBuffer.append(" (no reason given)");
            } else if (this.reason == 2) {
                stringBuffer.append(" (protocol version not supported)");
            }
        } else if (this.source == 3) {
            if (this.reason == 1) {
                stringBuffer.append(" (temporary congestion)");
            } else if (this.reason == 2) {
                stringBuffer.append(" (local limit exceeded)");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

