/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.ApplicationEntityAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.network.RequestCommandMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CStoreRequestCommandMessage
extends RequestCommandMessage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/CStoreRequestCommandMessage.java,v 1.10 2006/06/14 16:19:20 dclunie Exp $";
    private byte[] bytes;
    private static final AttributeTag groupLengthTag = new AttributeTag(0, 0);
    private int groupLength;
    private String affectedSOPClassUID;
    private int commandField;
    private int messageID;
    private int priority;
    private String affectedSOPInstanceUID;
    private String moveOriginatorApplicationEntityTitle;
    private int moveOriginatorMessageID;

    public CStoreRequestCommandMessage(AttributeList attributeList) throws DicomException, IOException {
        this.groupLength = Attribute.getSingleIntegerValueOrDefault(attributeList, groupLengthTag, 65535);
        this.affectedSOPClassUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AffectedSOPClassUID);
        this.commandField = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.CommandField, 65535);
        this.messageID = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.MessageID, 65535);
        this.priority = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Priority, 65535);
        this.affectedSOPInstanceUID = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.AffectedSOPInstanceUID);
        this.moveOriginatorApplicationEntityTitle = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MoveOriginatorApplicationEntityTitle);
        this.moveOriginatorMessageID = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.MoveOriginatorMessageID, -1);
    }

    public CStoreRequestCommandMessage(String string, String string2) throws DicomException, IOException {
        this(string, string2, null, -1);
    }

    public CStoreRequestCommandMessage(String string, String string2, String string3, int n) throws DicomException, IOException {
        this.affectedSOPClassUID = string;
        this.affectedSOPInstanceUID = string2;
        this.moveOriginatorApplicationEntityTitle = string3;
        this.moveOriginatorMessageID = n;
        this.commandField = 1;
        this.messageID = super.getNextAvailableMessageID();
        this.priority = 0;
        int n2 = 1;
        AttributeList attributeList = new AttributeList();
        Object object = groupLengthTag;
        Object object2 = new UnsignedLongAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(0);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.AffectedSOPClassUID;
        object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(string);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.CommandField;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.commandField);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.MessageID;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.messageID);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.Priority;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(this.priority);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.DataSetType;
        object2 = new UnsignedShortAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(n2);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        object = TagFromName.AffectedSOPInstanceUID;
        object2 = new UniqueIdentifierAttribute((AttributeTag)object);
        ((Attribute)object2).addValue(string2);
        attributeList.put((AttributeTag)object, (Attribute)object2);
        if (string3 != null && string3.length() > 0) {
            object = TagFromName.MoveOriginatorApplicationEntityTitle;
            object2 = new ApplicationEntityAttribute((AttributeTag)object);
            ((Attribute)object2).addValue(string3);
            attributeList.put((AttributeTag)object, (Attribute)object2);
        }
        if (n != -1) {
            object = TagFromName.MoveOriginatorMessageID;
            object2 = new UnsignedShortAttribute((AttributeTag)object);
            ((Attribute)object2).addValue(n);
            attributeList.put((AttributeTag)object, (Attribute)object2);
        }
        object = new ByteArrayOutputStream();
        object2 = new DicomOutputStream((OutputStream)object, null, "1.2.840.10008.1.2");
        attributeList.write((DicomOutputStream)object2);
        this.bytes = ((ByteArrayOutputStream)object).toByteArray();
        this.groupLength = this.bytes.length - 12;
        this.bytes[8] = (byte)this.groupLength;
        this.bytes[9] = (byte)(this.groupLength >> 8);
        this.bytes[10] = (byte)(this.groupLength >> 16);
        this.bytes[11] = (byte)(this.groupLength >> 24);
    }

    public int getGroupLength() {
        return this.groupLength;
    }

    public String getAffectedSOPClassUID() {
        return this.affectedSOPClassUID;
    }

    public int getCommandField() {
        return this.commandField;
    }

    public int getMessageID() {
        return this.messageID;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAffectedSOPInstanceUID() {
        return this.affectedSOPInstanceUID;
    }

    public String getmoveOriginatorApplicationEntityTitle() {
        return this.moveOriginatorApplicationEntityTitle;
    }

    public int getMoveOriginatorMessageID() {
        return this.moveOriginatorMessageID;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

