/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CMoveRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierMessage;
import com.pixelmed.network.PresentationContext;
import java.io.IOException;
import java.util.LinkedList;

public class MoveSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/MoveSOPClassSCU.java,v 1.14 2008/01/29 10:48:38 dclunie Exp $";
    protected int debugLevel;
    protected int status;

    public int getStatus() {
        return this.status;
    }

    public MoveSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, AttributeList attributeList, int n2) throws DicomNetworkException, DicomException, IOException {
        this.debugLevel = n2;
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        Object object = new LinkedList<String>();
        ((LinkedList)object).add("1.2.840.10008.1.2");
        ((LinkedList)object).add("1.2.840.10008.1.2.1");
        linkedList.add(new PresentationContext(1, string5, (LinkedList)object));
        linkedList.add(new PresentationContext(3, string5, "1.2.840.10008.1.2"));
        linkedList.add(new PresentationContext(5, string5, "1.2.840.10008.1.2.1"));
        object = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false, n2);
        if (n2 > 0) {
            System.err.println(object);
        }
        byte by = ((Association)object).getSuitablePresentationContextID(string5);
        if (n2 > 0) {
            System.err.println("Using context ID " + by);
        }
        byte[] byArray = new CMoveRequestCommandMessage(string5, string4).getBytes();
        byte[] byArray2 = new IdentifierMessage(attributeList, ((Association)object).getTransferSyntaxForPresentationContextID(by)).getBytes();
        ((Association)object).setReceivedDataHandler(new CMoveResponseHandler(n2));
        ((Association)object).send(by, byArray, null);
        ((Association)object).send(by, null, byArray2);
        if (n2 > 0) {
            System.err.println("MoveSOPClassSCU: waiting for PDUs");
        }
        try {
            ((Association)object).waitForPDataPDUsUntilHandlerReportsDone();
            if (n2 > 0) {
                System.err.println("MoveSOPClassSCU: got PDU, now releasing association");
            }
            ((Association)object).release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            Object object = TagFromName.QueryRetrieveLevel;
            StringAttribute stringAttribute = new CodeStringAttribute((AttributeTag)object);
            ((Attribute)stringAttribute).addValue(stringArray[5]);
            attributeList.put((AttributeTag)object, stringAttribute);
            object = TagFromName.StudyInstanceUID;
            stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
            ((Attribute)stringAttribute).addValue(stringArray[6]);
            attributeList.put((AttributeTag)object, stringAttribute);
            if (stringArray.length > 7) {
                object = TagFromName.SeriesInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
                ((Attribute)stringAttribute).addValue(stringArray[7]);
                attributeList.put((AttributeTag)object, stringAttribute);
            }
            if (stringArray.length > 8) {
                object = TagFromName.SOPInstanceUID;
                stringAttribute = new UniqueIdentifierAttribute((AttributeTag)object);
                ((Attribute)stringAttribute).addValue(stringArray[8]);
                attributeList.put((AttributeTag)object, stringAttribute);
            }
            object = new MoveSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], stringArray[4], "1.2.840.10008.5.1.4.1.2.2.2", attributeList, 0);
            System.err.println("MoveSOPClassSCU: final status = " + "0x" + Integer.toHexString(((MoveSOPClassSCU)object).getStatus()));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class CMoveResponseHandler
    extends CompositeResponseHandler {
        CMoveResponseHandler(int n) {
            super(n);
            this.allowData = true;
        }

        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("MoveSOPClassSCU.CMoveResponseHandler.evaluateStatusAndSetSuccess:");
            }
            MoveSOPClassSCU.this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            if (this.debugLevel > 0) {
                System.err.println("MoveSOPClassSCU.CMoveResponseHandler.evaluateStatusAndSetSuccess: status =0x" + Integer.toHexString(MoveSOPClassSCU.this.status));
            }
            if (this.debugLevel > 0) {
                System.err.print(attributeList);
            }
            if (this.debugLevel > 0) {
                System.err.println("Move " + (MoveSOPClassSCU.this.status == 65280 ? "pending" : (MoveSOPClassSCU.this.status == 0 ? "success" : "0x" + Integer.toHexString(MoveSOPClassSCU.this.status))));
            }
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFailedSuboperations, 0);
            boolean bl = this.success = MoveSOPClassSCU.this.status == 0;
            if (MoveSOPClassSCU.this.status != 65280 && n == 0) {
                this.setDone(true);
            }
        }

        protected void makeUseOfDataSet(AttributeList attributeList) {
            if (this.debugLevel > 0) {
                System.err.println("MoveSOPClassSCU.CMoveResponseHandler.makeUseOfDataSet:");
            }
            if (this.debugLevel > 0) {
                System.err.print(attributeList);
            }
            this.setDone(true);
        }
    }
}

