/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.scpecg.HuffmanDecoder;
import com.pixelmed.scpecg.RecordHeader;
import com.pixelmed.scpecg.SCPTreeBrowser;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.Section0;
import com.pixelmed.scpecg.Section1;
import com.pixelmed.scpecg.Section10;
import com.pixelmed.scpecg.Section2;
import com.pixelmed.scpecg.Section3;
import com.pixelmed.scpecg.Section4;
import com.pixelmed.scpecg.Section5Or6;
import com.pixelmed.scpecg.Section7;
import com.pixelmed.scpecg.Section8Or11;
import com.pixelmed.scpecg.SectionHeader;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class SCPECG {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/SCPECG.java,v 1.22 2007/12/19 22:44:15 dclunie Exp $";
    private TreeMap sections = new TreeMap();
    private RecordHeader recordHeader = new RecordHeader();
    private short[][] decompressedRhythmData;
    private short[][] decompressedReferenceBeatData;

    public short[][] getDecompressedRhythmData() {
        return this.decompressedRhythmData;
    }

    private void decompressRhythmData() {
        Section3 section3 = this.getSection3();
        int n = section3 == null ? 0 : section3.getNumberOfLeads();
        long[] lArray = section3 == null ? null : section3.getNumbersOfSamples();
        boolean bl = section3 == null ? false : section3.getReferenceBeatUsedForCompression();
        Section2 section2 = this.getSection2();
        int n2 = section2 == null ? 0 : section2.getNumberOfHuffmanTables();
        ArrayList arrayList = section2 == null ? null : section2.getHuffmanTables();
        Section4 section4 = this.getSection4();
        int n3 = section4 == null ? 0 : section4.getSampleNumberOfQRSOfFiducial();
        long[] lArray2 = section4 == null ? null : section4.getSampleNumberOfResidualToStartSubtractingQRS();
        long[] lArray3 = section4 == null ? null : section4.getSampleNumberOfResidualOfFiducial();
        long[] lArray4 = section4 == null ? null : section4.getSampleNumberOfResidualToEndSubtractingQRS();
        long[] lArray5 = section4 == null ? null : section4.getSampleNumberOfResidualToStartProtectedArea();
        long[] lArray6 = section4 == null ? null : section4.getSampleNumberOfResidualToEndProtectedArea();
        Section5Or6 section5Or6 = this.getSection5();
        int n4 = section5Or6 == null ? 0 : section5Or6.getSampleTimeInterval();
        Section5Or6 section5Or62 = this.getSection6();
        int n5 = section5Or62 == null ? 0 : section5Or62.getAmplitudeValueMultiplier();
        int n6 = section5Or62 == null ? 0 : section5Or62.getDifferenceDataUsed();
        byte[][] byArray = section5Or62 == null ? (byte[][])null : section5Or62.getCompressedLeadData();
        int n7 = section5Or62 == null ? 0 : section5Or62.getBimodalCompressionUsed();
        int n8 = section5Or62 == null ? 0 : section5Or62.getSampleTimeInterval();
        int n9 = n4 == 0 ? 1 : n8 / n4;
        ProtectedArea protectedArea = lArray5 == null || lArray6 == null ? null : new ProtectedArea(lArray5, lArray6);
        ReferenceBeatSubtractionZone referenceBeatSubtractionZone = bl ? new ReferenceBeatSubtractionZone(n3, lArray2, lArray3, lArray4) : null;
        this.decompressedRhythmData = new short[n][];
        for (int i = 0; i < n; ++i) {
            this.decompressedRhythmData[i] = null;
            int n10 = (int)lArray[i];
            try {
                HuffmanDecoder huffmanDecoder = new HuffmanDecoder(byArray[i], n6, n5 / 1000, n2, arrayList);
                this.decompressedRhythmData[i] = new short[n10];
                short s = 0;
                int n11 = 0;
                boolean bl2 = false;
                short s2 = 0;
                for (int j = 1; j <= n10; ++j) {
                    int n12;
                    boolean bl3;
                    boolean bl4 = bl3 = protectedArea != null && protectedArea.isSampleWithinProtectedArea(j);
                    if (bl3) {
                        s = huffmanDecoder.decode();
                        n11 = 0;
                    } else {
                        if (n9 <= 1) {
                            s = huffmanDecoder.decode();
                        } else {
                            n12 = n11 % n9;
                            if (n12 == 0) {
                                s2 = huffmanDecoder.decode();
                            }
                            s = s2;
                        }
                        ++n11;
                    }
                    if (referenceBeatSubtractionZone == null) {
                        this.decompressedRhythmData[i][j - 1] = s;
                        continue;
                    }
                    n12 = referenceBeatSubtractionZone.getSampleOffsetWithinReferenceBeatSubtractionZone(j);
                    if (n12 != -1) {
                        s = (short)(s + this.decompressedReferenceBeatData[i][n12]);
                    }
                    this.decompressedRhythmData[i][j - 1] = s;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public short[][] getDecompressedReferenceBeatData() {
        return this.decompressedReferenceBeatData;
    }

    private void decompressReferenceBeatData() {
        Section3 section3 = (Section3)this.sections.get(new Integer(3));
        int n = section3 == null ? 0 : section3.getNumberOfLeads();
        Section2 section2 = (Section2)this.sections.get(new Integer(2));
        int n2 = section2 == null ? 0 : section2.getNumberOfHuffmanTables();
        ArrayList arrayList = section2 == null ? null : section2.getHuffmanTables();
        Section4 section4 = (Section4)this.sections.get(new Integer(4));
        int n3 = section4 == null ? 0 : section4.getLengthOfReferenceBeat0DataInMilliSeconds();
        Section5Or6 section5Or6 = (Section5Or6)this.sections.get(new Integer(5));
        if (section5Or6 == null) {
            return;
        }
        int n4 = section5Or6 == null ? 0 : section5Or6.getAmplitudeValueMultiplier();
        int n5 = section5Or6 == null ? 0 : section5Or6.getSampleTimeInterval();
        int n6 = section5Or6 == null ? 0 : section5Or6.getDifferenceDataUsed();
        byte[][] byArray = section5Or6 == null ? (byte[][])null : section5Or6.getCompressedLeadData();
        int n7 = 1000 * n3 / n5;
        this.decompressedReferenceBeatData = new short[n][];
        for (int i = 0; i < n; ++i) {
            HuffmanDecoder huffmanDecoder = new HuffmanDecoder(byArray[i], n6, n4 / 1000, n2, arrayList);
            try {
                this.decompressedReferenceBeatData[i] = huffmanDecoder.decode(n7);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public SCPECG(BinaryInputStream binaryInputStream, boolean bl) throws IOException {
        Object object;
        long l = this.recordHeader.read(binaryInputStream);
        long l2 = this.recordHeader.getRecordLength() - l;
        long l3 = l;
        if (bl) {
            System.err.print(this.recordHeader);
        }
        while (l2 > 0L) {
            object = new SectionHeader();
            l = ((SectionHeader)object).read(binaryInputStream, l3);
            l2 -= l;
            l3 += l;
            if (bl) {
                System.err.print(object);
            }
            Section section = Section.makeSection((SectionHeader)object, this.sections);
            l = section.read(binaryInputStream);
            l2 -= l;
            l3 += l;
            if (bl) {
                System.err.println(section);
            }
            System.err.print(section.validate());
            this.sections.put(new Integer(((SectionHeader)object).getSectionIDNumber()), section);
        }
        object = (Section0)this.sections.get(new Integer(0));
        System.err.print(((Section0)object).validateAgainstOtherSections(this.sections));
        this.decompressReferenceBeatData();
        this.decompressRhythmData();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Section1 section1 = this.getSection1();
        if (section1 == null) {
            stringBuffer.append("No demographic and administrative data\n");
        } else {
            stringBuffer.append(section1);
        }
        Section2 section2 = this.getSection2();
        if (section2 == null) {
            stringBuffer.append("No Huffman entropy coding\n");
        } else if (section2.useDefaultTable()) {
            stringBuffer.append("Huffman entropy coding with default table\n");
        } else {
            stringBuffer.append("Huffman entropy coding with " + section2.getNumberOfHuffmanTables() + " specified tables\n");
        }
        Section3 section3 = this.getSection3();
        if (section3 == null) {
            stringBuffer.append("No lead description :(\n");
        } else {
            stringBuffer.append("Number of Leads = " + section3.getNumberOfLeads() + "\n");
            stringBuffer.append((section3.getReferenceBeatUsedForCompression() ? "Reference Beat Used For Compression" : "Reference Beat Not Used For Compression") + "\n");
            stringBuffer.append((section3.getLeadsAllSimultaneouslyRecorded() ? "Leads All Simultaneously Recorded" : "Leads Not All Simultaneously Recorded") + "\n");
            stringBuffer.append("Number of Simultaneously Recorded Leads = " + section3.getNumberOfSimultaneouslyRecordedLeads() + "\n");
        }
        Section4 section4 = this.getSection4();
        if (section4 == null) {
            stringBuffer.append("No reference beat description\n");
        } else {
            stringBuffer.append("Length ofReference Beat 0 Data In MilliSeconds = " + section4.getLengthOfReferenceBeat0DataInMilliSeconds() + "\n");
            stringBuffer.append("Sample Number ofQRS of Fiducial = " + section4.getSampleNumberOfQRSOfFiducial() + "\n");
            stringBuffer.append("Total Number of QRS Complexes = " + section4.getTotalNumberOfQRSComplexes() + "\n");
        }
        Section5Or6 section5Or6 = this.getSection5();
        if (section5Or6 == null) {
            stringBuffer.append("No reference beat data\n");
        } else {
            stringBuffer.append("Reference beat data\n");
            stringBuffer.append("\tAmplitude Value Multiplier = " + section5Or6.getAmplitudeValueMultiplier() + "\n");
            stringBuffer.append("\tSample Time Interval = " + section5Or6.getSampleTimeInterval() + "\n");
            stringBuffer.append("\tDifference Data Used = " + section5Or6.getDifferenceDataUsed() + "\n");
        }
        Section5Or6 section5Or62 = this.getSection6();
        if (section5Or62 == null) {
            stringBuffer.append("No rhythm or residual data\n");
        } else {
            stringBuffer.append("Rhythm or residual data\n");
            stringBuffer.append("\tAmplitude Value Multiplier = " + section5Or62.getAmplitudeValueMultiplier() + "\n");
            stringBuffer.append("\tSample Time Interval = " + section5Or62.getSampleTimeInterval() + "\n");
            stringBuffer.append("\tDifference Data Used = " + section5Or62.getDifferenceDataUsed() + "\n");
            stringBuffer.append("\tBimodal Compression Used = " + section5Or62.getBimodalCompressionUsed() + "\n");
        }
        return stringBuffer.toString();
    }

    public Section1 getSection1() {
        return (Section1)this.sections.get(new Integer(1));
    }

    public Section2 getSection2() {
        return (Section2)this.sections.get(new Integer(2));
    }

    public Section3 getSection3() {
        return (Section3)this.sections.get(new Integer(3));
    }

    public Section4 getSection4() {
        return (Section4)this.sections.get(new Integer(4));
    }

    public Section5Or6 getSection5() {
        return (Section5Or6)this.sections.get(new Integer(5));
    }

    public Section5Or6 getSection6() {
        return (Section5Or6)this.sections.get(new Integer(6));
    }

    public Section7 getSection7() {
        return (Section7)this.sections.get(new Integer(7));
    }

    public Section8Or11 getSection8() {
        return (Section8Or11)this.sections.get(new Integer(8));
    }

    public Section10 getSection10() {
        return (Section10)this.sections.get(new Integer(10));
    }

    public Section8Or11 getSection11() {
        return (Section8Or11)this.sections.get(new Integer(11));
    }

    public int getNumberOfLeads() {
        Section3 section3 = this.getSection3();
        return section3 == null ? 0 : section3.getNumberOfLeads();
    }

    public long[] getNumbersOfSamples() {
        Section3 section3 = this.getSection3();
        return section3 == null ? null : section3.getNumbersOfSamples();
    }

    public int getDecompressedRhythmDataSampleTimeInterval() {
        int n = 0;
        Section5Or6 section5Or6 = this.getSection5();
        if (section5Or6 != null) {
            n = section5Or6.getSampleTimeInterval();
        } else {
            Section5Or6 section5Or62 = this.getSection6();
            if (section5Or62 != null) {
                n = section5Or62.getSampleTimeInterval();
            }
        }
        return n;
    }

    public String getNamedField(String string) {
        Section1 section1 = this.getSection1();
        return section1 == null ? null : section1.getConcatenatedStringValuesOfAllOccurencesOfNamedField(string);
    }

    public String[] getLeadNames() {
        Section3 section3 = this.getSection3();
        return section3 == null ? null : section3.getLeadNames();
    }

    public int[] getLeadNumbers() {
        Section3 section3 = this.getSection3();
        return section3 == null ? null : section3.getLeadNumbers();
    }

    public Iterator getSectionIterator() {
        return this.sections == null ? null : this.sections.values().iterator();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            BinaryInputStream binaryInputStream = new BinaryInputStream(new BufferedInputStream(new FileInputStream(stringArray[0])), false);
            SCPECG sCPECG = new SCPECG(binaryInputStream, bl);
            if (stringArray.length > 1) {
                int n;
                object2 = sCPECG.getDecompressedRhythmData();
                object = new BinaryOutputStream(new BufferedOutputStream(new FileOutputStream(stringArray[1])), false);
                int n2 = ((Object)object2).length;
                int n3 = ((Object)object2[0]).length;
                for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n2; ++n) {
                        ((BinaryOutputStream)object).writeSigned16((int)object2[n][i]);
                    }
                }
                ((FilterOutputStream)object).close();
                if (stringArray.length > 2) {
                    PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(stringArray[2])));
                    for (n = 0; n < n2; ++n) {
                        printWriter.println("Lead: " + n);
                        for (int i = 0; i < n3; ++i) {
                            printWriter.println("[" + i + "]=" + (int)object2[n][i]);
                        }
                    }
                    printWriter.close();
                }
            }
            object2 = new ApplicationFrame();
            object = new JScrollPane();
            SCPTreeBrowser sCPTreeBrowser = new SCPTreeBrowser(sCPECG, (JScrollPane)object);
            ((JFrame)object2).getContentPane().add((Component)object);
            ((Window)object2).pack();
            ((Window)object2).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private class ProtectedArea {
        private int numberOfProtectedAreas;
        private long[] start;
        private long[] end;

        ProtectedArea(long[] lArray, long[] lArray2) {
            this.start = lArray;
            this.end = lArray2;
            this.numberOfProtectedAreas = this.start.length;
        }

        public boolean isSampleWithinProtectedArea(long l) {
            boolean bl = false;
            for (int i = 0; i < this.numberOfProtectedAreas; ++i) {
                if (l < this.start[i] || l > this.end[i]) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }

    private class ReferenceBeatSubtractionZone {
        private int numberOfReferenceBeatSubtractionZones;
        long fcm;
        private long[] start;
        private long[] fc;
        private long[] end;

        ReferenceBeatSubtractionZone(long l, long[] lArray, long[] lArray2, long[] lArray3) {
            this.fcm = l;
            this.start = lArray;
            this.fc = lArray2;
            this.end = lArray3;
            this.numberOfReferenceBeatSubtractionZones = this.start.length;
        }

        public int getSampleOffsetWithinReferenceBeatSubtractionZone(long l) {
            for (int i = 0; i < this.numberOfReferenceBeatSubtractionZones; ++i) {
                if (l < this.start[i] || l > this.end[i]) continue;
                int n = (int)(this.fcm - (this.fc[i] - this.start[i]));
                int n2 = (int)(l - this.start[i] + (long)n);
                return n2;
            }
            return -1;
        }
    }
}

