/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.HuffmanTable;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class Section2
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section2.java,v 1.9 2005/09/27 15:28:43 dclunie Exp $";
    private int numberOfHuffmanTables;
    private ArrayList huffmanTablesList;

    public String getSectionName() {
        return "Huffman Tables";
    }

    public int getNumberOfHuffmanTables() {
        return this.numberOfHuffmanTables;
    }

    public static boolean useDefaultTable(int n) {
        return n == 19999;
    }

    public boolean useDefaultTable() {
        return Section2.useDefaultTable(this.numberOfHuffmanTables);
    }

    public boolean useNoTable() {
        return this.numberOfHuffmanTables == 0;
    }

    public int getNumberOfEncodedHuffmanTables() {
        return this.huffmanTablesList == null ? 0 : this.huffmanTablesList.size();
    }

    public ArrayList getHuffmanTables() {
        return this.huffmanTablesList;
    }

    public Section2(SectionHeader sectionHeader) {
        super(sectionHeader);
    }

    public long read(BinaryInputStream binaryInputStream) throws IOException {
        this.numberOfHuffmanTables = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        if ((this.useDefaultTable() || this.useNoTable()) && this.sectionBytesRemaining != 0L) {
            System.err.println("Section 2 Number Of Huffman Tables =" + this.numberOfHuffmanTables + " dec, but " + this.sectionBytesRemaining + " more bytes(code structures) in section are present - ignoring them");
            this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        }
        while (this.sectionBytesRemaining > 0L) {
            int n = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = binaryInputStream.readUnsigned8();
                ++this.bytesRead;
                --this.sectionBytesRemaining;
                nArray2[i] = binaryInputStream.readUnsigned8();
                ++this.bytesRead;
                --this.sectionBytesRemaining;
                nArray3[i] = binaryInputStream.readUnsigned8();
                ++this.bytesRead;
                --this.sectionBytesRemaining;
                nArray4[i] = binaryInputStream.readUnsigned16();
                this.bytesRead += 2L;
                this.sectionBytesRemaining -= 2L;
                lArray[i] = binaryInputStream.readUnsigned32();
                this.bytesRead += 4L;
                this.sectionBytesRemaining -= 4L;
            }
            if (this.huffmanTablesList == null) {
                this.huffmanTablesList = new ArrayList();
            }
            this.huffmanTablesList.add(new HuffmanTable(n, nArray, nArray2, nArray3, nArray4, lArray));
        }
        if (!this.useDefaultTable() && this.numberOfHuffmanTables != this.getNumberOfEncodedHuffmanTables()) {
            System.err.println("Section 2 Number Of Huffman Tables specified as " + this.numberOfHuffmanTables + " but encountered " + this.getNumberOfEncodedHuffmanTables());
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of Huffman Tables = " + this.numberOfHuffmanTables + " dec (0x" + Integer.toHexString(this.numberOfHuffmanTables) + ")");
        stringBuffer.append((this.useDefaultTable() ? " DEFAULT" : "") + "\n");
        if (this.huffmanTablesList != null) {
            ListIterator listIterator = this.huffmanTablesList.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append("Table Number = " + listIterator.nextIndex() + "\n");
                HuffmanTable huffmanTable = (HuffmanTable)listIterator.next();
                stringBuffer.append(huffmanTable);
            }
        }
        return stringBuffer.toString();
    }

    public String validate() {
        return "";
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            new SCPTreeRecord(sCPTreeRecord2, "Number of Huffman Tables", Long.toString(this.numberOfHuffmanTables) + " dec (0x" + Long.toHexString(this.numberOfHuffmanTables) + ")" + (this.useDefaultTable() ? " DEFAULT" : ""));
        }
        return this.tree;
    }
}

