/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.scpecg;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.scpecg.SCPTreeRecord;
import com.pixelmed.scpecg.Section;
import com.pixelmed.scpecg.SectionHeader;
import java.io.IOException;

public class Section5Or6
extends Section {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/scpecg/Section5Or6.java,v 1.6 2004/02/22 19:54:18 dclunie Exp $";
    private int amplitudeValueMultiplier;
    private int sampleTimeInterval;
    private int differenceDataUsed;
    private int bimodalCompressionUsed;
    private int numberOfLeads;
    private int[] byteLengthsOfEncodedLeads;
    private long totalBytesinCompressedLeadData;
    private byte[][] compressedLeadData;

    public String getSectionName() {
        return this.header.getSectionIDNumber() == 5 ? "Encoded Reference Beat Data" : "Encoded Residual or Rhythm Data";
    }

    public int getAmplitudeValueMultiplier() {
        return this.amplitudeValueMultiplier;
    }

    public int getSampleTimeInterval() {
        return this.sampleTimeInterval;
    }

    public int getDifferenceDataUsed() {
        return this.differenceDataUsed;
    }

    public int getBimodalCompressionUsed() {
        return this.bimodalCompressionUsed;
    }

    public int getNumberOfLeads() {
        return this.numberOfLeads;
    }

    public int[] getByteLengthsOfEncodedLeads() {
        return this.byteLengthsOfEncodedLeads;
    }

    public long getTotalBytesinCompressedLeadData() {
        return this.totalBytesinCompressedLeadData;
    }

    public byte[][] getCompressedLeadData() {
        return this.compressedLeadData;
    }

    public Section5Or6(SectionHeader sectionHeader, int n) {
        super(sectionHeader);
        this.numberOfLeads = n;
    }

    public long read(BinaryInputStream binaryInputStream) throws IOException {
        int n;
        this.amplitudeValueMultiplier = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.sampleTimeInterval = binaryInputStream.readUnsigned16();
        this.bytesRead += 2L;
        this.sectionBytesRemaining -= 2L;
        this.differenceDataUsed = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.bimodalCompressionUsed = binaryInputStream.readUnsigned8();
        ++this.bytesRead;
        --this.sectionBytesRemaining;
        this.byteLengthsOfEncodedLeads = new int[this.numberOfLeads];
        this.compressedLeadData = new byte[this.numberOfLeads][];
        this.totalBytesinCompressedLeadData = 0L;
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.numberOfLeads; ++n) {
            this.byteLengthsOfEncodedLeads[n] = binaryInputStream.readUnsigned16();
            this.bytesRead += 2L;
            this.sectionBytesRemaining -= 2L;
            this.totalBytesinCompressedLeadData += (long)this.byteLengthsOfEncodedLeads[n];
        }
        if (n != this.numberOfLeads) {
            System.err.println("Section 6 Expected byte lengths of encoded leads for " + this.numberOfLeads + " but only got " + n);
        }
        if (this.totalBytesinCompressedLeadData != this.sectionBytesRemaining) {
            System.err.println("Section 6 Expected total byte lengths of compressed leads of " + this.totalBytesinCompressedLeadData + " but got " + this.sectionBytesRemaining);
        }
        for (n = 0; this.sectionBytesRemaining > 0L && n < this.numberOfLeads; ++n) {
            int n2 = this.byteLengthsOfEncodedLeads[n];
            this.compressedLeadData[n] = new byte[n2];
            binaryInputStream.readInsistently(this.compressedLeadData[n], 0, n2);
            this.sectionBytesRemaining -= (long)n2;
            this.bytesRead += (long)n2;
        }
        this.skipToEndOfSectionIfNotAlreadyThere(binaryInputStream);
        return this.bytesRead;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Amplitude Value Multiplier in nanoVolts = " + this.amplitudeValueMultiplier + " dec (0x" + Integer.toHexString(this.amplitudeValueMultiplier) + ")\n");
        stringBuffer.append("Sample Time Interval in microSeconds = " + this.sampleTimeInterval + " dec (0x" + Integer.toHexString(this.sampleTimeInterval) + ")\n");
        stringBuffer.append("Difference Data Used = " + this.differenceDataUsed + " (" + (this.differenceDataUsed == 0 ? "No" : (this.differenceDataUsed == 1 ? "First" : "Second")) + ")\n");
        if (this.header.getSectionIDNumber() == 6) {
            stringBuffer.append("Bimodal Compression Used = " + this.bimodalCompressionUsed + " (" + (this.bimodalCompressionUsed == 0 ? "No" : "Yes") + ")\n");
        }
        stringBuffer.append("Byte lengths of encoded (compressed) leads:\n");
        for (int i = 0; i < this.numberOfLeads; ++i) {
            stringBuffer.append("\tLead " + i + ":\n");
            stringBuffer.append("\t\tbytes = " + this.byteLengthsOfEncodedLeads[i] + " dec (0x" + Integer.toHexString(this.byteLengthsOfEncodedLeads[i]) + ")\n");
        }
        return stringBuffer.toString();
    }

    public String validate() {
        return "";
    }

    public SCPTreeRecord getTree(SCPTreeRecord sCPTreeRecord) {
        if (this.tree == null) {
            SCPTreeRecord sCPTreeRecord2 = new SCPTreeRecord(sCPTreeRecord, "Section", this.getValueForSectionNodeInTree());
            this.addSectionHeaderToTree(sCPTreeRecord2);
            new SCPTreeRecord(sCPTreeRecord2, "Amplitude Value Multiplier in nanoVolts", Integer.toString(this.amplitudeValueMultiplier) + " dec (0x" + Integer.toHexString(this.amplitudeValueMultiplier) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Sample Time Interval in microSeconds", Integer.toString(this.sampleTimeInterval) + " dec (0x" + Integer.toHexString(this.sampleTimeInterval) + ")");
            new SCPTreeRecord(sCPTreeRecord2, "Difference Data Used", this.differenceDataUsed == 0 ? "No" : (this.differenceDataUsed == 1 ? "First" : "Second"));
            if (this.header.getSectionIDNumber() == 6) {
                new SCPTreeRecord(sCPTreeRecord2, "Bimodal Compression Used", this.bimodalCompressionUsed == 0 ? "no" : "yes");
            }
            SCPTreeRecord sCPTreeRecord3 = new SCPTreeRecord(sCPTreeRecord2, "Lengths of encoded (compressed) leads");
            for (int i = 0; i < this.numberOfLeads; ++i) {
                SCPTreeRecord sCPTreeRecord4 = new SCPTreeRecord(sCPTreeRecord3, "Lead", Integer.toString(i + 1));
                new SCPTreeRecord(sCPTreeRecord4, "Length in bytes", Integer.toString(this.byteLengthsOfEncodedLeads[i]) + " dec (0x" + Integer.toHexString(this.byteLengthsOfEncodedLeads[i]) + ")");
            }
        }
        return this.tree;
    }
}

