/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.transfermonitor;

import com.pixelmed.transfermonitor.TransferMonitor;
import com.pixelmed.transfermonitor.TransferMonitoringContext;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredOutputStream
extends OutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/transfermonitor/MonitoredOutputStream.java,v 1.2 2008/02/22 19:14:50 dclunie Exp $";
    private OutputStream out;
    private TransferMonitor monitor;

    public MonitoredOutputStream(OutputStream outputStream, TransferMonitoringContext transferMonitoringContext) {
        this.out = outputStream;
        this.monitor = TransferMonitor.newTransferMonitor(transferMonitoringContext);
    }

    public final void close() throws IOException {
        this.out.close();
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    public final void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.monitor.countUp(byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.monitor.countUp(n2);
    }

    public final void write(int n) throws IOException {
        this.out.write(n);
        this.monitor.countUp(1);
    }
}

