/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.DataChannelReader;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.dc.TransferThread;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class TransferSinkThread
extends TransferThread {
    protected static Log logger = LogFactory.getLog(TransferSinkThread.class.getName());
    protected DataChannelReader reader;
    protected DataSink sink;
    protected BasicServerControlChannel localControlChannel;
    protected TransferContext context;
    protected SocketBox socketBox;

    public TransferSinkThread(AbstractDataChannel dataChannel, SocketBox socketBox, DataSink sink, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.socketBox = socketBox;
        this.sink = sink;
        this.localControlChannel = localControlChannel;
        this.context = context;
        this.reader = dataChannel.getDataChannelSource(context);
        this.reader.setDataStream(socketBox.getSocket().getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean error = false;
        Object quitToken = null;
        logger.debug("TransferSinkThread executing");
        try {
            this.startup();
            try {
                this.copy();
            }
            catch (Exception e) {
                error = true;
                FTPServerFacade.exceptionToControlChannel(e, "exception during TransferSinkThread", this.localControlChannel);
            }
            finally {
                quitToken = this.context.getQuitToken();
                this.shutdown(quitToken);
            }
            if (!error && quitToken != null) {
                this.localControlChannel.write(new LocalReply(226));
            }
        }
        catch (Exception e) {
            FTPServerFacade.cannotPropagateError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() throws Exception {
        BasicServerControlChannel basicServerControlChannel = this.localControlChannel;
        synchronized (basicServerControlChannel) {
            if (this.localControlChannel.getReplyCount() == 0) {
                this.localControlChannel.write(new LocalReply(125));
            }
        }
    }

    protected void copy() throws Exception {
        Buffer buf;
        long transferred = 0L;
        while ((buf = this.reader.read()) != null) {
            transferred += (long)buf.getLength();
            this.sink.write(buf);
        }
        logger.debug("finished receiving data; received " + transferred + " bytes");
    }

    protected void shutdown(Object quitToken) throws IOException {
        logger.debug("shutdown");
        this.reader.close();
        this.socketBox.setSocket(null);
        if (quitToken != null) {
            this.sink.close();
        }
    }
}

