/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.io.gass.client.internal.GASSProtocol;
import org.globus.io.streams.GlobusInputStream;
import org.globus.net.SocketFactory;
import org.globus.util.GlobusURL;
import org.globus.util.http.HTTPChunkedInputStream;
import org.globus.util.http.HttpResponse;

public class HTTPInputStream
extends GlobusInputStream {
    private static Log logger = LogFactory.getLog(HTTPInputStream.class.getName());
    protected InputStream input;
    protected Socket socket;
    protected long size = -1L;

    protected HTTPInputStream() {
    }

    public HTTPInputStream(String host, int port, String file) throws IOException {
        this.get(host, port, file);
    }

    protected Socket openSocket(String host, int port) throws IOException {
        return SocketFactory.getDefault().createSocket(host, port);
    }

    protected void get(String host, int port, String file) throws IOException {
        HttpResponse hd;
        block11: {
            hd = null;
            block6: while (true) {
                this.socket = this.openSocket(host, port);
                this.input = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                String msg = GASSProtocol.GET(file, host + ":" + port);
                try {
                    out.write(msg.getBytes());
                    out.flush();
                    if (logger.isTraceEnabled()) {
                        logger.trace("SENT: " + msg);
                    }
                    hd = new HttpResponse(this.input);
                }
                catch (IOException e) {
                    this.abort();
                    throw e;
                }
                if (hd.httpCode == 200) break block11;
                this.abort();
                switch (hd.httpCode) {
                    case 404: {
                        throw new FileNotFoundException("File " + file + " not found on the server.");
                    }
                    case 301: 
                    case 302: {
                        logger.debug("Received redirection to: " + hd.location);
                        GlobusURL newLocation = new GlobusURL(hd.location);
                        host = newLocation.getHost();
                        port = newLocation.getPort();
                        file = newLocation.getPath();
                        continue block6;
                    }
                }
                break;
            }
            throw new IOException("Failed to retrieve file from server.  Server returned error: " + hd.httpMsg + " (" + hd.httpCode + ")");
        }
        if (hd.chunked) {
            this.input = new HTTPChunkedInputStream(this.input);
        } else if (hd.contentLength > 0L) {
            this.size = hd.contentLength;
        }
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public int read(byte[] msg) throws IOException {
        return this.input.read(msg);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.input.read(buf, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }
}

