/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.globus.common.CoGProperties;
import org.globus.tools.ui.config.AbstractWizard;
import org.globus.tools.ui.config.ConfigModule0;
import org.globus.tools.ui.config.ConfigModule1;
import org.globus.tools.ui.config.ConfigModule2;
import org.globus.tools.ui.config.ConfigModule3;
import org.globus.tools.ui.util.UITools;

public class ConfigurationWizard
extends AbstractWizard {
    protected CoGProperties props = null;

    public ConfigurationWizard() {
        this.setTitle("Java CoG Kit Configuration Wizard");
        this.props = CoGProperties.getDefault();
        this.initComponents();
    }

    private void initComponents() {
        this.addModule(new ConfigModule0(this.props));
        this.addModule(new ConfigModule1(this.props));
        this.pack();
        this.addModule(new ConfigModule2(this.props));
        this.addModule(new ConfigModule3(this.props));
    }

    @Override
    public void saveSettings() {
        File cFile = new File(CoGProperties.configFile);
        File directory = cFile.getParentFile();
        try {
            if (!directory.exists() && !directory.mkdir()) {
                throw new IOException("Unable to create directory : " + directory);
            }
            this.props.remove("internal.usercert");
            this.props.save(CoGProperties.configFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to save the configuration file:\n" + e.getMessage(), "Error Saving Configuration", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "The Java CoG Kit is now successfully configured.", "Java CoG Kit Configuration Wizard", 1);
        System.exit(0);
    }

    public static void main(String[] args) {
        ConfigurationWizard configWizard = new ConfigurationWizard();
        UITools.center(null, configWizard);
        configWizard.setVisible(true);
    }
}

