/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.proxy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.globus.tools.ui.proxy.GridProxyProperties;
import org.globus.tools.ui.util.FileBrowser;
import org.globus.tools.ui.util.JJPanel;

public class GridProxyDialog
extends JDialog
implements ActionListener {
    private GridProxyProperties gridProps;
    private FileBrowser certFileFB;
    private FileBrowser keyFileFB;
    private FileBrowser proxyFileFB;
    private FileBrowser caCertFileFB;
    private ButtonGroup hoursGroup = new ButtonGroup();
    private ButtonGroup bitsGroup = new ButtonGroup();
    private JButton okButton;
    private JButton saveButton;
    private JButton exitButton;
    private JRadioButton otherRB;
    private JTextField otherTF;

    public GridProxyDialog(GridProxyProperties props) {
        this.gridProps = props;
        this.setTitle("Credential Properties");
        this.setSize(520, 300);
        Container contentPane = this.getContentPane();
        JJPanel gridPanel = new JJPanel();
        gridPanel.setInsets(2, 2, 2, 2);
        gridPanel.setAnchor(13);
        gridPanel.setBorder(BorderFactory.createEtchedBorder());
        gridPanel.add(new JLabel("Proxy Lifetime: "), 0, 0, 1, 1);
        gridPanel.add(new JLabel("Key length: "), 0, 1, 1, 1);
        gridPanel.add(new JLabel("Location of User Certificate: "), 0, 2, 1, 1);
        gridPanel.add(new JLabel("Location of User Private Key: "), 0, 3, 1, 1);
        gridPanel.add(new JLabel("Location of CA Certificate: "), 0, 4, 1, 1);
        gridPanel.add(new JLabel("Location of Grid Proxy File: "), 0, 5, 1, 1);
        gridPanel.setAnchor(17);
        gridPanel.gbc.weightx = 1.0;
        gridPanel.setFill(2);
        JPanel hoursPanel = new JPanel(new FlowLayout(0, 2, 0));
        JRadioButton shRB = new JRadioButton("12 h");
        JRadioButton mhRB = new JRadioButton("24 h");
        JRadioButton lhRB = new JRadioButton("1 week");
        JRadioButton ghRB = new JRadioButton("1 month");
        this.otherRB = new JRadioButton();
        shRB.setActionCommand("12");
        mhRB.setActionCommand("24");
        lhRB.setActionCommand("168");
        ghRB.setActionCommand("672");
        this.otherRB.setActionCommand("other");
        this.otherTF = new JTextField(3);
        this.otherTF.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GridProxyDialog.this.otherRB.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        int time = this.gridProps.getHours();
        if (time == 12) {
            shRB.setSelected(true);
        } else if (time == 24) {
            mhRB.setSelected(true);
        } else if (time == 168) {
            lhRB.setSelected(true);
        } else if (time == 672) {
            ghRB.setSelected(true);
        } else {
            this.otherTF.setText(String.valueOf(time));
            this.otherRB.setSelected(true);
        }
        this.hoursGroup.add(shRB);
        this.hoursGroup.add(mhRB);
        this.hoursGroup.add(lhRB);
        this.hoursGroup.add(ghRB);
        this.hoursGroup.add(this.otherRB);
        hoursPanel.add(shRB);
        hoursPanel.add(mhRB);
        hoursPanel.add(lhRB);
        hoursPanel.add(ghRB);
        hoursPanel.add(this.otherRB);
        hoursPanel.add(this.otherTF);
        hoursPanel.add(new JLabel("h"));
        gridPanel.add(hoursPanel, 1, 0, 1, 1);
        JPanel bitsPanel = new JPanel(new FlowLayout(0, 2, 0));
        JRadioButton sbRB = new JRadioButton("512");
        JRadioButton mbRB = new JRadioButton("1024");
        JRadioButton lbRB = new JRadioButton("2048");
        JRadioButton gbRB = new JRadioButton("4096");
        sbRB.setActionCommand("512");
        mbRB.setActionCommand("1024");
        lbRB.setActionCommand("2048");
        gbRB.setActionCommand("4096");
        if (this.gridProps.getBits() == 512) {
            sbRB.setSelected(true);
        } else if (this.gridProps.getBits() == 1024) {
            mbRB.setSelected(true);
        } else if (this.gridProps.getBits() == 2048) {
            lbRB.setSelected(true);
        } else if (this.gridProps.getBits() == 4096) {
            gbRB.setSelected(true);
        }
        this.bitsGroup.add(sbRB);
        this.bitsGroup.add(mbRB);
        this.bitsGroup.add(lbRB);
        this.bitsGroup.add(gbRB);
        bitsPanel.add(sbRB);
        bitsPanel.add(mbRB);
        bitsPanel.add(lbRB);
        bitsPanel.add(gbRB);
        gridPanel.add(bitsPanel, 1, 1, 1, 1);
        this.certFileFB = new FileBrowser("Select User Certificate", "Select");
        this.certFileFB.setFile(this.gridProps.getUserCertFile());
        gridPanel.add(this.certFileFB, 1, 2, 1, 1);
        this.keyFileFB = new FileBrowser("Select User Private Key", "Select");
        this.keyFileFB.setFile(this.gridProps.getUserKeyFile());
        gridPanel.add(this.keyFileFB, 1, 3, 1, 1);
        this.caCertFileFB = new FileBrowser("Select CA Certificate", "Select");
        this.caCertFileFB.setFile(this.gridProps.getCACertFile());
        gridPanel.add(this.caCertFileFB, 1, 4, 1, 1);
        this.proxyFileFB = new FileBrowser("Select Grid Proxy File", "Select");
        this.proxyFileFB.setFile(this.gridProps.getProxyFile());
        gridPanel.add(this.proxyFileFB, 1, 5, 1, 1);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)gridPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton("OK");
        this.saveButton = new JButton("Save");
        this.exitButton = new JButton("Cancel");
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.exitButton);
        this.okButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        contentPane.add((Component)buttonPanel, "South");
    }

    private boolean error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Need More Information", 2);
        return false;
    }

    private boolean validateSettings() {
        if (this.proxyFileFB.getFile().equals("")) {
            return this.error("Please enter the proxy file location");
        }
        if (this.certFileFB.getFile().equals("")) {
            return this.error("Please enter the certificate file location");
        }
        if (this.keyFileFB.getFile().equals("")) {
            return this.error("Please enter the private key file location");
        }
        if (this.caCertFileFB.getFile().equals("")) {
            return this.error("Please enter the CA certificate file location");
        }
        if (this.otherRB.isSelected()) {
            this.gridProps.setHours(Integer.parseInt(this.otherTF.getText().trim()));
        } else {
            this.gridProps.setHours(Integer.parseInt(this.hoursGroup.getSelection().getActionCommand()));
        }
        this.gridProps.setBits(Integer.parseInt(this.bitsGroup.getSelection().getActionCommand()));
        this.gridProps.setProxyFile(this.proxyFileFB.getFile());
        this.gridProps.setUserCertFile(this.certFileFB.getFile());
        this.gridProps.setUserKeyFile(this.keyFileFB.getFile());
        this.gridProps.setCACertFile(this.caCertFileFB.getFile());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            if (!this.validateSettings()) {
                return;
            }
            this.setVisible(false);
        } else if (source == this.saveButton) {
            if (!this.validateSettings()) {
                return;
            }
            if (this.gridProps.saveProperties()) {
                JOptionPane.showMessageDialog(this, "Successfully saved properties", "Information", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Failed to save properties", "Information", 2);
            }
        } else if (source == this.exitButton) {
            this.setVisible(false);
        } else {
            System.err.println("Unidentified event in GridProxyDialog");
        }
    }
}

