/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.net.URI;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;

public class CatalogEntryDownload
extends CatalogEntry {
    private static Log _logger = LogFactory.getLog((String)CatalogEntryDownload.class.getName());
    private JProgressBar _progbar = null;
    private JLabel _messageLabel = null;
    private JLabel _submessageLabel = null;
    private JButton _cancelButton = null;
    private JButton _refreshButton = null;
    private TimeZone _timezone;
    private int _timeStampCheckDepth = -1;

    CatalogEntryDownload() {
    }

    CatalogEntryDownload(URI url, String name, TimeZone timezone, int timeStampCheckDepth) {
        super(url, name);
        this._timezone = timezone;
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    protected void addMetaFieldString(String mfname, String mfvalue) throws IllegalArgumentException {
        _logger.debug((Object)("CatalogEntryDownload.addMetaField:     adding name='" + mfname + "' value='" + mfvalue + "'"));
        if (mfvalue == null) {
            return;
        }
        if ("timeZone".equals(mfname)) {
            super.addMetaField(mfname, (Object)TimeZone.getTimeZone(mfvalue));
        } else if ("timeStampCheckDepth".equals(mfname)) {
            super.addMetaField(mfname, (Object)Integer.parseInt(mfvalue));
        }
    }

    public TimeZone getTimeZone() {
        return this._timezone;
    }

    public void setTimeZone(TimeZone timezone) {
        this._timezone = timezone;
    }

    public int getTimeStampCheckDepth() {
        return this._timeStampCheckDepth;
    }

    public void setTimeStampCheckDepth(int timeStampCheckDepth) {
        this._timeStampCheckDepth = timeStampCheckDepth;
    }

    public JProgressBar getProgressBar() {
        return this._progbar;
    }

    public void setProgressBar(JProgressBar progbar) {
        this._progbar = progbar;
    }

    public JLabel getMessageLabel() {
        return this._messageLabel;
    }

    public void setMessageLabel(JLabel label) {
        this._messageLabel = label;
    }

    public JLabel getSubMessageLabel() {
        return this._submessageLabel;
    }

    public void setSubMessageLabel(JLabel label) {
        this._submessageLabel = label;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public void setCancelButton(JButton button) {
        this._cancelButton = button;
    }

    public JButton getRefreshButton() {
        return this._refreshButton;
    }

    public void setRefreshButton(JButton button) {
        this._refreshButton = button;
    }
}

