/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirndownloader.CatalogDownload;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.Main;
import org.nbirn.fbirndownloader.ProgressBarListener;
import org.nbirn.fbirndownloader.WorkerDownloadFromCatalog;
import org.nbirn.fbirndownloader.WorkerDownloadFromURL;

public class MainFrame
extends JFrame {
    final String XCEDE2NS = "http://www.xcede.org/xcede-2";
    private Main _main = null;
    private CatalogDownload _catalog = null;
    Properties _properties = null;
    CredentialManager _credman = null;
    WorkerDownloadFromCatalog _downloadworker = null;
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    private final int _numsavedprops = 10;
    private JPanel _CatalogPanel;
    private JPanel _CatalogSpacer;
    private JLabel _CatalogURLLabel;
    private JComboBox _CatalogURLTextField;
    private JPanel _CheckboxPanelSpacer;
    private JButton _DownloadButton;
    private JButton _DownloadCatalogButton;
    private JProgressBar _DownloadCatalogProgressBar;
    private JPanel _DownloadCatalogSpacer;
    private JPanel _DownloadPanel;
    private JProgressBar _DownloadProgressBar;
    private JPanel _DownloadProgressPanel;
    private JCheckBox _DryRunCheckBox;
    private JButton _OutputDirButton;
    private JFileChooser _OutputDirFileChooser;
    private JLabel _OutputDirLabel;
    private JPanel _OutputDirPanel;
    private JComboBox _OutputDirTextField;
    private JPanel _TopPanel;
    private JScrollPane _TopScrollPane;
    private JCheckBox _UpdateQuestionCheckBox;
    private JPanel _UpdateQuestionPanel;

    public MainFrame(Main main) {
        this.initComponents();
        this._main = main;
        Vector<String> outputDirSet = this._main.getPropertySet("outputDir");
        this._OutputDirTextField.removeAllItems();
        for (int i = 0; i < outputDirSet.size(); ++i) {
            this._OutputDirTextField.addItem(this.makeObj(outputDirSet.get(i)));
        }
        Vector<String> catalogURLSet = this._main.getPropertySet("catalogURL");
        this._CatalogURLTextField.removeAllItems();
        for (int i = 0; i < catalogURLSet.size(); ++i) {
            this._CatalogURLTextField.addItem(this.makeObj(catalogURLSet.get(i)));
        }
        AppPropertyChanger catchanger = new AppPropertyChanger(this._main, "catalogURL", this._CatalogURLTextField);
        AppPropertyChanger outputchanger = new AppPropertyChanger(this._main, "outputDir", this._OutputDirTextField);
        this._CatalogURLTextField.addActionListener(catchanger);
        this._OutputDirTextField.addActionListener(outputchanger);
        this.pack();
        this._credman = new CredentialManager(this._main, this);
    }

    private void initComponents() {
        this._OutputDirFileChooser = new JFileChooser();
        this._TopScrollPane = new JScrollPane();
        this._TopPanel = new JPanel();
        this._OutputDirPanel = new JPanel();
        this._OutputDirLabel = new JLabel();
        this._OutputDirTextField = new JComboBox();
        this._OutputDirButton = new JButton();
        this._CatalogPanel = new JPanel();
        this._CatalogURLLabel = new JLabel();
        this._CatalogURLTextField = new JComboBox();
        this._CatalogSpacer = new JPanel();
        this._DownloadCatalogButton = new JButton();
        this._DownloadCatalogSpacer = new JPanel();
        this._DownloadCatalogProgressBar = new JProgressBar();
        this._DownloadPanel = new JPanel();
        this._DownloadButton = new JButton();
        this._UpdateQuestionPanel = new JPanel();
        this._UpdateQuestionCheckBox = new JCheckBox();
        this._CheckboxPanelSpacer = new JPanel();
        this._DryRunCheckBox = new JCheckBox();
        this._DownloadProgressBar = new JProgressBar();
        this._DownloadProgressPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("FBIRN Downloader");
        this.getContentPane().setLayout(new GridBagLayout());
        this._TopPanel.setLayout(new GridBagLayout());
        this._OutputDirPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._OutputDirPanel.setLayout(new GridBagLayout());
        this._OutputDirLabel.setFont(new Font("Dialog", 0, 12));
        this._OutputDirLabel.setText("Output dir:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        this._OutputDirPanel.add((Component)this._OutputDirLabel, gridBagConstraints);
        this._OutputDirTextField.setEditable(true);
        this._OutputDirTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._OutputDirPanel.add((Component)this._OutputDirTextField, gridBagConstraints);
        this._OutputDirButton.setFont(new Font("Dialog", 0, 12));
        this._OutputDirButton.setText("Browse...");
        this._OutputDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this._OutputDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this._OutputDirPanel.add((Component)this._OutputDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        this._TopPanel.add((Component)this._OutputDirPanel, gridBagConstraints);
        this._CatalogPanel.setLayout(new GridBagLayout());
        this._CatalogURLLabel.setFont(new Font("Dialog", 0, 12));
        this._CatalogURLLabel.setText("Catalog URL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        this._CatalogPanel.add((Component)this._CatalogURLLabel, gridBagConstraints);
        this._CatalogURLTextField.setEditable(true);
        this._CatalogURLTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._CatalogPanel.add((Component)this._CatalogURLTextField, gridBagConstraints);
        this._CatalogSpacer.setPreferredSize(new Dimension(1, 10));
        this._CatalogSpacer.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this._CatalogPanel.add((Component)this._CatalogSpacer, gridBagConstraints);
        this._DownloadCatalogButton.setText("Download Catalog");
        this._DownloadCatalogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this._DownloadCatalogButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this._CatalogPanel.add((Component)this._DownloadCatalogButton, gridBagConstraints);
        this._DownloadCatalogSpacer.setPreferredSize(new Dimension(10, 1));
        GroupLayout _DownloadCatalogSpacerLayout = new GroupLayout(this._DownloadCatalogSpacer);
        this._DownloadCatalogSpacer.setLayout(_DownloadCatalogSpacerLayout);
        _DownloadCatalogSpacerLayout.setHorizontalGroup(_DownloadCatalogSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        _DownloadCatalogSpacerLayout.setVerticalGroup(_DownloadCatalogSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this._CatalogPanel.add((Component)this._DownloadCatalogSpacer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this._CatalogPanel.add((Component)this._DownloadCatalogProgressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._TopPanel.add((Component)this._CatalogPanel, gridBagConstraints);
        this._DownloadPanel.setLayout(new GridBagLayout());
        this._DownloadButton.setText("Download Data");
        this._DownloadButton.setEnabled(false);
        this._DownloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this._DownloadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this._DownloadPanel.add((Component)this._DownloadButton, gridBagConstraints);
        this._UpdateQuestionPanel.setLayout(new GridBagLayout());
        this._UpdateQuestionCheckBox.setFont(new Font("Dialog", 0, 12));
        this._UpdateQuestionCheckBox.setSelected(true);
        this._UpdateQuestionCheckBox.setText("Update local files only if remote files are newer");
        this._UpdateQuestionPanel.add((Component)this._UpdateQuestionCheckBox, new GridBagConstraints());
        this._CheckboxPanelSpacer.setMinimumSize(new Dimension(20, 0));
        this._CheckboxPanelSpacer.setPreferredSize(new Dimension(20, 20));
        GroupLayout _CheckboxPanelSpacerLayout = new GroupLayout(this._CheckboxPanelSpacer);
        this._CheckboxPanelSpacer.setLayout(_CheckboxPanelSpacerLayout);
        _CheckboxPanelSpacerLayout.setHorizontalGroup(_CheckboxPanelSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        _CheckboxPanelSpacerLayout.setVerticalGroup(_CheckboxPanelSpacerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this._UpdateQuestionPanel.add((Component)this._CheckboxPanelSpacer, new GridBagConstraints());
        this._DryRunCheckBox.setFont(new Font("Dialog", 0, 12));
        this._DryRunCheckBox.setText("Dry run (don't actually download anything)");
        this._UpdateQuestionPanel.add((Component)this._DryRunCheckBox, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this._DownloadPanel.add((Component)this._UpdateQuestionPanel, gridBagConstraints);
        this._DownloadProgressBar.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._DownloadPanel.add((Component)this._DownloadProgressBar, gridBagConstraints);
        this._DownloadProgressPanel.setBorder(BorderFactory.createBevelBorder(1));
        this._DownloadProgressPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._DownloadPanel.add((Component)this._DownloadProgressPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        this._TopPanel.add((Component)this._DownloadPanel, gridBagConstraints);
        this._TopScrollPane.setViewportView(this._TopPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._TopScrollPane, gridBagConstraints);
        this.pack();
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _OutputDirButtonActionPerformed(ActionEvent evt) {
        while (true) {
            int returnVal;
            this._OutputDirFileChooser.setFileSelectionMode(1);
            Object selected = this._OutputDirTextField.getSelectedItem();
            if (selected != null) {
                File initdir = new File(selected.toString());
                this._OutputDirFileChooser.setCurrentDirectory(initdir);
            }
            if ((returnVal = this._OutputDirFileChooser.showOpenDialog(this)) == 0) {
                File file = this._OutputDirFileChooser.getSelectedFile();
                String outputDir = file.getAbsolutePath();
                if (!file.exists()) {
                    Object[] options = new Object[]{"Yes", "No"};
                    returnVal = JOptionPane.showOptionDialog(this, "Directory '" + outputDir + "' doesn't exist.\nWould you like to create it?", "Create Directory?", 0, 3, null, options, options[1]);
                    if (returnVal == 1) continue;
                    if (!file.mkdirs()) {
                        JOptionPane.showMessageDialog(this, "Error creating directory.", "Error", 0);
                        continue;
                    }
                }
                boolean found = false;
                for (int i = 0; i < this._OutputDirTextField.getItemCount(); ++i) {
                    if (!outputDir.equals(this._OutputDirTextField.getItemAt(i))) continue;
                    found = true;
                    this._OutputDirTextField.setSelectedIndex(i);
                }
                if (found) return;
                this._OutputDirTextField.insertItemAt(this.makeObj(outputDir), 0);
                this._OutputDirTextField.setSelectedIndex(0);
                return;
            }
            if (returnVal == 1) return;
        }
    }

    private void _DownloadCatalogButtonActionPerformed(ActionEvent evt) {
        URI url = null;
        try {
            url = new URI(this._CatalogURLTextField.getSelectedItem().toString());
        }
        catch (URISyntaxException e) {
            _logger.error((Object)"Catalog URL is not a valid URL", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Catalog URL is not a valid URL", "Error", 0);
            return;
        }
        Object doc = null;
        try {
            File tempfile = File.createTempFile("fbirndownload.", ".xml");
            WorkerDownloadFromURL worker = new WorkerDownloadFromURL(url, tempfile, this._credman);
            this._DownloadButton.setEnabled(false);
            this._DownloadCatalogButton.setEnabled(false);
            this._DownloadCatalogProgressBar.setString("Downloading...");
            this._DownloadCatalogProgressBar.setStringPainted(true);
            this._DownloadCatalogProgressBar.setIndeterminate(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            DownloadCatalogListener dclistener = new DownloadCatalogListener(this, worker, tempfile);
            worker.addPropertyChangeListener(dclistener);
            ProgressBarListener pblistener = new ProgressBarListener(this._DownloadCatalogProgressBar);
            worker.addPropertyChangeListener(pblistener);
            worker.execute();
        }
        catch (Exception e) {
            this.exceptionDialog(new Exception("Error downloading catalog document.", e));
        }
    }

    private void DownloadCatalogButtonActionFinished(WorkerDownloadFromURL worker, File catalogFile) {
        this._DownloadCatalogProgressBar.setIndeterminate(false);
        this._DownloadCatalogProgressBar.setString("");
        this.setCursor(null);
        if (worker.getError() == null) {
            this._catalog = new CatalogDownload();
            try {
                this._catalog.parseCatalogFile(catalogFile);
                this._DownloadCatalogProgressBar.setString("Downloaded and parsed catalog.");
                this._DownloadButton.setEnabled(true);
            }
            catch (Exception e) {
                this.exceptionDialog(new Exception("Error parsing catalog document", e));
            }
        }
        this._DownloadCatalogButton.setEnabled(true);
        catalogFile.delete();
    }

    private void _DownloadButtonActionPerformed(ActionEvent evt) {
        if ("Cancel download".equals(this._DownloadButton.getText())) {
            if (this._downloadworker != null) {
                this._downloadworker.cancel(true);
            }
            this.DownloadButtonActionFinished(this._downloadworker);
            return;
        }
        this._DownloadButton.setEnabled(false);
        File outputDirFile = new File(this._OutputDirTextField.getSelectedItem().toString());
        if (!outputDirFile.exists()) {
            int option = JOptionPane.showOptionDialog(this, "Specified output directory '" + outputDirFile.getPath() + "' does not exist.  Do you wish to create this directory?", "Create directory?", 0, 3, null, null, null);
            if (option == 1) {
                return;
            }
            if (!outputDirFile.mkdirs()) {
                JOptionPane.showMessageDialog(this, "Error creating output directory!", "Error", 0);
                return;
            }
        } else if (!outputDirFile.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Specified output target exists but is not a directory!", "Error", 0);
            return;
        }
        Component[] progpanelchildren = this._DownloadProgressPanel.getComponents();
        for (int i = 0; i < progpanelchildren.length; ++i) {
            this._DownloadProgressPanel.remove(i);
        }
        this._credman.resetCanceled();
        this._downloadworker = new WorkerDownloadFromCatalog(this._catalog, outputDirFile, this._DownloadProgressPanel, null, this._credman, this._UpdateQuestionCheckBox.getSelectedObjects() != null, this._DryRunCheckBox.getSelectedObjects() != null, null, 100.0);
        this._DownloadCatalogButton.setEnabled(false);
        this._DownloadProgressBar.setEnabled(true);
        this._DownloadProgressBar.setString("Downloading...");
        this._DownloadProgressBar.setStringPainted(true);
        this._DownloadProgressBar.setIndeterminate(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
        DownloadListener dlistener = new DownloadListener(this, this._downloadworker);
        this._downloadworker.addPropertyChangeListener(dlistener);
        ProgressBarListener pblistener = new ProgressBarListener(this._DownloadProgressBar);
        this._downloadworker.addPropertyChangeListener(pblistener);
        this._downloadworker.execute();
        this._DownloadButton.setText("Cancel download");
        this._DownloadButton.setEnabled(true);
    }

    private void DownloadButtonActionFinished(WorkerDownloadFromCatalog worker) {
        this._downloadworker = null;
        this._DownloadProgressBar.setIndeterminate(false);
        this._DownloadProgressBar.setString("");
        this.setCursor(null);
        boolean succeeded = false;
        try {
            if (worker != null && worker.get() == null) {
                succeeded = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (succeeded) {
            this._DownloadProgressBar.setString("Success!");
        } else {
            this._DownloadProgressBar.setString("Error");
        }
        this._DownloadCatalogButton.setEnabled(true);
        this._DownloadButton.setText("Download Data");
        this._DownloadProgressBar.setEnabled(false);
    }

    private void exceptionDialog(Exception e) {
        _logger.error((Object)"Encountered an execption", (Throwable)e);
        JOptionPane.showMessageDialog(this, "Encountered an exception:\n" + e.getMessage(), "Error", 0);
    }

    class DownloadListener
    implements PropertyChangeListener {
        MainFrame _main;
        WorkerDownloadFromCatalog _worker;

        DownloadListener(MainFrame main, WorkerDownloadFromCatalog worker) {
            this._main = main;
            this._worker = worker;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                this._main.DownloadButtonActionFinished(this._worker);
            }
        }
    }

    class DownloadCatalogListener
    implements PropertyChangeListener {
        MainFrame _main;
        WorkerDownloadFromURL _worker;
        File _catalogFile;

        DownloadCatalogListener(MainFrame main, WorkerDownloadFromURL worker, File catalogFile) {
            this._main = main;
            this._worker = worker;
            this._catalogFile = catalogFile;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                this._main.DownloadCatalogButtonActionFinished(this._worker, this._catalogFile);
            }
        }
    }

    private class AppPropertyChanger
    implements FocusListener,
    ActionListener {
        Main _main = null;
        String _propname = null;
        JComboBox _combobox = null;

        AppPropertyChanger(Main main, String propname, JComboBox combobox) {
            this._main = main;
            this._propname = propname;
            this._combobox = combobox;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Object selected = this._combobox.getSelectedItem();
            if (selected != null) {
                this._main.changeProperty(this._propname, selected.toString());
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object selected = this._combobox.getSelectedItem();
            if (selected != null) {
                this._main.changeProperty(this._propname, selected.toString());
            }
        }
    }
}

