/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirndownloader.CanceledException;
import org.nbirn.fbirndownloader.CatalogEntryDownload;
import org.nbirn.fbirndownloader.CredentialManager;
import org.nbirn.fbirndownloader.GridFTPException;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.ProgressBarListener;
import org.nbirn.fbirndownloader.ProgressUpdate;
import org.nbirn.fbirndownloader.WorkerDownloadFromCatalog;
import org.nbirn.fbirndownloader.WorkerDownloadFromURL;
import org.nbirn.fbirndownloader.WorkerProgressReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WorkerURLUpdater
extends WorkerDownloadFromURL
implements PropertyChangeListener {
    private static Log _logger = LogFactory.getLog((String)MainFrame.class.getName());
    private CatalogEntryDownload _entry = null;
    private File _dest = null;
    private CredentialManager _credman = null;
    private boolean _updateOnly = false;
    private boolean _dryRun = false;
    private TimeZone _remoteTimeZone = null;
    private int _timeStampCheckDepth = -1;
    private WorkerDownloadFromCatalog _parentWorker;
    private double _parentProgressAmount = -1.0;
    private double _lastProgress = -1.0;
    private boolean _selfCancel = false;

    WorkerURLUpdater(CatalogEntryDownload entry, File dest, CredentialManager credman, boolean updateOnly, boolean dryRun, TimeZone remoteTimeZone, int timeStampCheckDepth, WorkerDownloadFromCatalog parentWorker, double parentProgressAmount) {
        super(entry.getURL(), dest, credman, updateOnly, dryRun, remoteTimeZone, timeStampCheckDepth);
        _logger.debug((Object)("WorkerURLUpdater: URI " + entry.getURL().toString() + " allotted " + parentProgressAmount + "/100.0 of parent progress"));
        this._entry = entry;
        this._dest = dest;
        this._credman = credman;
        this._updateOnly = updateOnly;
        this._dryRun = dryRun;
        this._remoteTimeZone = remoteTimeZone;
        this._timeStampCheckDepth = timeStampCheckDepth;
        this._parentWorker = parentWorker;
        this._parentProgressAmount = parentProgressAmount;
        this._lastProgress = -1.0;
        if (this._entry.getCancelButton() != null) {
            this._entry.getCancelButton().setEnabled(false);
        }
        if (this._entry.getRefreshButton() != null) {
            this._entry.getRefreshButton().setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForRestart() {
        if (this._entry.getRefreshButton() != null) {
            final WorkerURLUpdater worker = new WorkerURLUpdater(this._entry, this._dest, this._credman, this._updateOnly, this._dryRun, this._remoteTimeZone, this._timeStampCheckDepth, this._parentWorker, this._parentProgressAmount);
            ArrayList<WorkerProgressReporter> arrayList = this._parentWorker._idletasks;
            synchronized (arrayList) {
                this._parentWorker._idletasks.add(worker);
            }
            worker._lastProgress = this._lastProgress;
            this._entry.getRefreshButton().addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    WorkerURLUpdater.this._entry.getRefreshButton().setEnabled(false);
                    ActionListener[] listeners = WorkerURLUpdater.this._entry.getCancelButton().getActionListeners();
                    for (int i = 0; i < listeners.length; ++i) {
                        WorkerURLUpdater.this._entry.getRefreshButton().removeActionListener(listeners[i]);
                    }
                    ArrayList<WorkerProgressReporter> arrayList = ((WorkerURLUpdater)WorkerURLUpdater.this)._parentWorker._idletasks;
                    synchronized (arrayList) {
                        ArrayList<WorkerProgressReporter> arrayList2 = ((WorkerURLUpdater)WorkerURLUpdater.this)._parentWorker._tasks;
                        synchronized (arrayList2) {
                            ((WorkerURLUpdater)WorkerURLUpdater.this)._parentWorker._idletasks.remove(worker);
                            ((WorkerURLUpdater)WorkerURLUpdater.this)._parentWorker._tasks.add(worker);
                        }
                    }
                    Executors.newCachedThreadPool().execute(worker);
                }
            });
        }
        this._entry.getRefreshButton().setEnabled(true);
    }

    void actionCancel(ActionEvent evt) {
        this._entry.getCancelButton().setEnabled(false);
        ActionListener[] listeners = this._entry.getCancelButton().getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this._entry.getCancelButton().removeActionListener(listeners[i]);
        }
        this._selfCancel = true;
        this.cancel(true);
    }

    @Override
    protected void cleanup(boolean error) {
        super.cleanup(error);
        if (this._selfCancel) {
            return;
        }
        if (this._entry.getProgressBar() != null) {
            this._entry.getProgressBar().setIndeterminate(false);
        }
        if (this._entry.getCancelButton() != null) {
            this._entry.getCancelButton().setEnabled(false);
        }
        if (this._entry.getRefreshButton() != null) {
            this._entry.getRefreshButton().setEnabled(false);
        }
    }

    @Override
    protected void process(List<ProgressUpdate> chunks) {
        if (this.isCancelled()) {
            return;
        }
        super.process(chunks);
        for (int i = 0; i < chunks.size(); ++i) {
            String msg;
            ProgressUpdate update = chunks.get(i);
            if (this._entry.getMessageLabel() != null && (update.getMessage() != null || update.getSubMessage() == null)) {
                msg = update.getMessage();
                this._entry.getMessageLabel().setText(msg == null ? " " : msg);
            }
            if (this._entry.getSubMessageLabel() != null) {
                msg = update.getSubMessage();
                this._entry.getSubMessageLabel().setText(msg == null ? " " : msg);
            }
            if (update.getMessage() == null) continue;
            this._parentWorker.sendUpdate(new ProgressUpdate((this._entry.getName() == null ? "" : this._entry.getName()) + " | " + update.getMessage(), 0.0));
        }
    }

    @Override
    public Void doInBackground() throws CanceledException, GridFTPException {
        if (this._entry.getCancelButton() != null) {
            this._entry.getCancelButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WorkerURLUpdater.this.actionCancel(evt);
                }
            });
        }
        if (this._entry.getCancelButton() != null) {
            this._entry.getCancelButton().setEnabled(true);
        }
        if (this._entry.getRefreshButton() != null) {
            this._entry.getRefreshButton().setEnabled(false);
        }
        if (this._entry.getProgressBar() != null) {
            this.addPropertyChangeListener(new ProgressBarListener(this._entry.getProgressBar()));
            this._entry.getProgressBar().setIndeterminate(true);
        }
        this.addPropertyChangeListener(this);
        this.publish(new ProgressUpdate("Waiting...", 0.0));
        return super.doInBackground();
    }

    @Override
    public void done() {
        block6: {
            try {
                this.get();
                this.cleanup(false);
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && e.getCause().getClass() == CanceledException.class) {
                    this.cleanup(false);
                }
            }
            catch (CancellationException e) {
                if (!this.isCancelled()) break block6;
                if (this._selfCancel) {
                    this.prepareForRestart();
                }
                this.cleanup(true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("state".equals(propName) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
            Throwable result = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                result = new CanceledException("Operation canceled.");
            }
            catch (ExecutionException e) {
                result = e.getCause();
            }
            catch (CancellationException e) {
                result = new CanceledException("Operation canceled.");
            }
            if (this._entry.getMessageLabel() != null) {
                if (result == null) {
                    this._entry.getMessageLabel().setText("Completed.");
                } else {
                    this._entry.getMessageLabel().setText("ERR: " + result.getMessage());
                }
            }
            if (this._entry.getSubMessageLabel() != null) {
                this._entry.getSubMessageLabel().setText(" ");
            }
        } else if (propName.equals("progress")) {
            int val = (Integer)evt.getNewValue();
            _logger.debug((Object)("WorkerURLUpdater: URI " + this._entry.getURL().toString() + " reporting " + val + "/100.0 progress"));
            if (this._lastProgress == -1.0 || (double)val - this._lastProgress != 0.0) {
                double parentincval = (this._lastProgress == -1.0 ? (double)val : (double)val - this._lastProgress) * (this._parentProgressAmount / 100.0);
                if (this._lastProgress == -1.0) {
                    _logger.debug((Object)("WorkerURLUpdater:   reporting incremental progress of " + val + " * ( " + this._parentProgressAmount + " / 100.0) = " + parentincval + " to parent"));
                } else {
                    _logger.debug((Object)("WorkerURLUpdater:   reporting incremental progress of (" + val + " - " + this._lastProgress + ") * ( " + this._parentProgressAmount + " / 100.0) = " + parentincval + " to parent"));
                }
                this._parentWorker.sendUpdate(new ProgressUpdate(null, parentincval));
            }
            this._lastProgress = val;
        }
    }
}

