/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;

class MultiJobListener
implements GramJobListener {
    private boolean quiet;
    private int runningJobs = 0;

    public MultiJobListener(boolean quiet) {
        this.quiet = quiet;
    }

    public void runningJob() {
        ++this.runningJobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void done() {
        --this.runningJobs;
        if (this.runningJobs <= 0) {
            MultiJobListener multiJobListener = this;
            synchronized (multiJobListener) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void statusChanged(GramJob job) {
        if (!this.quiet) {
            System.out.println("Job status:");
            System.out.println("Job ID : " + job.getIDAsString());
            System.out.println("Status : " + job.getStatusAsString());
        }
        if (job.getStatus() == 8) {
            this.done();
        } else if (job.getStatus() == 4) {
            System.out.println(job.getError());
            this.done();
        }
    }
}

