/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.X509Certificate;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.globus.common.CoGProperties;
import org.globus.tools.ui.config.BaseModule;
import org.globus.tools.ui.config.Configure;
import org.globus.tools.ui.util.CustomFileFilter;
import org.globus.tools.ui.util.FileBrowser;

public class ConfigModule1
extends BaseModule {
    private FileBrowser usercert;
    private FileBrowser userkey;
    private JButton verifyBT;

    public ConfigModule1(CoGProperties props) {
        super(props);
        JLabel label = new JLabel("Configuring User Credentials");
        label.setFont(this.getFont(this.font, 1));
        label.setForeground(Color.black);
        this.add(label, 1, 1, 1, 1);
        label = new JLabel(" ");
        this.add(label, 1, 2, 1, 1);
        CustomFileFilter filter = new CustomFileFilter(".pem", "PEM files (.pem)");
        this.usercert = new FileBrowser("Open User Certificate", "User Certificate: ", "Select");
        this.usercert.setFileFilter(filter);
        this.usercert.setFile(props.getUserCertFile());
        this.add(this.usercert, 1, 3, 1, 1);
        this.userkey = new FileBrowser("Open User Key", "User Private Key: ", "Select");
        this.userkey.setFileFilter(filter);
        this.userkey.setFile(props.getUserKeyFile());
        this.add(this.userkey, 1, 4, 1, 1);
        this.verifyBT = new JButton("Verify");
        this.verifyBT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigModule1.this.verifyKeyPair();
            }
        });
        this.verifyBT.setEnabled(false);
        this.setAnchor(17);
    }

    public void verifyKeyPair() {
        System.out.println("checks if private key goes with public key");
    }

    @Override
    public void saveSettings() {
        this.props.setUserCertFile(this.usercert.getFile());
        this.props.setUserKeyFile(this.userkey.getFile());
    }

    @Override
    public boolean verifySettings() {
        boolean rs = this.checkFile(this.usercert.getFile(), "User Certificate");
        if (!rs) {
            return false;
        }
        rs = this.checkFile(this.userkey.getFile(), "User Key");
        if (!rs) {
            return false;
        }
        rs = this.verifyCertificate();
        return rs;
    }

    private boolean verifyCertificate() {
        try {
            X509Certificate cert = Configure.verifyUserCertificate(this.usercert.getFile());
            this.props.put("internal.usercert", cert);
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "User Certificate Error", 0);
            return false;
        }
    }
}

