/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirndownloader;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.nbirn.fbirn.utilities.PropertySetManager;
import org.nbirn.fbirn.utilities.download.DownloaderCatalog;
import org.nbirn.fbirn.utilities.download.DownloaderCatalogEntry;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromCatalog;
import org.nbirn.fbirn.utilities.download.WorkerDownloadFromURL;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirndownloader.MainFrame;
import org.nbirn.fbirndownloader.TextProgressBarListener;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends PropertySetManager {
    WorkerDownloadFromCatalog _downloadworker = null;
    private static Log _logger = LogFactory.getLog((String)Main.class.getName());

    public Main() {
        super(Main.class, "FBIRNDownloader");
    }

    private ArrayList<Element> getChildElementsByTagNameNS(Element elem, String namespaceURI, String localName) throws DOMException {
        ArrayList<Element> retval = new ArrayList<Element>();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !namespaceURI.equals(child.getNamespaceURI()) || !localName.equals(child.getLocalName())) continue;
            retval.add((Element)child);
        }
        return retval;
    }

    public static void main(String[] args) {
        Boolean opt_dryrun = null;
        Boolean opt_nochecktimestamps = null;
        Boolean opt_catalog = null;
        boolean opt_gui = args.length == 0;
        int logPriority = 0;
        ArrayList<String> newargs = new ArrayList<String>();
        newargs.addAll(Arrays.asList(args));
        for (int i = 0; i < newargs.size(); ++i) {
            String arg = (String)newargs.get(i);
            if ("--dryrun".equals(arg)) {
                opt_dryrun = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--overwrite".equals(arg)) {
                opt_nochecktimestamps = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--quiet".equals(arg)) {
                logPriority = 1;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--verbose".equals(arg)) {
                logPriority = -1;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--gui".equals(arg)) {
                opt_gui = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--catalog".equals(arg)) {
                opt_catalog = true;
                newargs.remove(i);
                --i;
                continue;
            }
            if ("--nocatalog".equals(arg)) {
                opt_catalog = false;
                newargs.remove(i);
                --i;
                continue;
            }
            if (arg == null || !arg.startsWith("--")) continue;
            System.err.println("ERROR: unrecognized option " + arg);
        }
        if (opt_gui && newargs.size() > 2 || !opt_gui && newargs.size() != 2) {
            System.err.println("Usage:");
            System.err.println("  Download data specified using a URL.  The URL can be a pointer to a download catalog (which specifies the actual URLs to download).  To specify whether the URL is a catalog or the actual data source, you can specify --catalog (default) or --nocatalog.  If neither are specified, and the URL ends in a slash ('/'), then --nocatalog is assumed.");
            System.err.println("  for command-line/batch interface:");
            System.err.println("    java -jar FBIRNDownloader [--dryrun] [--overwrite] [--catalog] catalogURL outputDir");
            System.err.println("    java -jar FBIRNDownloader [--dryrun] [--overwrite] --nocatalog sourceURL outputDir");
            System.err.println("  for graphical interface start with no arguments:");
            System.err.println("    java -jar FBIRNDownloader.jar");
            System.err.println("  or use --gui option:");
            System.err.println("    java -jar FBIRNDownloader --gui [--dryrun] [--overwrite [--catalog] [ catalogURL [ outputDir ] ]");
            System.err.println("    java -jar FBIRNDownloader --gui [--dryrun] [--overwrite] --nocatalog [ sourceURL [ outputDir ] ]");
            System.exit(1);
        }
        String sourceurlstr = null;
        String destdir = null;
        if (newargs.size() >= 1) {
            sourceurlstr = (String)newargs.get(0);
        }
        if (newargs.size() >= 2) {
            destdir = (String)newargs.get(1);
        }
        if (!opt_gui) {
            System.setProperty("java.awt.headless", "true");
            Toolkit tk = Toolkit.getDefaultToolkit();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (opt_dryrun == null) {
                opt_dryrun = false;
            }
            if (opt_nochecktimestamps == null) {
                opt_nochecktimestamps = false;
            }
            if (opt_catalog == null) {
                opt_catalog = sourceurlstr.endsWith("/") ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            File tempfile = null;
            try {
                tempfile = File.createTempFile("fbirndownload.", ".xml");
            }
            catch (IOException e) {
                System.err.println("Error creating temporary file: " + e.getMessage());
            }
            Main main = new Main();
            CredentialManager credman = new CredentialManager((PropertySetManager)main, null);
            DownloaderCatalog catalog = null;
            if (opt_catalog.booleanValue()) {
                try {
                    WorkerDownloadFromURL worker = new WorkerDownloadFromURL(new URI(sourceurlstr), tempfile, credman);
                    if (logPriority <= 0) {
                        TextProgressBarListener pblistener = new TextProgressBarListener("Catalog download");
                        worker.addPropertyChangeListener((PropertyChangeListener)pblistener);
                    }
                    worker.execute();
                    worker.get();
                    catalog = new DownloaderCatalog();
                    catalog.parseCatalogFile(tempfile);
                }
                catch (Throwable e) {
                    System.err.println("Error downloading/parsing catalog document '" + sourceurlstr + "':\n");
                    while (e != null) {
                        System.err.println("Caused by: " + e.toString());
                        System.err.println("Stack trace:\n" + ExceptionDialog.getStackTraceAsString((Throwable)e));
                        e = e.getCause();
                    }
                    System.exit(1);
                }
            } else {
                catalog = new DownloaderCatalog();
                URI url = null;
                try {
                    url = new URI(sourceurlstr);
                }
                catch (URISyntaxException e) {
                    System.err.println("Source URL is not a valid URL" + e.toString());
                    System.exit(1);
                }
                DownloaderCatalogEntry entry = new DownloaderCatalogEntry();
                entry.setURI(url);
                if (!opt_nochecktimestamps.booleanValue()) {
                    entry.setTimeStampCheckDepth(Integer.MAX_VALUE);
                }
                catalog.addEntry((CatalogEntry)entry);
            }
            File outputDirFile = new File(destdir);
            if (!outputDirFile.exists()) {
                System.err.println("ERROR: Specified output directory '" + outputDirFile.getPath() + "' does not exist.");
                System.exit(1);
            } else if (!outputDirFile.isDirectory()) {
                System.err.println("ERROR: Specified output target exists but is not a directory!");
                System.exit(1);
            }
            WorkerDownloadFromCatalog worker = new WorkerDownloadFromCatalog(catalog, outputDirFile, null, credman, opt_nochecktimestamps == false, opt_dryrun.booleanValue(), null, 100.0);
            if (logPriority <= 0) {
                TextProgressBarListener pblistener = new TextProgressBarListener("Download data");
                worker.addPropertyChangeListener((PropertyChangeListener)pblistener);
            }
            worker.setLoggingPriority(logPriority);
            worker.execute();
            try {
                worker.get();
                if (logPriority <= 0) {
                    System.err.println("Success!");
                }
                System.exit(0);
            }
            catch (Throwable e) {
                System.err.println("Error downloading data:");
                while (e != null) {
                    System.err.println("Caused by: " + e.toString());
                    System.err.println("Stack trace:\n" + ExceptionDialog.getStackTraceAsString((Throwable)e));
                    e = e.getCause();
                }
                System.exit(1);
            }
            return;
        }
        final Main main = new Main();
        if (opt_dryrun == null) {
            if (main.getProperty("dryRun") == null) {
                main.changeProperty("dryRun", String.valueOf(false));
            }
        } else {
            main.changeProperty("dryRun", String.valueOf(opt_dryrun));
        }
        if (opt_nochecktimestamps == null) {
            if (main.getProperty("update") == null) {
                main.changeProperty("update", String.valueOf(true));
            }
        } else {
            main.changeProperty("update", String.valueOf(opt_nochecktimestamps == false));
        }
        if (opt_catalog == null) {
            if (sourceurlstr != null && sourceurlstr.endsWith("/")) {
                main.changeProperty("doCatalog", String.valueOf(false));
            } else if (main.getProperty("doCatalog") == null) {
                main.changeProperty("doCatalog", String.valueOf(true));
            }
        } else {
            main.changeProperty("doCatalog", String.valueOf(opt_catalog));
        }
        if (sourceurlstr != null) {
            main.changeProperty("sourceURL", sourceurlstr);
        }
        if (destdir != null) {
            main.changeProperty("outputDir", destdir);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame(main).setVisible(true);
            }
        });
    }
}

