/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.util.MethodParameterChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemHelper {
    private Log log = LogFactory.getLog(FileSystemHelper.class);

    public boolean isDirContentsEqual(File dir1, File dir2) throws IOException {
        new MethodParameterChecker().verifyNotNull(dir1, dir2);
        this.log.debug((Object)("Comparing dirs " + dir1.getAbsolutePath() + " " + dir2.getAbsolutePath()));
        if (!dir1.canRead()) {
            throw new IOException("can't read directory " + dir1);
        }
        if (!dir2.canRead()) {
            throw new IOException("can't read directory " + dir2);
        }
        if (!dir1.isDirectory()) {
            throw new IOException("not a directory: " + dir1);
        }
        if (!dir2.isDirectory()) {
            throw new IOException("not a directory: " + dir2);
        }
        String[] list1 = dir1.list();
        String[] list2 = dir2.list();
        for (int i = 0; i < list1.length; ++i) {
            File f1 = new File(dir1.getAbsolutePath(), list1[i]);
            File f2 = new File(dir2.getAbsolutePath(), list2[i]);
            if (!f1.getName().equals(f2.getName())) {
                this.log.warn((Object)(f1.getAbsolutePath() + " and " + f2.getAbsolutePath() + " should have the same name."));
                return false;
            }
            if (f1.isDirectory() && f2.isDirectory()) {
                if (this.isDirContentsEqual(f1, f2)) continue;
                return false;
            }
            if (f1.isFile() && f2.isFile()) {
                if (this.isFileContentsEqual(f1, f2)) continue;
                return false;
            }
            this.log.warn((Object)(f1.getAbsolutePath() + " and " + f2.getAbsolutePath() + " are not of the same type (file, directory)."));
            return false;
        }
        return true;
    }

    public boolean isFileContentsEqual(File file1, File file2) throws IOException {
        new MethodParameterChecker().verifyNotNull(file1, file2);
        this.log.debug((Object)("Comparing files " + file1.getAbsolutePath() + " " + file2.getAbsolutePath()));
        if (!file1.canRead()) {
            throw new IOException("file " + file1 + " is not readable");
        }
        if (!file2.canRead()) {
            throw new IOException("file " + file2 + " is not readable");
        }
        if (!file1.isFile()) {
            throw new IOException("file " + file1 + " is not a file");
        }
        if (!file2.isFile()) {
            throw new IOException("file " + file2 + " is not a file");
        }
        boolean equal = this.getFileContentAsString(file1).equals(this.getFileContentAsString(file2));
        if (!equal) {
            this.log.warn((Object)("Files " + file1.getAbsolutePath() + " and " + file2.getAbsolutePath() + " differ"));
        }
        return equal;
    }

    public byte[] getFileContentAsByteArray(File file) throws IOException {
        int offset;
        new MethodParameterChecker().verifyNotNull(file);
        if (!file.canRead()) {
            throw new IOException("file " + file + " is not readable");
        }
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        int numRead = 0;
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File " + file.getAbsolutePath() + " is too large");
        }
        byte[] bytes = new byte[(int)length];
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read the file " + file.getAbsolutePath());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public String getFileContentAsString(File file) throws IOException {
        return new String(this.getFileContentAsByteArray(file));
    }

    public void removeDirectory(File dir) throws IOException {
        String[] list;
        new MethodParameterChecker().verifyNotNull(dir);
        if (!dir.exists()) {
            return;
        }
        for (String file : list = dir.list()) {
            File f = new File(dir.getAbsolutePath(), file);
            if (f.isDirectory()) {
                this.removeDirectory(f);
                continue;
            }
            this.removeFile(f);
        }
        dir.delete();
        if (dir.exists()) {
            throw new IOException("Deletion of directory " + dir.getAbsolutePath() + " failed");
        }
    }

    public void removeFile(File f) throws IOException {
        new MethodParameterChecker().verifyNotNull(f);
        if (!f.exists()) {
            return;
        }
        if (!f.canRead() || !f.canWrite()) {
            throw new IOException(f.getAbsolutePath() + " cannot be read or written.");
        }
        if (!f.isFile()) {
            throw new IOException(f.getAbsolutePath() + " is not a file.");
        }
        f.delete();
        if (f.exists()) {
            throw new IOException("Deletion of file" + f.getAbsolutePath() + " failed.");
        }
    }

    public List<File> getDirectoryEntries(File dir) throws IOException {
        String[] entries;
        new MethodParameterChecker().verifyNotNull(dir);
        if (!dir.exists()) {
            throw new IOException(dir.getAbsolutePath() + " does not exist.");
        }
        if (!dir.canRead()) {
            throw new IOException(dir.getAbsolutePath() + " cannot be read.");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory.");
        }
        ArrayList<File> l = new ArrayList<File>();
        for (String entry : entries = dir.list()) {
            l.add(new File(dir, entry));
        }
        return l;
    }

    public List<File> getFilesInDirectory(File dir, boolean recursive) throws IOException {
        List<File> entries = this.getDirectoryEntries(dir);
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries) {
            if (entry.isDirectory()) {
                files.addAll(this.getFilesInDirectory(entry, recursive));
                continue;
            }
            files.add(entry);
        }
        return files;
    }
}

