/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;

public class FileRandomIO
implements DataSink,
DataSource {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected int bufferSize;
    protected RandomAccessFile file;
    protected long offset;

    public FileRandomIO(RandomAccessFile file) {
        this(file, 16384);
    }

    public FileRandomIO(RandomAccessFile file, int bufferSize) {
        this.file = file;
        this.bufferSize = bufferSize;
    }

    @Override
    public synchronized void write(Buffer buffer) throws IOException {
        long bufOffset = buffer.getOffset();
        if (bufOffset == -1L) {
            if (this.file.getFilePointer() != this.offset) {
                throw new IOException("Invalid offset: " + bufOffset);
            }
        } else {
            this.file.seek(bufOffset);
        }
        this.file.write(buffer.getBuffer(), 0, buffer.getLength());
        this.offset += (long)buffer.getLength();
    }

    @Override
    public synchronized Buffer read() throws IOException {
        long offset = this.file.getFilePointer();
        byte[] buf = new byte[this.bufferSize];
        int read = this.file.read(buf);
        if (read == -1) {
            return null;
        }
        return new Buffer(buf, read, offset);
    }

    @Override
    public synchronized void close() throws IOException {
        this.file.close();
    }

    @Override
    public long totalSize() throws IOException {
        return this.file.length();
    }
}

