/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.SigningPolicyParser;
import org.globus.gsi.SigningPolicyParserException;
import org.globus.gsi.ptls.PureTLSUtil;
import org.globus.util.TimestampEntry;

public class TrustedCertificates
implements Serializable {
    private static Log logger = LogFactory.getLog(TrustedCertificates.class.getName());
    public static final CertFilter certFileFilter = new CertFilter();
    private static TrustedCertificates trustedCertificates = null;
    private Map certSubjectDNMap;
    private Map certFileMap;
    private boolean changed;
    private Map policyDNMap;
    private Map policyFileMap;
    private Vector certList;
    public static String SIGNING_POLICY_FILE_SUFFIX = ".signing_policy";

    protected TrustedCertificates() {
    }

    public TrustedCertificates(X509Certificate[] certs) {
        this(certs, null);
    }

    public TrustedCertificates(X509Certificate[] certs, SigningPolicy[] policies) {
        int i;
        this.certSubjectDNMap = new HashMap();
        for (i = 0; i < certs.length; ++i) {
            String dn = ((Object)certs[i].getSubjectDN()).toString();
            this.certSubjectDNMap.put(dn, certs[i]);
        }
        if (policies != null) {
            this.policyDNMap = new HashMap();
            for (i = 0; i < policies.length; ++i) {
                if (policies[i] == null) continue;
                this.policyDNMap.put(policies[i].getCaSubject(), policies[i]);
            }
        }
    }

    public synchronized Vector getX509CertList() throws GeneralSecurityException {
        if (this.certList == null) {
            this.certList = PureTLSUtil.certificateChainToVector(this.getCertificates());
        }
        return this.certList;
    }

    public X509Certificate[] getCertificates() {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        Collection certs = this.certSubjectDNMap.values();
        X509Certificate[] retCerts = new X509Certificate[certs.size()];
        Iterator iterator = certs.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            retCerts[i++] = (X509Certificate)iterator.next();
        }
        return retCerts;
    }

    public X509Certificate getCertificate(String subject) {
        if (this.certSubjectDNMap == null) {
            return null;
        }
        return (X509Certificate)this.certSubjectDNMap.get(subject);
    }

    public SigningPolicy[] getSigningPolicies() {
        if (this.policyDNMap == null) {
            return null;
        }
        Collection values = this.policyDNMap.values();
        SigningPolicy[] policies = new SigningPolicy[values.size()];
        Iterator iterator = values.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            policies[i++] = (SigningPolicy)iterator.next();
        }
        return policies;
    }

    public SigningPolicy getSigningPolicy(String subject) {
        if (this.policyDNMap == null) {
            return null;
        }
        return (SigningPolicy)this.policyDNMap.get(subject);
    }

    public static X509Certificate[] loadCertificates(String locations) {
        TrustedCertificates tc = TrustedCertificates.load(locations);
        return tc == null ? null : tc.getCertificates();
    }

    public static TrustedCertificates load(String locations) {
        TrustedCertificates tc = new TrustedCertificates();
        tc.reload(locations);
        return tc;
    }

    public static FilenameFilter getCertFilter() {
        return certFileFilter;
    }

    public void refresh() {
        this.reload(null);
    }

    public synchronized void reload(String locations) {
        if (locations == null) {
            return;
        }
        this.changed = false;
        StringTokenizer tokens = new StringTokenizer(locations, ",");
        File caFile = null;
        HashMap newCertFileMap = new HashMap();
        HashMap newCertSubjectDNMap = new HashMap();
        HashMap newSigningFileMap = new HashMap();
        HashMap newSigningDNMap = new HashMap();
        while (tokens.hasMoreTokens()) {
            caFile = new File(tokens.nextToken().toString().trim());
            if (!caFile.canRead()) {
                logger.debug("Cannot read: " + caFile.getAbsolutePath());
                continue;
            }
            if (caFile.isDirectory()) {
                String[] caCertFiles = caFile.list(TrustedCertificates.getCertFilter());
                if (caCertFiles == null) {
                    logger.debug("Cannot load certificates from " + caFile.getAbsolutePath() + " directory.");
                    continue;
                }
                logger.debug("Loading certificates from " + caFile.getAbsolutePath() + " directory.");
                for (int i = 0; i < caCertFiles.length; ++i) {
                    String caFilename = caFile.getPath() + File.separatorChar + caCertFiles[i];
                    File caFilenameFile = new File(caFilename);
                    String policyFilename = this.getPolicyFileName(caFilename);
                    File policyFile = new File(policyFilename);
                    if (caFilenameFile.canRead()) {
                        this.loadCert(caFilename, caFilenameFile.lastModified(), newCertFileMap, newCertSubjectDNMap, policyFilename, policyFile.lastModified(), newSigningFileMap, newSigningDNMap);
                        continue;
                    }
                    logger.debug("Cannot read: " + caFilenameFile.getAbsolutePath());
                }
                continue;
            }
            String caFilename = caFile.getAbsolutePath();
            String policyFilename = this.getPolicyFileName(caFilename);
            File policyFile = new File(policyFilename);
            this.loadCert(caFilename, caFile.lastModified(), newCertFileMap, newCertSubjectDNMap, policyFilename, policyFile.lastModified(), newSigningFileMap, newSigningDNMap);
        }
        if (!this.changed && this.certFileMap != null && this.certFileMap.size() != newCertFileMap.size()) {
            this.changed = true;
        }
        this.certFileMap = newCertFileMap;
        this.certSubjectDNMap = newCertSubjectDNMap;
        this.policyFileMap = newSigningFileMap;
        this.policyDNMap = newSigningDNMap;
        if (this.changed) {
            this.certList = null;
        }
    }

    private void loadCert(String certPath, long latestLastModified, Map newCertFileMap, Map newCertSubjectDNMap, String policyPath, long policyModified, Map newPolicyFileMap, Map newPolicyDNMap) {
        X509Certificate cert = null;
        if (this.certFileMap == null) {
            this.certFileMap = new HashMap();
        }
        if (this.policyFileMap == null) {
            this.policyFileMap = new HashMap();
        }
        TimestampEntry certEntry = (TimestampEntry)this.certFileMap.get(certPath);
        TimestampEntry policyEntry = (TimestampEntry)this.policyFileMap.get(policyPath);
        try {
            if (certEntry == null) {
                logger.debug("Loading " + certPath + " certificate.");
                cert = CertUtil.loadCertificate(certPath);
                String caDN = cert.getSubjectDN().getName();
                certEntry = new TimestampEntry();
                certEntry.setValue(cert);
                certEntry.setLastModified(latestLastModified);
                certEntry.setDescription(caDN);
                this.changed = true;
                logger.debug("Loading " + policyPath + " signing policy.");
                policyEntry = this.getPolicyEntry(policyPath, policyModified, caDN);
            } else if (latestLastModified > certEntry.getLastModified()) {
                logger.debug("Reloading " + certPath + " certificate.");
                cert = CertUtil.loadCertificate(certPath);
                String caDN = cert.getSubjectDN().getName();
                certEntry.setValue(cert);
                certEntry.setLastModified(latestLastModified);
                certEntry.setDescription(caDN);
                this.changed = true;
                if (policyModified > policyEntry.getLastModified()) {
                    logger.debug("Reloading " + policyPath + " signing policy.");
                    policyEntry = this.getPolicyEntry(policyPath, policyModified, caDN);
                }
            } else {
                logger.debug("Certificate " + certPath + " is up-to-date.");
                cert = (X509Certificate)certEntry.getValue();
                String caDN = cert.getSubjectDN().getName();
                if (policyModified > policyEntry.getLastModified()) {
                    logger.debug("Reloading " + policyPath + " signing policy.");
                    policyEntry = this.getPolicyEntry(policyPath, policyModified, caDN);
                }
            }
            newCertFileMap.put(certPath, certEntry);
            newCertSubjectDNMap.put(certEntry.getDescription(), cert);
            newPolicyFileMap.put(policyPath, policyEntry);
            newPolicyDNMap.put(policyEntry.getDescription(), policyEntry.getValue());
        }
        catch (SigningPolicyParserException e) {
            logger.warn("Signing policy " + policyPath + " failed to load. " + e.getMessage());
            logger.debug("Signing policy load error", e);
        }
        catch (IOException e) {
            logger.warn("Certificate " + certPath + " failed to load." + e.getMessage());
            logger.debug("Certificate load error", e);
        }
        catch (Exception e) {
            logger.warn("Certificate " + certPath + " or Signing policy " + policyPath + " failed to load. " + e.getMessage());
            logger.debug("Certificate/Signing policy load error.", e);
        }
    }

    private TimestampEntry getPolicyEntry(String policyPath, long policyModified, String caDN) throws SigningPolicyParserException {
        logger.debug("Policy path " + policyPath);
        logger.debug("caDN as is " + caDN);
        String globusDN = CertUtil.toGlobusID(caDN, true);
        SigningPolicy policy = null;
        File policyFile = new File(policyPath);
        if (policyFile.exists()) {
            policy = SigningPolicyParser.getPolicy(policyPath, globusDN);
        }
        TimestampEntry policyEntry = new TimestampEntry();
        policyEntry.setValue(policy);
        policyEntry.setLastModified(policyModified);
        policyEntry.setDescription(globusDN);
        return policyEntry;
    }

    private String getPolicyFileName(String caFileName) {
        return caFileName.substring(0, caFileName.lastIndexOf(".")) + SIGNING_POLICY_FILE_SUFFIX;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public static synchronized TrustedCertificates getDefaultTrustedCertificates() {
        return TrustedCertificates.getDefault();
    }

    public static void setDefaultTrustedCertificates(TrustedCertificates trusted) {
        trustedCertificates = trusted;
    }

    public static synchronized TrustedCertificates getDefault() {
        if (trustedCertificates == null) {
            trustedCertificates = new DefaultTrustedCertificates();
        }
        trustedCertificates.refresh();
        return trustedCertificates;
    }

    public String toString() {
        String returnStr = "";
        returnStr = this.certSubjectDNMap == null ? "Certificate list is empty." : this.certSubjectDNMap.toString();
        returnStr = this.policyDNMap == null ? returnStr + "Signing policy list is empty." : returnStr + this.policyDNMap.toString();
        return returnStr;
    }

    private static class DefaultTrustedCertificates
    extends TrustedCertificates {
        private DefaultTrustedCertificates() {
        }

        @Override
        public void refresh() {
            this.reload(CoGProperties.getDefault().getCaCertLocations());
        }
    }

    public static class CertFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String file) {
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

