/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.io.streams.FTPOutputStream;
import org.ietf.jgss.GSSCredential;

public class GridFTPOutputStream
extends FTPOutputStream {
    public GridFTPOutputStream(GSSCredential cred, String host, int port, String file, boolean append) throws IOException, FTPException {
        this(cred, (Authorization)HostAuthorization.getInstance(), host, port, file, append, true, 1, true);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean reqDCAU) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, true, 1, reqDCAU);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean reqDCAU, long size) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, reqDCAU, true, size);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean reqDCAU, boolean gridftp2, long size) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, true, 1, reqDCAU, gridftp2, size);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean passive, int type, boolean reqDCAU) throws IOException, FTPException {
        this(cred, auth, host, port, file, append, passive, type, reqDCAU, true, -1L);
    }

    public GridFTPOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean append, boolean passive, int type, boolean reqDCAU, boolean useGFD47, long size) throws IOException, FTPException {
        GridFTPClient gridFtp = new GridFTPClient(host, port);
        gridFtp.setAuthorization(auth);
        gridFtp.authenticate(cred);
        boolean bl = this.useGFD47 = useGFD47 && gridFtp.isFeatureSupported("GETPUT");
        if (gridFtp.isFeatureSupported("DCAU")) {
            if (!reqDCAU) {
                gridFtp.setDataChannelAuthentication(DataChannelAuthentication.NONE);
            }
        } else {
            gridFtp.setLocalNoDataChannelAuthentication();
        }
        this.ftp = gridFtp;
        this.put(passive, type, file, append);
    }
}

