/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FeatureList {
    public static final String SIZE = "SIZE";
    public static final String MDTM = "MDTM";
    public static final String PARALLEL = "PARALLEL";
    public static final String ESTO = "ESTO";
    public static final String ERET = "ERET";
    public static final String SBUF = "SBUF";
    public static final String ABUF = "ABUF";
    public static final String DCAU = "DCAU";
    public static final String PIPE = "PIPE";
    public static final String MODEX = "MODEX";
    public static final String GETPUT = "GETPUT";
    public static final String CKSUM = "CKSUM";
    protected final List<Feature> features = new ArrayList<Feature>();

    public FeatureList(String featReplyMsg) {
        StringTokenizer responseTokenizer = new StringTokenizer(featReplyMsg, System.getProperty("line.separator"));
        if (responseTokenizer.hasMoreElements()) {
            responseTokenizer.nextToken();
        }
        while (responseTokenizer.hasMoreElements()) {
            String line = (String)responseTokenizer.nextElement();
            if ((line = line.trim().toUpperCase()).startsWith("211 END")) break;
            String[] splitFeature = line.split(" ");
            if (splitFeature.length == 2) {
                this.features.add(new Feature(splitFeature[0], splitFeature[1]));
                continue;
            }
            this.features.add(new Feature(line));
        }
    }

    public boolean contains(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        String[] tokens = label.split(" ", 2);
        if (tokens.length < 1) {
            throw new IllegalArgumentException("label is empty");
        }
        label = tokens[0].toUpperCase();
        String parms = null;
        if (tokens.length > 1) {
            parms = tokens[1];
        }
        for (Feature feature : this.features) {
            if (!feature.getLabel().equals(label)) continue;
            if (parms == null) {
                return true;
            }
            Feature argFeature = new Feature(label, parms);
            if (!argFeature.equals(feature)) continue;
            return true;
        }
        return false;
    }

    public List<Feature> getFeature(String label) {
        if (label == null) {
            throw new IllegalArgumentException("feature label is null");
        }
        label = label.toUpperCase();
        ArrayList<Feature> foundFeatures = new ArrayList<Feature>();
        for (Feature feature : this.features) {
            if (!feature.getLabel().equals(label)) continue;
            foundFeatures.add(feature);
        }
        return foundFeatures;
    }

    public static final class Feature {
        private final String label;
        private final String parms;

        private Feature(String label) {
            if (label == null) {
                throw new NullPointerException("label is null");
            }
            this.label = label;
            this.parms = null;
        }

        private Feature(String label, String parms) {
            if (label == null) {
                throw new NullPointerException("label is null");
            }
            this.label = label;
            this.parms = parms;
        }

        public String getLabel() {
            return this.label;
        }

        public String getParms() {
            return this.parms;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Feature)) {
                return false;
            }
            Feature aFeature = (Feature)obj;
            if (!this.label.equals(aFeature.label)) {
                return false;
            }
            if (this.parms == null) {
                return aFeature.parms == null;
            }
            return this.parms.equals(aFeature.parms);
        }
    }
}

