/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.Session;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.SimpleTransferThreadFactory;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.dc.TransferThread;
import org.globus.ftp.dc.TransferThreadFactory;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class SimpleDataChannel
extends AbstractDataChannel {
    protected static Log logger = LogFactory.getLog(SimpleDataChannel.class.getName());
    protected SocketBox socketBox;
    protected TransferThread transferThread;
    protected TransferThreadFactory transferThreadFactory;

    public SimpleDataChannel(Session session, SocketBox socketBox) {
        super(session);
        if (socketBox == null) {
            throw new IllegalArgumentException("socketBox is null");
        }
        if (socketBox.getSocket() == null) {
            throw new IllegalArgumentException("socket is null");
        }
        if (session == null) {
            throw new IllegalArgumentException("session is null");
        }
        this.socketBox = socketBox;
        this.transferThreadFactory = new SimpleTransferThreadFactory();
    }

    @Override
    public void close() throws IOException {
        if (this.transferThread != null) {
            this.transferThread.interrupt();
            try {
                this.transferThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.socketBox.setSocket(null);
    }

    @Override
    public void startTransfer(DataSink sink, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.transferThread = this.transferThreadFactory.getTransferSinkThread(this, this.socketBox, sink, localControlChannel, context);
        this.transferThread.start();
    }

    @Override
    public void startTransfer(DataSource source, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.transferThread = this.transferThreadFactory.getTransferSourceThread(this, this.socketBox, source, localControlChannel, context);
        this.transferThread.start();
    }
}

