/*
 * Decompiled with CFR 0.152.
 */
package org.globus.myproxy;

import java.util.List;
import org.globus.myproxy.Params;
import org.ietf.jgss.GSSCredential;

public class GetParams
extends Params {
    private boolean wantTrustroots = false;
    private String credentialName;
    private GSSCredential authzcreds;
    private List voname;
    private List vomses;

    public GetParams() {
        super(0);
    }

    public GetParams(String username, String passphrase) {
        super(0, username, passphrase);
    }

    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public void setWantTrustroots(boolean wantTrustroots) {
        this.wantTrustroots = wantTrustroots;
    }

    public boolean getWantTrustroots() {
        return this.wantTrustroots;
    }

    public void setVoname(List voname) {
        this.voname = voname;
    }

    public List getVoname() {
        return this.voname;
    }

    public void setVomses(List vomses) {
        this.vomses = vomses;
    }

    public List getVomses() {
        return this.vomses;
    }

    public void setAuthzCreds(GSSCredential creds) {
        this.authzcreds = creds;
    }

    public GSSCredential getAuthzCreds() {
        return this.authzcreds;
    }

    @Override
    protected String makeRequest(boolean includePassword) {
        StringBuffer buf = new StringBuffer();
        buf.append(super.makeRequest(includePassword));
        this.add(buf, "CRED_NAME=", this.credentialName);
        this.add(buf, "VONAME=", this.voname);
        this.add(buf, "VOMSES=", this.vomses);
        if (this.wantTrustroots) {
            this.add(buf, "TRUSTED_CERTS=", "1");
        }
        return buf.toString();
    }

    private void add(StringBuffer buf, String prefix, List values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            this.add(buf, prefix, value);
        }
    }
}

