/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.globus.rsl.AbstractRslNode;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RslEvaluationException;

public class RslNode
extends AbstractRslNode {
    protected Map _relations;
    protected Map _bindings;

    public RslNode() {
    }

    public RslNode(int operator) {
        super(operator);
    }

    public Bindings put(Bindings bindings) {
        if (this._bindings == null) {
            this._bindings = new HashMap();
        }
        String attrName = bindings.getAttribute();
        return this._bindings.put(RslNode.canonicalize(attrName), bindings);
    }

    @Override
    public boolean add(Bindings bindings) {
        return this.put(bindings) == null;
    }

    public NameOpValue put(NameOpValue relation) {
        if (this._relations == null) {
            this._relations = new HashMap();
        }
        String attrName = relation.getAttribute();
        return this._relations.put(RslNode.canonicalize(attrName), relation);
    }

    @Override
    public boolean add(NameOpValue relation) {
        return this.put(relation) == null;
    }

    @Override
    public void mergeTo(AbstractRslNode dstNode) {
        Iterator iter = null;
        String attr2 = null;
        super.mergeTo(dstNode);
        if (this._relations != null) {
            for (String attr2 : this._relations.keySet()) {
                NameOpValue nov = dstNode.getParam(attr2);
                if (nov == null) {
                    dstNode.add(this.getParam(attr2));
                    continue;
                }
                nov.merge(this.getParam(attr2));
            }
        }
        if (this._bindings != null) {
            for (String attr2 : this._bindings.keySet()) {
                Bindings bind = dstNode.getBindings(attr2);
                if (bind == null) {
                    dstNode.add(this.getBindings(attr2));
                    continue;
                }
                bind.merge(this.getBindings(attr2));
            }
        }
    }

    @Override
    public NameOpValue getParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (NameOpValue)this._relations.get(RslNode.canonicalize(attribute));
    }

    @Override
    public Bindings getBindings(String attribute) {
        if (this._bindings == null || attribute == null) {
            return null;
        }
        return (Bindings)this._bindings.get(RslNode.canonicalize(attribute));
    }

    @Override
    public NameOpValue removeParam(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (NameOpValue)this._relations.remove(RslNode.canonicalize(attribute));
    }

    @Override
    public Bindings removeBindings(String attribute) {
        if (this._relations == null || attribute == null) {
            return null;
        }
        return (Bindings)this._bindings.remove(RslNode.canonicalize(attribute));
    }

    public Map getRelations() {
        return this._relations;
    }

    public Map getBindings() {
        return this._bindings;
    }

    @Override
    public AbstractRslNode evaluate(Map symbolTable) throws RslEvaluationException {
        Iterator<Object> iter;
        if (symbolTable == null) {
            symbolTable = new HashMap();
        }
        HashMap localSymbolTable = null;
        RslNode finalRsl = new RslNode(this.getOperator());
        if (this._bindings != null && this._bindings.size() > 0) {
            localSymbolTable = new HashMap(symbolTable);
            iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                Bindings binds = this.getBindings((String)iter.next());
                finalRsl.put(binds.evaluate(localSymbolTable));
            }
        } else {
            localSymbolTable = symbolTable;
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.keySet().iterator();
            while (iter.hasNext()) {
                NameOpValue nov = this.getParam((String)iter.next());
                finalRsl.put(nov.evaluate(localSymbolTable));
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            for (AbstractRslNode node : this._specifications) {
                finalRsl.add(node.evaluate(localSymbolTable));
            }
        }
        return finalRsl;
    }

    @Override
    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        Iterator<Object> iter;
        buf.append(this.getOperatorAsString());
        if (this._bindings != null && this._bindings.size() > 0) {
            iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                Bindings binds = this.getBindings((String)iter.next());
                binds.toRSL(buf, explicitConcat);
            }
        }
        if (this._relations != null && this._relations.size() > 0) {
            iter = this._relations.keySet().iterator();
            while (iter.hasNext()) {
                NameOpValue nov = this.getParam((String)iter.next());
                nov.toRSL(buf, explicitConcat);
            }
        }
        if (this._specifications != null && this._specifications.size() > 0) {
            for (AbstractRslNode node : this._specifications) {
                buf.append(" (");
                node.toRSL(buf, explicitConcat);
                buf.append(" )");
            }
        }
    }
}

