/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Map;
import org.globus.rsl.RslEvaluationException;
import org.globus.rsl.Value;

public class VarRef
extends Value {
    protected Value defValue;

    public VarRef(String varReference) {
        this(varReference, null, null);
    }

    public VarRef(String varReference, Value defValue) {
        this(varReference, defValue, null);
    }

    public VarRef(String varReference, Value defValue, Value concatVal) {
        super(varReference, concatVal);
        this.setDefaultValue(defValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VarRef && super.equals(obj)) {
            VarRef other = (VarRef)obj;
            if (this.defValue == null) {
                return other.defValue == null;
            }
            if (other.defValue == null) {
                return false;
            }
            return this.defValue.equals(other.defValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.defValue != null) {
            hashCode += this.defValue.hashCode();
        }
        return hashCode;
    }

    public void setDefaultValue(Value value) {
        this.defValue = value;
    }

    @Override
    public String evaluate(Map symbolTable) throws RslEvaluationException {
        String var = null;
        if (symbolTable != null) {
            var = (String)symbolTable.get(this.value);
        }
        if (var == null && this.defValue != null) {
            var = this.defValue.evaluate(symbolTable);
        }
        if (var == null) {
            throw new RslEvaluationException("Variable '" + this.value + "' not defined.");
        }
        if (this.concatValue == null) {
            return var;
        }
        return var + this.concatValue.evaluate(symbolTable);
    }

    @Override
    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        buf.append("$(");
        buf.append(this.value);
        if (this.defValue != null) {
            buf.append(" ");
            this.defValue.toRSL(buf, explicitConcat);
        }
        buf.append(")");
        if (this.concatValue == null) {
            return;
        }
        if (explicitConcat) {
            buf.append(" # ");
        }
        this.concatValue.toRSL(buf, explicitConcat);
    }

    @Override
    public String getCompleteValue() {
        StringBuffer buf = new StringBuffer();
        buf.append("$(");
        buf.append(this.value);
        buf.append(")");
        if (this.concatValue != null) {
            buf.append(this.concatValue.getCompleteValue());
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.getCompleteValue();
    }
}

