/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.log4j;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class DatePatternConverter
extends PatternConverter {
    private static final char DEFAULT_DATE_TIME_SEPARATOR = 'T';
    private static final char DEFAULT_MSECOND_SEPARATOR = '.';
    private Date date;
    private Calendar calendar;
    private String offset;
    private int size;
    private char separator;
    private char mSeparator;
    private static long lastTime;
    private static char[] lastTimeString;

    public DatePatternConverter(FormattingInfo info, String params) {
        super(info);
        this.init(params);
    }

    protected String convert(LoggingEvent event) {
        return this.format(event.timeStamp);
    }

    protected void init(String params) {
        this.date = new Date();
        this.calendar = Calendar.getInstance();
        block5: for (int i = 0; i < params.length(); ++i) {
            char c = params.charAt(i);
            switch (c) {
                case 'M': {
                    if (i + 1 < params.length()) {
                        this.mSeparator = params.charAt(++i);
                        continue block5;
                    }
                    throw new IllegalArgumentException("Argument required for millisecond separator");
                }
                case 'T': {
                    if (i + 1 < params.length()) {
                        this.separator = params.charAt(++i);
                        continue block5;
                    }
                    throw new IllegalArgumentException("Argument required for time separator");
                }
                case 'Z': 
                case 'z': {
                    this.offset = "Z";
                    this.calendar.setTimeZone(TimeZone.getTimeZone("UTF"));
                    this.size = 23 + this.offset.length();
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option: " + c);
                }
            }
        }
        if (this.mSeparator == '\u0000') {
            this.mSeparator = (char)46;
        }
        if (this.separator == '\u0000') {
            this.separator = (char)84;
        }
        if (this.offset == null) {
            int timeOffset = (this.calendar.get(15) + this.calendar.get(16)) / 1000;
            StringBuffer buf = new StringBuffer(6);
            if (timeOffset < 0) {
                buf.append('-');
                timeOffset = -timeOffset;
            } else {
                buf.append('+');
            }
            int hours = timeOffset / 3600;
            if (hours < 10) {
                buf.append('0');
            }
            buf.append(String.valueOf(hours));
            buf.append(':');
            int minutes = timeOffset % 3600 / 60;
            if (minutes < 10) {
                buf.append('0');
            }
            buf.append(String.valueOf(minutes));
            this.offset = buf.toString();
            this.size = 23 + this.offset.length();
        }
    }

    public String format(long time) {
        StringBuffer sbuf = new StringBuffer(this.size);
        int millis = (int)(time % 1000L);
        if (time - (long)millis != lastTime) {
            String month;
            this.date.setTime(time);
            this.calendar.setTime(this.date);
            int year = this.calendar.get(1);
            sbuf.append(year);
            switch (this.calendar.get(2)) {
                case 0: {
                    month = "-01-";
                    break;
                }
                case 1: {
                    month = "-02-";
                    break;
                }
                case 2: {
                    month = "-03-";
                    break;
                }
                case 3: {
                    month = "-04-";
                    break;
                }
                case 4: {
                    month = "-05-";
                    break;
                }
                case 5: {
                    month = "-06-";
                    break;
                }
                case 6: {
                    month = "-07-";
                    break;
                }
                case 7: {
                    month = "-08-";
                    break;
                }
                case 8: {
                    month = "-09-";
                    break;
                }
                case 9: {
                    month = "-10-";
                    break;
                }
                case 10: {
                    month = "-11-";
                    break;
                }
                case 11: {
                    month = "-12-";
                    break;
                }
                default: {
                    month = "-NA-";
                }
            }
            sbuf.append(month);
            int day = this.calendar.get(5);
            if (day < 10) {
                sbuf.append('0');
            }
            sbuf.append(day);
            sbuf.append(this.separator);
            int hour = this.calendar.get(11);
            if (hour < 10) {
                sbuf.append('0');
            }
            sbuf.append(hour);
            sbuf.append(':');
            int mins = this.calendar.get(12);
            if (mins < 10) {
                sbuf.append('0');
            }
            sbuf.append(mins);
            sbuf.append(':');
            int secs = this.calendar.get(13);
            if (secs < 10) {
                sbuf.append('0');
            }
            sbuf.append(secs);
            sbuf.append(this.mSeparator);
            sbuf.getChars(0, sbuf.length(), lastTimeString, 0);
            lastTime = time - (long)millis;
        } else {
            sbuf.append(lastTimeString);
        }
        if (millis < 100) {
            sbuf.append('0');
        }
        if (millis < 10) {
            sbuf.append('0');
        }
        sbuf.append(millis);
        sbuf.append(this.offset);
        return sbuf.toString();
    }

    static {
        lastTimeString = new char[20];
    }
}

