/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.xcede2.catalog;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.nbirn.fbirn.xcede2.catalog.CatalogEntry;
import org.nbirn.fbirn.xcede2.catalog.CatalogException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Catalog {
    static final String XCEDE2NS = "http://www.xcede.org/xcede-2";
    private static final Logger _logger = Logger.getLogger(Catalog.class.getName());
    private String _name;
    private ArrayList<Catalog> _catalogs = new ArrayList();
    private ArrayList<CatalogEntry> _entries = new ArrayList();
    private HashMap<String, Object> _metaFields = new HashMap();

    public Catalog(String name, File file) throws Exception {
        this(name);
        if (file != null) {
            this.parseCatalogFile(file);
        }
    }

    public Catalog(String name) {
        this();
        this._name = name;
    }

    public Catalog() {
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getNumCatalogs() {
        return this._catalogs.size();
    }

    public int getNumEntries() {
        return this._entries.size();
    }

    public Catalog getCatalog(int index) {
        return this._catalogs.get(index);
    }

    public CatalogEntry getEntry(int index) {
        return this._entries.get(index);
    }

    public void addCatalog(Catalog catalog) {
        this._catalogs.add(catalog);
    }

    public void addEntry(CatalogEntry entry) {
        this._entries.add(entry);
    }

    public CatalogEntry addEntry(URI uri, String name) {
        CatalogEntry newentry = new CatalogEntry(uri, name);
        this._entries.add(newentry);
        return newentry;
    }

    private static ArrayList<Element> getChildElementsByTagNameNS(Element elem, String namespaceURI, String localName) throws DOMException {
        ArrayList<Element> retval = new ArrayList<Element>();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !namespaceURI.equals(child.getNamespaceURI()) || !localName.equals(child.getLocalName())) continue;
            retval.add((Element)child);
        }
        return retval;
    }

    public final boolean hasMetaField(String name) {
        return this._metaFields.containsKey(name);
    }

    public final Object getMetaField(String name) {
        return this._metaFields.get(name);
    }

    public final void addMetaField(String name, Object value) {
        _logger.log(Level.FINE, "Catalog.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{name, value});
        this._metaFields.put(name, value);
    }

    protected void addMetaFieldString(String name, String value) {
        _logger.log(Level.FINE, "Catalog.addMetaField:     adding name=''{0}'' value=''{1}''", new Object[]{name, value});
        this.addMetaField(name, value);
    }

    protected CatalogEntry getNewEntry() {
        return new CatalogEntry();
    }

    protected Catalog getNewCatalog() {
        return new Catalog();
    }

    private void readCatalogsFromCatalogList(Element elem) {
        ArrayList<Element> subcats = Catalog.getChildElementsByTagNameNS(elem, XCEDE2NS, "catalog");
        for (int subcatind = 0; subcatind < subcats.size(); ++subcatind) {
            _logger.log(Level.FINE, "parseCatalog:   adding sub-catalog {0} to queue", subcatind);
            this.addCatalog(this.parseAndReturnNewCatalog(subcats.get(subcatind)));
        }
    }

    private void readEntriesFromEntryList(Element elem) {
        ArrayList<Element> entries = Catalog.getChildElementsByTagNameNS(elem, XCEDE2NS, "entry");
        for (int entryind = 0; entryind < entries.size(); ++entryind) {
            Element entryelem = entries.get(entryind);
            try {
                this.addEntry(this.parseAndReturnNewEntry(entryelem));
                continue;
            }
            catch (IllegalArgumentException e) {
                _logger.log(Level.SEVERE, "Error creating entry: {0}: skipping...", e.getMessage());
            }
        }
    }

    private CatalogEntry parseAndReturnNewEntry(Element elem) {
        CatalogEntry entry = this.getNewEntry();
        entry.parseEntry(elem);
        return entry;
    }

    private Catalog parseAndReturnNewCatalog(Element elem) {
        Catalog cat = this.getNewCatalog();
        String name = elem.getAttribute("name");
        if (name != null) {
            cat.setName(name);
        }
        _logger.log(Level.FINE, "parseCatalog: parsing catalog ''{0}''", cat.getName());
        ArrayList<Element> catlists = Catalog.getChildElementsByTagNameNS(elem, XCEDE2NS, "catalogList");
        for (int ind = 0; ind < catlists.size(); ++ind) {
            cat.readCatalogsFromCatalogList(catlists.get(ind));
        }
        ArrayList<Element> entrylists = Catalog.getChildElementsByTagNameNS(elem, XCEDE2NS, "entryList");
        for (int ind = 0; ind < entrylists.size(); ++ind) {
            cat.readEntriesFromEntryList(entrylists.get(ind));
        }
        ArrayList<Element> metafieldslist = Catalog.getChildElementsByTagNameNS(elem, XCEDE2NS, "metaFields");
        for (int ind = 0; ind < metafieldslist.size(); ++ind) {
            ArrayList<Element> metafields = Catalog.getChildElementsByTagNameNS(metafieldslist.get(ind), XCEDE2NS, "metaField");
            for (int mfind = 0; mfind < metafields.size(); ++mfind) {
                String mfname = metafields.get(mfind).getAttribute("name");
                String mfvalue = metafields.get(mfind).getTextContent();
                try {
                    cat.addMetaFieldString(mfname, mfvalue);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    _logger.log(Level.SEVERE, "Error creating entry: {0}: skipping...", e.getMessage());
                }
            }
        }
        return cat;
    }

    public void parseCatalogFile(File catalogFile) throws Exception {
        Document doc = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(catalogFile);
        }
        catch (Exception e) {
            throw new Exception("Error building XML DOM for downloaded catalog.", e);
        }
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("XCEDE") || !root.getNamespaceURI().equals(XCEDE2NS)) {
            throw new Exception("Downloaded catalog does not have a valid XCEDE-2 root element.");
        }
        this.readCatalogsFromCatalogList(root);
    }

    private static void addCatalogToElement(Catalog cat, Element root) throws CatalogException {
        Document doc = root.getOwnerDocument();
        Element catNode = doc.createElementNS(XCEDE2NS, "catalog");
        root.appendChild(catNode);
        catNode.setAttribute("name", cat._name);
        if (!cat._metaFields.isEmpty()) {
            Element metaFields = doc.createElementNS(XCEDE2NS, "metaFields");
            catNode.appendChild(metaFields);
            for (String name : cat._metaFields.keySet()) {
                Object val = cat._metaFields.get(name);
                Element metaField = doc.createElementNS(XCEDE2NS, "metaField");
                metaFields.appendChild(metaField);
                metaField.setAttribute("name", name);
                Text textNode = doc.createTextNode(val.toString());
                metaField.appendChild(textNode);
            }
        }
        if (!cat._catalogs.isEmpty()) {
            Element catalogList = doc.createElementNS(XCEDE2NS, "catalogList");
            catNode.appendChild(catalogList);
            for (Catalog subcat : cat._catalogs) {
                Catalog.addCatalogToElement(subcat, catalogList);
            }
        }
        if (!cat._entries.isEmpty()) {
            Element entryList = doc.createElementNS(XCEDE2NS, "entryList");
            catNode.appendChild(entryList);
            for (CatalogEntry entry : cat._entries) {
                CatalogEntry.addEntryToElement(entry, entryList);
            }
        }
    }

    public void writeCatalogFile(File catalogFile) throws CatalogException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setValidating(false);
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CatalogException("Error creating document builder", e);
        }
        Document doc = dBuilder.newDocument();
        Element root = doc.createElementNS(XCEDE2NS, "XCEDE");
        doc.appendChild(root);
        Catalog.addCatalogToElement(this, root);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(catalogFile);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new CatalogException("Error writing catalog to " + catalogFile.getPath(), e);
        }
    }
}

