/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.impl.compress.TarFileEntryHandler;

public class TarFileEntryHandlerImplementation
implements TarFileEntryHandler {
    private Log log = LogFactory.getLog(TarFileEntryHandlerImplementation.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTarFileEntry(File file, TarArchiveOutputStream taos, String basePath) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            long fileLength = file.length();
            int numRead = 0;
            long totalNumRead = 0L;
            byte[] buffer = new byte[512];
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("processing file " + file.getAbsolutePath()));
            }
            TarArchiveEntry tae = new TarArchiveEntry(file.getAbsolutePath().replace(basePath, ""));
            tae.setSize(fileLength);
            tae.setModTime(file.lastModified());
            taos.putArchiveEntry((ArchiveEntry)tae);
            while ((numRead = ((InputStream)is).read(buffer)) >= 0) {
                taos.write(buffer, 0, numRead);
                totalNumRead += (long)numRead;
            }
            if (totalNumRead != fileLength) {
                throw new IOException("Unable to read file " + file.getAbsolutePath() + " completely");
            }
            taos.closeArchiveEntry();
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }
}

