/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.UntarI;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarDirectoryEntryHandlerImplementation;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.UntarFileEntryHandlerImplementation;
import org.birncommunity.util.MethodParameterChecker;

public class CompressUntar
implements UntarI {
    private Log log = LogFactory.getLog(CompressUntar.class);
    private UntarDirectoryEntryHandler dirEntryHandler = null;
    private UntarFileEntryHandler fileEntryHandler = null;

    public static void main(String[] args) throws Exception {
        CompressUntar cut = new CompressUntar();
        cut.untarFromFile(new File("/tmp/testfile.tar"), new File("/tmp/testdir2"));
    }

    public CompressUntar() {
        this.dirEntryHandler = new UntarDirectoryEntryHandlerImplementation();
        this.fileEntryHandler = new UntarFileEntryHandlerImplementation();
    }

    public CompressUntar(UntarDirectoryEntryHandler d_handler, UntarFileEntryHandler f_handler) {
        this.dirEntryHandler = d_handler;
        this.fileEntryHandler = f_handler;
    }

    public void untarFromStream(InputStream is, File destDir) throws IOException {
        new MethodParameterChecker().verifyNotNull(new Object[]{is, destDir});
        this.checkDirectory(destDir);
        TarArchiveInputStream tais = new TarArchiveInputStream(is);
        TarArchiveEntry tae = null;
        try {
            while ((tae = tais.getNextTarEntry()) != null) {
                if (tae.isDirectory()) {
                    this.dirEntryHandler.handleUntarDirectoryEntry(tae, destDir);
                    continue;
                }
                this.fileEntryHandler.handleUntarFileEntry(tais, destDir, tae);
            }
            byte[] buff = new byte[512];
            while (is.read(buff) >= 0) {
            }
            tais.close();
        }
        catch (IOException e) {
            try {
                is.close();
            }
            catch (Exception e2) {
                this.log.warn((Object)"Failed to close input stream after previous error.", (Throwable)e2);
            }
            throw e;
        }
    }

    public void untarFromFile(File tarFile, File destDir) throws IOException {
        new MethodParameterChecker().verifyNotNull(new Object[]{tarFile, destDir});
        FileInputStream fis = new FileInputStream(tarFile);
        this.untarFromStream(fis, destDir);
    }

    private void checkDirectory(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException(dir.getAbsolutePath() + " is not a directory.");
            }
            if (!dir.canWrite()) {
                throw new IOException(dir.getAbsolutePath() + " cannot be written.");
            }
        } else {
            throw new IOException(dir.getAbsolutePath() + " does not exist.");
        }
    }
}

