/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class SelfAuthorization
extends GSSAuthorization {
    private static Log logger = LogFactory.getLog(SelfAuthorization.class.getName());
    private static SelfAuthorization authorization;

    public static synchronized SelfAuthorization getInstance() {
        if (authorization == null) {
            authorization = new SelfAuthorization();
        }
        return authorization;
    }

    @Override
    public GSSName getExpectedName(GSSCredential cred, String host) throws GSSException {
        if (cred == null) {
            GSSManager manager = ExtendedGSSManager.getInstance();
            cred = manager.createCredential(0);
        }
        return cred.getName();
    }

    @Override
    public void authorize(GSSContext context, String host) throws AuthorizationException {
        logger.debug("Authorization: SELF");
        try {
            if (!context.getSrcName().equals(context.getTargName())) {
                GSSName expected = null;
                GSSName target = null;
                if (context.isInitiator()) {
                    expected = context.getSrcName();
                    target = context.getTargName();
                } else {
                    expected = context.getTargName();
                    target = context.getSrcName();
                }
                this.generateAuthorizationException(expected, target);
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException("Authorization failure", e);
        }
    }
}

