/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.config;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.globus.common.CoGProperties;
import org.globus.tools.ui.config.BaseModule;
import org.globus.tools.ui.swing.MultiLineLabelUI;
import org.globus.tools.ui.util.FileBrowser;
import org.globus.util.Util;

public class ConfigModule3
extends BaseModule {
    private FileBrowser proxyfile;

    public ConfigModule3(CoGProperties props) {
        super(props);
        JLabel label = new JLabel("Configuring Proxy File");
        label.setFont(this.getFont(this.font, 1));
        label.setForeground(Color.black);
        this.add(label, 1, 1, 1, 1);
        label = new JLabel(" \nPlease make sure to set proper access rights\nto the proxy file.\n  ");
        label.setUI(new MultiLineLabelUI());
        label.setFont(this.getFont(this.font, 1));
        this.add(label, 1, 2, 1, 1);
        this.proxyfile = new FileBrowser("Open Proxy File", "Proxy File: ", "Select");
        this.proxyfile.setFile(props.getProxyFile());
        this.add(this.proxyfile, 1, 3, 1, 1);
    }

    @Override
    public void saveSettings() {
        this.props.setProxyFile(this.proxyfile.getFile());
    }

    @Override
    public boolean verifySettings() {
        String msg = null;
        String file = this.proxyfile.getFile();
        if (file.length() == 0) {
            msg = "Proxy file must be specified.";
        } else {
            File f = new File(file);
            if (f.exists()) {
                if (f.isDirectory()) {
                    msg = "Selected file is a directory.";
                } else if (!f.canWrite()) {
                    msg = "Cannot write to the selected file.";
                } else if (!f.canRead()) {
                    msg = "Cannot read from the selected file.";
                }
            } else {
                try {
                    f.createNewFile();
                    Util.setOwnerAccessOnly(f.getAbsolutePath());
                }
                catch (IOException e) {
                    msg = "Unable to create selected file : " + e.getMessage();
                }
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg, "Proxy File Error", 0);
            return false;
        }
        return true;
    }
}

