/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.gridftp.tar.impl.compress;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.gridftp.tar.impl.compress.TarDirectoryEntryHandler;
import org.birncommunity.gridftp.tar.impl.compress.TarFileEntryHandler;
import org.birncommunity.util.FileSystemHelper;

public class TarDirectoryEntryHandlerImplementation
implements TarDirectoryEntryHandler {
    private Log log = LogFactory.getLog(TarDirectoryEntryHandlerImplementation.class);
    private final TarFileEntryHandler fileHandler;

    public TarDirectoryEntryHandlerImplementation(TarFileEntryHandler f_handler) {
        this.fileHandler = f_handler;
    }

    public void handleTarDirectoryEntry(File dir, TarArchiveOutputStream taos, String basePath) throws IOException {
        TarArchiveEntry tae = new TarArchiveEntry(dir.getAbsolutePath().replace(basePath, "") + File.separator);
        tae.setModTime(dir.lastModified());
        taos.putArchiveEntry((ArchiveEntry)tae);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processing directory " + dir.getAbsolutePath()));
        }
        List files = new FileSystemHelper().getDirectoryEntries(dir);
        for (File file : files) {
            if (file.isDirectory()) {
                this.handleTarDirectoryEntry(file, taos, basePath);
                continue;
            }
            this.fileHandler.handleTarFileEntry(file, taos, basePath);
        }
    }
}

