/*
 * Decompiled with CFR 0.152.
 */
package org.globus.replica.rls;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.replica.rls.Administrative;
import org.globus.replica.rls.AttributeResult;
import org.globus.replica.rls.AttributeSearch;
import org.globus.replica.rls.BatchCatalogQuery;
import org.globus.replica.rls.BatchIndexQuery;
import org.globus.replica.rls.CatalogExistenceQuery;
import org.globus.replica.rls.ConfigurationOption;
import org.globus.replica.rls.IndexExistenceQuery;
import org.globus.replica.rls.IndexMapping;
import org.globus.replica.rls.IndexMappingResult;
import org.globus.replica.rls.LocalReplicaCatalog;
import org.globus.replica.rls.Mapping;
import org.globus.replica.rls.MappingResult;
import org.globus.replica.rls.RLIUpdate;
import org.globus.replica.rls.RLSAttribute;
import org.globus.replica.rls.RLSAttributeObject;
import org.globus.replica.rls.RLSConnection;
import org.globus.replica.rls.RLSException;
import org.globus.replica.rls.RLSOffsetLimit;
import org.globus.replica.rls.RLSRLIInfo;
import org.globus.replica.rls.RLSStats;
import org.globus.replica.rls.RLSStatusCode;
import org.globus.replica.rls.RLSString2;
import org.globus.replica.rls.RLSString2Bulk;
import org.globus.replica.rls.Rename;
import org.globus.replica.rls.RenameResult;
import org.globus.replica.rls.ReplicaLocationIndex;
import org.globus.replica.rls.Results;
import org.globus.replica.rls.SimpleCatalogQuery;
import org.globus.replica.rls.SimpleIndexQuery;
import org.globus.replica.rls.impl.SimpleRLSConnectionSource;
import org.globus.replica.rls.impl.rpc.SimpleRLSConnection;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class RLSClient {
    private static final String LOCALRLS = "rls://localhost:39281";
    public static final int RLS_SUCCESS = 0;
    public static final int RLS_GLOBUSERR = 1;
    public static final int RLS_INVHANDLE = 2;
    public static final int RLS_BADURL = 3;
    public static final int RLS_NOMEMORY = 4;
    public static final int RLS_OVERFLOW = 5;
    public static final int RLS_BADARG = 6;
    public static final int RLS_PERM = 7;
    public static final int RLS_BADMETHOD = 8;
    public static final int RLS_INVSERVER = 9;
    public static final int RLS_MAPPING_NEXIST = 10;
    public static final int RLS_LFN_EXIST = 11;
    public static final int RLS_LFN_NEXIST = 12;
    public static final int RLS_PFN_EXIST = 13;
    public static final int RLS_PFN_NEXIST = 14;
    public static final int RLS_LRC_EXIST = 15;
    public static final int RLS_LRC_NEXIST = 16;
    public static final int RLS_DBERROR = 17;
    public static final int RLS_RLI_EXIST = 18;
    public static final int RLS_RLI_NEXIST = 19;
    public static final int RLS_MAPPING_EXIST = 20;
    public static final int RLS_INV_ATTR_TYPE = 21;
    public static final int RLS_ATTR_EXIST = 22;
    public static final int RLS_ATTR_NEXIST = 23;
    public static final int RLS_INV_OBJ_TYPE = 24;
    public static final int RLS_INV_ATTR_OP = 25;
    public static final int RLS_UNSUPPORTED = 26;
    public static final int RLS_TIMEOUT = 27;
    public static final int RLS_TOO_MANY_CONNECTIONS = 28;
    public static final int RLS_ATTR_VALUE_NEXIST = 29;
    public static final int RLS_ATTR_INUSE = 30;
    public static final int ADMIN_PING = 0;
    public static final int ADMIN_QUIT = 1;
    public static final int ADMIN_SSU = 2;
    public static final int RLIFLAG_BLOOMFILTER = 1;
    private static String defaultCertfile = null;
    private static String defaultKeyfile = null;
    private static String defaultProxyfile = null;
    private static Log logger;
    private RLSConnection connection;
    private LocalReplicaCatalog catalog;
    private ReplicaLocationIndex index;
    private Administrative admin;
    private GlobusURL url;
    private LRC lrc;
    private RLI rli;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.globus.replica.rls.RLSClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((String)clazz.getName());
    }

    public RLSClient() throws RLSException {
        this(LOCALRLS);
    }

    public RLSClient(String url) throws RLSException {
        try {
            if (defaultProxyfile != null && defaultProxyfile.length() > 0) {
                this.init(url, (GSSCredential)new GlobusGSSCredentialImpl(new GlobusCredential(defaultProxyfile), 1));
            } else if (defaultCertfile != null && defaultCertfile.length() > 0 && defaultKeyfile != null && defaultKeyfile.length() > 0) {
                this.init(url, (GSSCredential)new GlobusGSSCredentialImpl(new GlobusCredential(defaultProxyfile), 1));
            } else {
                this.init(url, null);
            }
        }
        catch (GlobusCredentialException e) {
            throw new RLSException(1, (Throwable)e);
        }
        catch (GSSException e) {
            throw new RLSException(1, (Throwable)e);
        }
    }

    public RLSClient(String url, String proxyfile) throws RLSException {
        try {
            this.init(url, (GSSCredential)new GlobusGSSCredentialImpl(new GlobusCredential(proxyfile), 1));
        }
        catch (GlobusCredentialException e) {
            throw new RLSException(1, (Throwable)e);
        }
        catch (GSSException e) {
            throw new RLSException(1, (Throwable)e);
        }
    }

    public RLSClient(String url, String certfile, String keyfile) throws RLSException {
        try {
            this.init(url, (GSSCredential)new GlobusGSSCredentialImpl(new GlobusCredential(certfile, keyfile), 1));
        }
        catch (GlobusCredentialException e) {
            throw new RLSException(1, (Throwable)e);
        }
        catch (GSSException e) {
            throw new RLSException(1, (Throwable)e);
        }
    }

    private void init(String url, GSSCredential cred) throws RLSException {
        try {
            this.url = new GlobusURL(url);
        }
        catch (MalformedURLException e) {
            throw new RLSException(1, e.getMessage(), e);
        }
        SimpleRLSConnectionSource source = new SimpleRLSConnectionSource();
        this.connection = source.connect(this.url, cred);
        this.catalog = this.connection.catalog();
        this.index = this.connection.index();
        this.admin = this.connection.admin();
        this.lrc = new LRC();
        this.rli = new RLI();
    }

    public void Admin(int cmd) throws RLSException {
        switch (cmd) {
            case 0: {
                this.admin.ping();
                break;
            }
            case 1: {
                this.admin.quit();
                break;
            }
            case 2: {
                this.admin.update();
                break;
            }
            default: {
                throw new RLSException(6, RLSStatusCode.toMessage(6));
            }
        }
    }

    public static void Certificate(String certfile, String keyfile) {
        defaultCertfile = certfile;
        defaultKeyfile = keyfile;
    }

    public static void ProxyCertificate(String proxyfile) {
        defaultProxyfile = proxyfile;
    }

    public void Close() throws RLSException {
        this.connection.close();
    }

    public String getErrorMessage(int rc) {
        return RLSStatusCode.toMessage(rc);
    }

    public LRC getLRC() {
        return this.lrc;
    }

    public RLI getRLI() {
        return this.rli;
    }

    public int GetTimeout() {
        try {
            return ((SimpleRLSConnection)this.connection).getTimeout() / 1000;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to getTimeout from Socket-based RLSConnection (cause: " + e.getLocalizedMessage() + ")"));
            return -1;
        }
    }

    public void SetTimeout(int seconds) {
        try {
            ((SimpleRLSConnection)this.connection).setTimeout(seconds * 1000);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to setTimeout for Socket-based RLSConnection (cause: " + e.getLocalizedMessage() + ")"));
        }
    }

    public String GetURL() {
        return this.url.getURL();
    }

    public void LRCAttrAdd(String key, RLSAttribute attr) throws RLSException {
        this.lrc.attributeAdd(key, attr);
    }

    public void LRCAttrCreate(String name, int objtype, int valtype) throws RLSException {
        this.lrc.attributeCreate(name, objtype, valtype);
    }

    public void LRCAttrDelete(String name, int objtype, boolean clearvalues) throws RLSException {
        this.lrc.attributeDelete(name, objtype, clearvalues);
    }

    public ArrayList LRCAttrGet(String name, int objtype) throws RLSException {
        return this.lrc.attributeGet(name, objtype);
    }

    public void LRCAttrModify(String key, RLSAttribute attr) throws RLSException {
        this.lrc.attributeModify(key, attr);
    }

    public void LRCAttrRemove(String key, RLSAttribute attr) throws RLSException {
        this.lrc.attributeRemove(key, attr);
    }

    public ArrayList LRCAttrSearch(String name, int objtype, int op, RLSAttribute op1, RLSAttribute op2, RLSOffsetLimit offlim) throws RLSException {
        return this.lrc.attributeSearch(name, objtype, op, op1, op2, offlim);
    }

    public ArrayList LRCAttrValueGet(String key, String name, int objtype) throws RLSException {
        return this.lrc.attributeValueGet(key, name, objtype);
    }

    public void LRCAdd(String lfn, String pfn) throws RLSException {
        this.lrc.add(lfn, pfn);
    }

    public void LRCClear() throws RLSException {
        this.lrc.clear();
    }

    public void LRCCreate(String lfn, String pfn) throws RLSException {
        this.lrc.create(lfn, pfn);
    }

    public void LRCDelete(String lfn, String pfn) throws RLSException {
        this.lrc.delete(lfn, pfn);
    }

    public boolean LRCExists(String key, int objtype) throws RLSException {
        return this.lrc.exists(key, objtype);
    }

    public ArrayList LRCGetLFN(String pfn, RLSOffsetLimit offlim) throws RLSException {
        return this.lrc.getLFN(pfn, offlim);
    }

    public ArrayList LRCGetLFN(String pfn) throws RLSException {
        return this.lrc.getLFN(pfn);
    }

    public ArrayList LRCGetLFNWC(String pfnpat, RLSOffsetLimit offlim) throws RLSException {
        return this.lrc.getLFNWC(pfnpat, offlim);
    }

    public ArrayList LRCGetLFNWC(String pfnpat) throws RLSException {
        return this.lrc.getLFNWC(pfnpat);
    }

    public ArrayList LRCGetPFN(String lfn, RLSOffsetLimit offlim) throws RLSException {
        return this.lrc.getPFN(lfn, offlim);
    }

    public ArrayList LRCGetPFN(String lfn) throws RLSException {
        return this.lrc.getPFN(lfn);
    }

    public ArrayList LRCGetPFNWC(String lfnpat, RLSOffsetLimit offlim) throws RLSException {
        return this.lrc.getPFNWC(lfnpat, offlim);
    }

    public ArrayList LRCGetPFNWC(String lfnpat) throws RLSException {
        return this.lrc.getPFNWC(lfnpat);
    }

    public boolean LRCMappingExists(String lfn, String pfn) throws RLSException {
        return this.lrc.mappingExists(lfn, pfn);
    }

    public void LRCRLIAdd(String rliurl, int flags, String pattern) throws RLSException {
        this.lrc.rliAdd(rliurl, flags, pattern);
    }

    public void LRCRLIDelete(String rliurl, String pattern) throws RLSException {
        this.lrc.rliDelete(rliurl, pattern);
    }

    public ArrayList LRCRLIGetPart(String rliurl, String pattern) throws RLSException {
        return this.lrc.rliGetPart(rliurl, pattern);
    }

    public RLSRLIInfo LRCRLIInfo(String rliurl) throws RLSException {
        return this.lrc.rliInfo(rliurl);
    }

    public ArrayList LRCRLIList() throws RLSException {
        return this.lrc.rliList();
    }

    public ArrayList RLIGetLRC(String lfn, RLSOffsetLimit offlim) throws RLSException {
        return this.rli.getLRC(lfn, offlim);
    }

    public ArrayList RLIGetLRC(String lfn) throws RLSException {
        return this.rli.getLRC(lfn);
    }

    public ArrayList RLIGetLRCWC(String lfnpat, RLSOffsetLimit offlim) throws RLSException {
        return this.rli.getLRCWC(lfnpat, offlim);
    }

    public ArrayList RLIGetLRCWC(String lfnpat) throws RLSException {
        return this.rli.getLRCWC(lfnpat);
    }

    public boolean RLIExists(String key, int objtype) throws RLSException {
        return this.rli.exists(key, objtype);
    }

    public ArrayList RLILRCList() throws RLSException {
        return this.rli.lrcList();
    }

    public boolean RLIMappingExists(String lfn, String lrc) throws RLSException {
        return this.rli.mappingExists(lfn, lrc);
    }

    public ArrayList GetConfiguration(String option) throws RLSException {
        List raw = this.admin.getConfiguration(option);
        ArrayList<RLSString2> results = new ArrayList<RLSString2>(raw.size());
        Iterator iter = raw.iterator();
        while (iter.hasNext()) {
            ConfigurationOption opt = (ConfigurationOption)iter.next();
            results.add(new RLSString2(opt.getName(), opt.getValue()));
        }
        raw.clear();
        return results;
    }

    public int SetConfiguration(String option, String value) throws RLSException {
        this.admin.setConfiguration(option, value);
        return 0;
    }

    public RLSStats Stats() throws RLSException {
        return this.admin.stats();
    }

    public static int OSSystem(String cmd) {
        throw new UnsupportedOperationException("This method is currently unsupported");
    }

    static final List convertRLSString2ToMappings(List str2list) throws RLSException {
        if (str2list == null || str2list.isEmpty() || !(str2list.get(0) instanceof RLSString2)) {
            throw new RLSException(6, "Bad input list: Expected non-empty list of RLSString2 elements.");
        }
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(str2list.size());
        int i = 0;
        while (i < str2list.size()) {
            RLSString2 str2 = (RLSString2)str2list.get(i);
            mappings.add(new Mapping(str2.s1, str2.s2));
            ++i;
        }
        return mappings;
    }

    static final ArrayList convertMappingResultsToRLSString2Bulk(List results, boolean getboth) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            MappingResult result = (MappingResult)iter.next();
            int rc = result.getRC();
            String s1 = null;
            String s2 = null;
            if (rc == 0 || getboth) {
                s1 = result.getLogical();
                s2 = result.getTarget();
            } else {
                s1 = result.getLogical();
                if (s1 == null) {
                    s1 = result.getTarget();
                }
            }
            s2blist.add(new RLSString2Bulk(rc, s1, s2));
        }
        return s2blist;
    }

    static final ArrayList convertMappingResultsToRLSString2(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2> s2list = new ArrayList<RLSString2>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            MappingResult result = (MappingResult)iter.next();
            s2list.add(new RLSString2(result.getLogical(), result.getTarget()));
        }
        return s2list;
    }

    static final ArrayList convertMappingExistsToRLSString2Bulk(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            MappingResult result = (MappingResult)iter.next();
            String str = result.getLogical();
            if (str == null) {
                str = result.getTarget();
            }
            s2blist.add(new RLSString2Bulk(result.getRC(), str, null));
        }
        return s2blist;
    }

    static final ArrayList convertIndexMappingResultsToRLSString2Bulk(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            IndexMappingResult result = (IndexMappingResult)iter.next();
            int rc = result.getRC();
            String s1 = null;
            String s2 = null;
            if (rc == 0) {
                s1 = result.getLogical();
                s2 = result.getCatalog();
            } else {
                s1 = result.getLogical();
                if (s1 == null) {
                    s1 = result.getCatalog();
                }
            }
            s2blist.add(new RLSString2Bulk(rc, s1, s2));
        }
        return s2blist;
    }

    static final ArrayList convertIndexMappingResultsToRLSString2(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2> s2list = new ArrayList<RLSString2>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            IndexMappingResult result = (IndexMappingResult)iter.next();
            s2list.add(new RLSString2(result.getLogical(), result.getCatalog()));
        }
        return s2list;
    }

    static final ArrayList convertIndexMappingExistsToRLSString2Bulk(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            IndexMappingResult result = (IndexMappingResult)iter.next();
            String str = result.getLogical();
            if (str == null) {
                str = result.getCatalog();
            }
            s2blist.add(new RLSString2Bulk(result.getRC(), str, null));
        }
        return s2blist;
    }

    static final ArrayList convertAttributeResultsToRLSString2Bulk(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            AttributeResult result = (AttributeResult)iter.next();
            s2blist.add(new RLSString2Bulk(result.getRC(), result.getKey()));
        }
        return s2blist;
    }

    static final List convertRLSString2ToRenames(List str2list) throws RLSException {
        if (str2list == null || str2list.isEmpty() || !(str2list.get(0) instanceof RLSString2)) {
            throw new RLSException(6, "Bad input list: Expected non-empty list of RLSString2 elements.");
        }
        ArrayList<Rename> renames = new ArrayList<Rename>(str2list.size());
        int i = 0;
        while (i < str2list.size()) {
            RLSString2 str2 = (RLSString2)str2list.get(i);
            renames.add(new Rename(str2.s1, str2.s2));
            ++i;
        }
        return renames;
    }

    static final ArrayList convertRenameResultsToRLSString2Bulk(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2Bulk> s2blist = new ArrayList<RLSString2Bulk>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            RenameResult result = (RenameResult)iter.next();
            s2blist.add(new RLSString2Bulk(result.getRC(), result.getFrom(), result.getTo()));
        }
        return s2blist;
    }

    static final ArrayList convertRLAttributeObjectsToRLSAttributes(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSAttribute> attrlist = new ArrayList<RLSAttribute>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            RLSAttributeObject aobj = (RLSAttributeObject)iter.next();
            attrlist.add(aobj.attr);
            aobj.attr = null;
            aobj.key = null;
        }
        results.clear();
        return attrlist;
    }

    static final ArrayList convertRLIUpdateToRLSString2(List results) {
        if (results == null) {
            return null;
        }
        ArrayList<RLSString2> s2list = new ArrayList<RLSString2>(results.size());
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            RLIUpdate upd = (RLIUpdate)iter.next();
            String pattern = upd.getPattern();
            if (pattern == null) {
                pattern = "";
            }
            s2list.add(new RLSString2(upd.getUrl(), pattern));
        }
        return s2list;
    }

    public class LRC {
        public void add(String lfn, String pfn) throws RLSException {
            if (lfn == null || pfn == null) {
                throw new RLSException(6, "Invalid arguments: null");
            }
            ArrayList<Mapping> mappings = new ArrayList<Mapping>(1);
            mappings.add(new Mapping(lfn, pfn));
            List results = RLSClient.this.catalog.addMappings(mappings);
            if (results != null && !results.isEmpty()) {
                MappingResult result = (MappingResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList addBulk(ArrayList str2list) throws RLSException {
            List mappings = RLSClient.convertRLSString2ToMappings(str2list);
            List results = RLSClient.this.catalog.addMappings(mappings);
            ArrayList s2blist = RLSClient.convertMappingResultsToRLSString2Bulk(results, true);
            if (results != null) {
                results.clear();
            }
            return s2blist;
        }

        public void attributeAdd(String key, RLSAttribute attr) throws RLSException {
            ArrayList<RLSAttributeObject> attrs = new ArrayList<RLSAttributeObject>(1);
            attrs.add(new RLSAttributeObject(attr, key));
            List results = RLSClient.this.catalog.addAttributes(attrs);
            if (results != null && !results.isEmpty()) {
                AttributeResult result = (AttributeResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList attributeAddBulk(ArrayList attr_obj_list) throws RLSException {
            List results = RLSClient.this.catalog.addAttributes(attr_obj_list);
            ArrayList s2blist = RLSClient.convertAttributeResultsToRLSString2Bulk(results);
            results.clear();
            return s2blist;
        }

        public void attributeCreate(String name, int objtype, int valtype) throws RLSException {
            ArrayList<RLSAttribute> attrs = new ArrayList<RLSAttribute>(1);
            attrs.add(new RLSAttribute(name, objtype, valtype));
            List results = RLSClient.this.catalog.defineAttributes(attrs);
            if (results != null && !results.isEmpty()) {
                AttributeResult result = (AttributeResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public void attributeDelete(String name, int objtype, boolean clearvalues) throws RLSException {
            ArrayList<RLSAttribute> attrs = new ArrayList<RLSAttribute>(1);
            attrs.add(new RLSAttribute(name, objtype, 0));
            List results = RLSClient.this.catalog.undefineAttributes(attrs, clearvalues);
            if (results != null && !results.isEmpty()) {
                AttributeResult result = (AttributeResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList attributeGet(String name, int objtype) throws RLSException {
            RLSAttribute attr = new RLSAttribute(name, objtype, -1);
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryAttributeDefinitions, attr, null);
            Results results = RLSClient.this.catalog.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC(), RLSStatusCode.toMessage(results.getRC()));
            }
            return new ArrayList(results.getBatch());
        }

        public void attributeModify(String key, RLSAttribute attr) throws RLSException {
            ArrayList<RLSAttributeObject> attrs = new ArrayList<RLSAttributeObject>(1);
            attrs.add(new RLSAttributeObject(attr, key));
            List results = RLSClient.this.catalog.modifyAttributes(attrs);
            if (results != null && !results.isEmpty()) {
                AttributeResult result = (AttributeResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public void attributeRemove(String key, RLSAttribute attr) throws RLSException {
            ArrayList<RLSAttributeObject> attrs = new ArrayList<RLSAttributeObject>(1);
            attrs.add(new RLSAttributeObject(attr, key));
            List results = RLSClient.this.catalog.removeAttributes(attrs);
            if (results != null && !results.isEmpty()) {
                AttributeResult result = (AttributeResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList attributeRemoveBulk(ArrayList attr_obj_list) throws RLSException {
            List results = RLSClient.this.catalog.removeAttributes(attr_obj_list);
            ArrayList s2blist = RLSClient.convertAttributeResultsToRLSString2Bulk(results);
            results.clear();
            return s2blist;
        }

        public ArrayList attributeSearch(String name, int objtype, int op, RLSAttribute op1, RLSAttribute op2, RLSOffsetLimit offlim) throws RLSException {
            AttributeSearch qry = new AttributeSearch(name, objtype, op, op1, op2, offlim);
            Results results = RLSClient.this.catalog.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC(), RLSStatusCode.toMessage(results.getRC()));
            }
            return new ArrayList(results.getBatch());
        }

        public ArrayList attributeValueGet(String key, String name, int objtype) throws RLSException {
            if (name == null) {
                name = "";
            }
            ArrayList<String> keylist = new ArrayList<String>(1);
            keylist.add(key);
            BatchCatalogQuery qry = new BatchCatalogQuery(keylist, name, new Integer(objtype));
            Results results = RLSClient.this.catalog.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC(), RLSStatusCode.toMessage(results.getRC()));
            }
            ArrayList output = RLSClient.convertRLAttributeObjectsToRLSAttributes(results.getBatch());
            return output != null ? output : new ArrayList();
        }

        public ArrayList attributeValueGetBulk(ArrayList keylist, String name, int objtype) throws RLSException {
            if (name == null) {
                name = "";
            }
            BatchCatalogQuery qry = new BatchCatalogQuery(keylist, name, new Integer(objtype));
            Results results = RLSClient.this.catalog.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC(), RLSStatusCode.toMessage(results.getRC()));
            }
            return new ArrayList(results.getBatch());
        }

        public void clear() throws RLSException {
            throw new RLSException(8, "The clear method is no longer supported. The clear operation cannot gaurantee consistency should only be used from the RLS client in a development environment.");
        }

        public void create(String lfn, String pfn) throws RLSException {
            if (lfn == null || pfn == null) {
                throw new RLSException(6, "Invalid arguments: null");
            }
            ArrayList<Mapping> mappings = new ArrayList<Mapping>(1);
            mappings.add(new Mapping(lfn, pfn));
            List results = RLSClient.this.catalog.createMappings(mappings);
            if (results != null && !results.isEmpty()) {
                MappingResult result = (MappingResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList createBulk(ArrayList str2list) throws RLSException {
            List mappings = RLSClient.convertRLSString2ToMappings(str2list);
            List results = RLSClient.this.catalog.createMappings(mappings);
            ArrayList s2blist = RLSClient.convertMappingResultsToRLSString2Bulk(results, true);
            if (results != null) {
                results.clear();
            }
            return s2blist;
        }

        public void delete(String lfn, String pfn) throws RLSException {
            if (lfn == null || pfn == null) {
                throw new RLSException(6, "Invalid arguments: null");
            }
            ArrayList<Mapping> mappings = new ArrayList<Mapping>(1);
            mappings.add(new Mapping(lfn, pfn));
            List results = RLSClient.this.catalog.deleteMappings(mappings);
            if (results != null && !results.isEmpty()) {
                MappingResult result = (MappingResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList deleteBulk(ArrayList str2list) throws RLSException {
            List mappings = RLSClient.convertRLSString2ToMappings(str2list);
            List results = RLSClient.this.catalog.deleteMappings(mappings);
            ArrayList s2blist = RLSClient.convertMappingResultsToRLSString2Bulk(results, true);
            if (results != null) {
                results.clear();
            }
            return s2blist;
        }

        public boolean exists(String key, int objtype) throws RLSException {
            ArrayList<String> batch = new ArrayList<String>(1);
            batch.add(key);
            CatalogExistenceQuery qry = new CatalogExistenceQuery(CatalogExistenceQuery.objectExists, batch, new Integer(objtype));
            Results results = RLSClient.this.catalog.query(qry);
            return results.getRC() == 0;
        }

        public ArrayList existsBulk(ArrayList strlist, int objtype) throws RLSException {
            CatalogExistenceQuery qry = new CatalogExistenceQuery(CatalogExistenceQuery.objectExists, strlist, new Integer(objtype));
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingExistsToRLSString2Bulk(results.getBatch());
        }

        public ArrayList getLFN(String pfn, RLSOffsetLimit offlim) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByTargetName, pfn, offlim);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLFN(String pfn) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByTargetName, pfn, null);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLFNBulk(ArrayList strlist) throws RLSException {
            BatchCatalogQuery qry = new BatchCatalogQuery(BatchCatalogQuery.mappingQueryByTargetNames, strlist);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2Bulk(results.getBatch(), false);
        }

        public ArrayList getLFNWC(String pfnpat, RLSOffsetLimit offlim) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByTargetNamePattern, pfnpat, offlim);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLFNWC(String pfnpat) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByTargetNamePattern, pfnpat, null);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getPFN(String lfn, RLSOffsetLimit offlim) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByLogicalName, lfn, offlim);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getPFNBulk(ArrayList strlist) throws RLSException {
            BatchCatalogQuery qry = new BatchCatalogQuery(BatchCatalogQuery.mappingQueryByLogicalNames, strlist);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2Bulk(results.getBatch(), false);
        }

        public ArrayList getPFN(String lfn) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByLogicalName, lfn, null);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getPFNWC(String lfnpat, RLSOffsetLimit offlim) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByLogicalNamePattern, lfnpat, offlim);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getPFNWC(String lfnpat) throws RLSException {
            SimpleCatalogQuery qry = new SimpleCatalogQuery(SimpleCatalogQuery.queryMappingsByLogicalNamePattern, lfnpat, null);
            Results results = RLSClient.this.catalog.query(qry);
            return RLSClient.convertMappingResultsToRLSString2(results.getBatch());
        }

        public boolean mappingExists(String lfn, String pfn) throws RLSException {
            ArrayList<Mapping> batch = new ArrayList<Mapping>(1);
            batch.add(new Mapping(lfn, pfn));
            CatalogExistenceQuery qry = new CatalogExistenceQuery(CatalogExistenceQuery.mappingExists, batch);
            Results results = RLSClient.this.catalog.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC());
            }
            MappingResult r = (MappingResult)results.getBatch().get(0);
            return r.getRC() == 0;
        }

        public void renameLFN(String from, String to) throws RLSException {
            if (from == null || to == null) {
                throw new RLSException(6, "Invalid arguments: null");
            }
            ArrayList<Rename> renames = new ArrayList<Rename>(1);
            renames.add(new Rename(from, to));
            List results = RLSClient.this.catalog.renameLogicalNames(renames);
            if (results != null && !results.isEmpty()) {
                RenameResult result = (RenameResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList renameLFNBulk(ArrayList str2list) throws RLSException {
            List renames = RLSClient.convertRLSString2ToRenames(str2list);
            List results = RLSClient.this.catalog.renameLogicalNames(renames);
            ArrayList s2blist = RLSClient.convertRenameResultsToRLSString2Bulk(results);
            if (results != null) {
                results.clear();
            }
            return s2blist;
        }

        public void renamePFN(String from, String to) throws RLSException {
            if (from == null || to == null) {
                throw new RLSException(6, "Invalid arguments: null");
            }
            ArrayList<Rename> renames = new ArrayList<Rename>(1);
            renames.add(new Rename(from, to));
            List results = RLSClient.this.catalog.renameTargetNames(renames);
            if (results != null && !results.isEmpty()) {
                RenameResult result = (RenameResult)results.get(0);
                results.clear();
                throw new RLSException(result.getRC(), RLSStatusCode.toMessage(result.getRC()));
            }
        }

        public ArrayList renamePFNBulk(ArrayList str2list) throws RLSException {
            List renames = RLSClient.convertRLSString2ToRenames(str2list);
            List results = RLSClient.this.catalog.renameTargetNames(renames);
            ArrayList s2blist = RLSClient.convertRenameResultsToRLSString2Bulk(results);
            if (results != null) {
                results.clear();
            }
            return s2blist;
        }

        public void rliAdd(String rliurl, int flags, String pattern) throws RLSException {
            RLSClient.this.admin.addUpdate(new RLIUpdate(rliurl, flags, pattern));
        }

        public void rliDelete(String rliurl, String pattern) throws RLSException {
            RLSClient.this.admin.deleteUpdate(new RLIUpdate(rliurl, pattern));
        }

        public ArrayList rliGetPart(String rliurl, String pattern) throws RLSException {
            List results = RLSClient.this.admin.listUpdatePartitions(new RLIUpdate(rliurl, pattern));
            return RLSClient.convertRLIUpdateToRLSString2(results);
        }

        public RLSRLIInfo rliInfo(String rliurl) throws RLSException {
            return RLSClient.this.admin.findUpdate(rliurl);
        }

        public ArrayList rliList() throws RLSException {
            return new ArrayList(RLSClient.this.admin.listUpdates());
        }
    }

    public class RLI {
        public ArrayList getLRC(String lfn, RLSOffsetLimit offlim) throws RLSException {
            SimpleIndexQuery qry = new SimpleIndexQuery(SimpleIndexQuery.queryMappingsByLogicalName, lfn, offlim);
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLRC(String lfn) throws RLSException {
            SimpleIndexQuery qry = new SimpleIndexQuery(SimpleIndexQuery.queryMappingsByLogicalName, lfn, null);
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLRCBulk(ArrayList strlist) throws RLSException {
            BatchIndexQuery qry = new BatchIndexQuery(BatchIndexQuery.queryMappingsByLogicalNames, strlist);
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingResultsToRLSString2Bulk(results.getBatch());
        }

        public ArrayList getLRCWC(String lfnpat, RLSOffsetLimit offlim) throws RLSException {
            SimpleIndexQuery qry = new SimpleIndexQuery(SimpleIndexQuery.queryMappingsByLogicalNamePattern, lfnpat, offlim);
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingResultsToRLSString2(results.getBatch());
        }

        public ArrayList getLRCWC(String lfnpat) throws RLSException {
            SimpleIndexQuery qry = new SimpleIndexQuery(SimpleIndexQuery.queryMappingsByLogicalNamePattern, lfnpat, null);
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingResultsToRLSString2(results.getBatch());
        }

        public boolean exists(String key, int objtype) throws RLSException {
            ArrayList<String> batch = new ArrayList<String>(1);
            batch.add(key);
            IndexExistenceQuery qry = new IndexExistenceQuery(IndexExistenceQuery.objectExists, batch, new Integer(objtype));
            Results results = RLSClient.this.index.query(qry);
            return results.getRC() == 0;
        }

        public ArrayList existsBulk(ArrayList strlist, int objtype) throws RLSException {
            IndexExistenceQuery qry = new IndexExistenceQuery(IndexExistenceQuery.objectExists, strlist, new Integer(objtype));
            Results results = RLSClient.this.index.query(qry);
            return RLSClient.convertIndexMappingExistsToRLSString2Bulk(results.getBatch());
        }

        public ArrayList lrcList() throws RLSException {
            return new ArrayList(RLSClient.this.admin.updatedBy());
        }

        public boolean mappingExists(String lfn, String lrc) throws RLSException {
            ArrayList<IndexMapping> batch = new ArrayList<IndexMapping>(1);
            batch.add(new IndexMapping(lfn, lrc));
            IndexExistenceQuery qry = new IndexExistenceQuery(IndexExistenceQuery.mappingExists, batch);
            Results results = RLSClient.this.index.query(qry);
            if (results.getRC() != 0) {
                throw new RLSException(results.getRC());
            }
            IndexMappingResult r = (IndexMappingResult)results.getBatch().get(0);
            return r.getRC() == 0;
        }

        public ArrayList rliList() throws RLSException {
            return new ArrayList(RLSClient.this.admin.listRliToRliUpdates());
        }
    }
}

