/*
 * Decompiled with CFR 0.152.
 */
package org.globus.replica.rls.impl.rpc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class RPCInputStream
extends FilterInputStream {
    private final int EOS = -1;
    private final int TERMINATOR = 0;
    private final boolean DEBUG = false;
    private static final String RLS_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    RPCInputStream(InputStream in) {
        super(in);
    }

    public final int readInt() throws IOException {
        return Integer.parseInt(this.readString());
    }

    public final Integer readInteger() throws IOException {
        String s = this.readString();
        if (s == null || s.length() == 0) {
            return null;
        }
        return new Integer(s);
    }

    public final double readDouble() throws IOException {
        return Double.parseDouble(this.readString());
    }

    public final Date readDate() throws IOException {
        String raw = this.readString();
        try {
            return this.sdf.parse(raw);
        }
        catch (ParseException pe) {
            throw new IOException("Failed to parse date from stream (cause: " + pe.getMessage() + ")");
        }
    }

    public final String readString() throws IOException {
        StringBuffer buffer = new StringBuffer();
        int b = this.read();
        while (b > 0) {
            buffer.append((char)b);
            b = this.read();
        }
        this._debug(buffer.toString());
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private void _debug(String msg) {
    }
}

